/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.File;
import java.io.IOException;
import weblogic.utils.StringUtils;
import weblogic.utils.UnsyncStringBuffer;

public final class FilenameEncoder {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static String OS_NAME = null;
    private static boolean windowsOS = false;
    private static String USER_DIR = null;
    private static final char[] LEGAL_FILE_CHARS;
    private static final char SPECIAL = 'Z';

    public static String encode(String string) {
        return FilenameEncoder.encode(string.getBytes());
    }

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(90 - byArray.length % 5));
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3;
            long l = 0L;
            for (n3 = 4; n3 >= 0; --n3) {
                l |= n < n2 ? ((long)byArray[n++] & 0xFFL) << 8 * n3 : 0L;
            }
            for (n3 = 7; n3 >= 0; --n3) {
                int n4 = (int)(l >> 5 * n3 & 0x1FL);
                stringBuffer.append(LEGAL_FILE_CHARS[n4]);
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 90 - cArray[0];
        int n3 = cArray.length - 1;
        int n4 = n2 == 0 ? n3 / 8 * 5 : n3 / 8 * 5 - (5 - n2);
        byte[] byArray = new byte[n4];
        int n5 = 1;
        int n6 = cArray.length;
        while (n5 < n6) {
            int n7;
            long l = 0L;
            for (n7 = 7; n7 >= 0; --n7) {
                int n8 = FilenameEncoder.reverseMap(cArray[n5++]);
                l |= ((long)n8 & 0x1FL) << 5 * n7;
            }
            for (n7 = 4; n7 >= 0 && n < byArray.length; --n7) {
                byArray[n++] = (byte)(l >> 8 * n7);
            }
        }
        return byArray;
    }

    private static int reverseMap(char c) {
        if (c < 'A') {
            return c - 48;
        }
        return c - 65 + 10;
    }

    private static boolean isLegalChar(char c) {
        return true;
    }

    public static File getSafeFile(String string, String string2) throws IOException, UnsafeFilenameException {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c < '!' || c == '~') {
                return FilenameEncoder.getSafeFile0(string, string2);
            }
            if (c != '.' || i != string2.length() - 1 && string2.charAt(i + 1) != '.') continue;
            return FilenameEncoder.getSafeFile0(string, string2);
        }
        return new File(string, string2);
    }

    public static File getSafeFile0(String string, String string2) throws IOException, UnsafeFilenameException {
        char c;
        if (string.indexOf("..") != -1) {
            string = FilenameEncoder.resolveRelativeFilePath(string);
        }
        String string3 = File.separator;
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer(string);
        if (string.endsWith(string3)) {
            if (string2.startsWith(string3)) {
                unsyncStringBuffer.append(string2.substring(1));
            } else {
                unsyncStringBuffer.append(string2);
            }
        } else if (string2.startsWith(string3)) {
            unsyncStringBuffer.append(string2);
        } else {
            unsyncStringBuffer.append(string3).append(string2);
        }
        String string4 = unsyncStringBuffer.toString();
        File file = null;
        if (string4.indexOf(0) != -1) {
            throw new UnsafeFilenameException("Filename contains illegal NULL-character \\u0000");
        }
        if (string4.indexOf("~") != -1 && !windowsOS) {
            file = new File(string4);
            File file2 = new File(string);
            string4 = file.getCanonicalPath();
            if (!string4.startsWith(file2.getCanonicalPath())) {
                throw new UnsafeFilenameException(string4 + " not under: " + string);
            }
        }
        if (((c = string4.charAt(string4.length() - 1)) < '!' || c == '.') && windowsOS) {
            throw new UnsafeFilenameException(string4 + " ends with illegal character");
        }
        if (string4.indexOf("..") != -1 && !(string4 = FilenameEncoder.resolveRelativeFilePath(string4)).startsWith(string)) {
            throw new UnsafeFilenameException(string4 + " not under: " + string);
        }
        return new File(string4);
    }

    public static String resolveRelativeURIPath(String string) {
        return FilenameEncoder.resolveRelativeURIPath(string, false);
    }

    public static String resolveRelativeURIPath(String string, boolean bl) {
        return FilenameEncoder.resolveRelativePath(string, '/', bl, false);
    }

    public static String resolveRelativeFilePath(String string) {
        boolean bl = System.getProperty("os.name", "unknown").toLowerCase().indexOf("windows") >= 0;
        return FilenameEncoder.resolveRelativePath(string, File.separatorChar, false, bl);
    }

    private static String resolveRelativePath(String string, char c, boolean bl, boolean bl2) {
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 != c) continue;
            if (i == string.length() - 1) break;
            c2 = string.charAt(i + 1);
            if (c2 != c && c2 != '.') continue;
            return FilenameEncoder.resolveRelativePath0(string, c, bl, bl2);
        }
        return string;
    }

    private static String resolveRelativePath0(String string, char c, boolean bl, boolean bl2) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (n2 + 1 < n && string.charAt(n2) == c) {
                if (string.charAt(n2 + 1) == '.') {
                    if (n2 + 2 >= n || string.charAt(n2 + 2) == c) {
                        n2 += 2;
                        continue;
                    }
                    if (n2 + 2 < n && string.charAt(n2 + 2) == '.' && (n2 + 3 >= n || string.charAt(n2 + 3) == c)) {
                        int n4;
                        for (n4 = n3 - 1; n4 > -1 && cArray[n4] == c; --n4) {
                        }
                        while (n4 > -1 && cArray[n4] != c) {
                            --n4;
                        }
                        if (n4 > -1) {
                            n3 = n4;
                        } else {
                            if (bl) {
                                return null;
                            }
                            cArray[0] = c;
                            n3 = 1;
                        }
                        n2 += 3;
                        continue;
                    }
                } else if (bl2) {
                    if (string.charAt(n2 + 1) == c && n2 != 0 && string.charAt(n2 - 1) != ':') {
                        ++n2;
                        continue;
                    }
                } else if (string.charAt(n2 + 1) == c && (n2 == 0 || string.charAt(n2 - 1) != ':')) {
                    ++n2;
                    continue;
                }
            }
            cArray[n3++] = string.charAt(n2++);
        }
        try {
            string = new String(cArray, 0, n3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string = "";
        }
        return string;
    }

    public static String cleanClasspath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.replace('/', File.separatorChar);
        String[] stringArray = StringUtils.splitCompletely(string, File.pathSeparator, false);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = true;
            if (stringArray[i].startsWith("." + File.separatorChar) || stringArray[i].startsWith(".." + File.separatorChar)) {
                stringArray[i] = USER_DIR + File.separatorChar + stringArray[i];
            }
            stringArray[i] = FilenameEncoder.resolveRelativeFilePath(stringArray[i]);
            for (int j = 0; j < i; ++j) {
                if (!stringArray[i].equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            stringBuffer.append(stringArray[i]).append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }

    static {
        if (OS_NAME == null && (OS_NAME = System.getProperty("os.name")) == null) {
            OS_NAME = "null";
        }
        if (OS_NAME.startsWith("Windows")) {
            windowsOS = true;
        }
        USER_DIR = System.getProperty("user.dir");
        LEGAL_FILE_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
    }

    public static class UnsafeFilenameException
    extends Exception {
        private static final long serialVersionUID = -244946124352757151L;

        public UnsafeFilenameException(String string) {
            super(string);
        }
    }
}

