/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.string;

import java.util.TimeZone;
import weblogic.utils.string.SimpleCachingDateFormat;

public abstract class CachingDateFormat {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final CachingDateFormat RFC1123Format = new SimpleCachingDateFormat("EE, dd MMM yyyy HH:mm:ss zz", GMT);
    private static final CachingDateFormat RFC850Format = new SimpleCachingDateFormat("EEEE, dd-MMM-yy HH:mm:ss zz", GMT);
    private static final CachingDateFormat ASCTimeFormat = new SimpleCachingDateFormat("EE MMM  d HH:mm:ss yyyy", GMT);
    protected int resolution;
    private long expiration;
    private String formatString;

    public static String getRFC1123Date() {
        return CachingDateFormat.getRFC1123Date(System.currentTimeMillis());
    }

    public static String getRFC1123Date(long l) {
        return RFC1123Format.getDate(l);
    }

    public static String getRFC850Date() {
        return CachingDateFormat.getRFC850Date(System.currentTimeMillis());
    }

    public static String getRFC850Date(long l) {
        return RFC850Format.getDate(l);
    }

    public static String getASCTimeDate() {
        return CachingDateFormat.getASCTimeDate(System.currentTimeMillis());
    }

    public static String getASCTimeDate(long l) {
        return ASCTimeFormat.getDate(l);
    }

    public final String getDate() {
        return this.getDate(System.currentTimeMillis());
    }

    public final String getDate(long l) {
        if (l > this.expiration || l + (long)this.resolution <= this.expiration) {
            this.formatString = this.format(l);
            this.expiration = l + ((long)this.resolution - l % (long)this.resolution);
        }
        return this.formatString;
    }

    protected abstract String format(long var1);
}

