/*
 * Decompiled with CFR 0.152.
 */
package weblogic.platform;

import java.io.SerializablePermission;

public final class JDK {
    private static JDK jdk = null;
    private static boolean noMaxMem;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int microVersion = -1;
    private String additionalVersion = "";

    protected JDK() {
        String string = System.getProperty("java.version");
        try {
            int n;
            for (n = 0; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
            }
            int n2 = string.indexOf(46, n);
            if (n2 == -1) {
                return;
            }
            this.majorVersion = Integer.parseInt(string.substring(n, n2));
            n = ++n2;
            while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                ++n2;
            }
            if (n == n2) {
                return;
            }
            this.minorVersion = Integer.parseInt(string.substring(n, n2));
            n = n2 + 1;
            for (n2 = string.length(); n2 > n; --n2) {
                try {
                    this.microVersion = Integer.parseInt(string.substring(n, n2));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            this.additionalVersion = string.substring(n2, string.length());
        }
        catch (Exception exception) {
            System.err.println("error parsing java.version: " + string);
        }
    }

    protected JDK(int n, int n2, int n3, String string) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.microVersion = n3;
        this.additionalVersion = string;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public String getAdditionalVersion() {
        return this.additionalVersion;
    }

    public static synchronized JDK getJDK() {
        if (jdk != null) {
            return jdk;
        }
        jdk = new JDK();
        String string = System.getProperty("java.vendor");
        noMaxMem = string.startsWith("Microsoft") || string.startsWith("SuperCede") || string.startsWith("Tower");
        return jdk;
    }

    public boolean checkMemory(long l, long l2) {
        if (noMaxMem) {
            return true;
        }
        return l > l2 / 4L;
    }

    public boolean isEnableReplaceObject(Class clazz) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new SerializablePermission("enableSubstitution"));
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

