/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import weblogic.utils.UnsyncStringBuffer;

public final class ArrayUtils {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private ArrayUtils() {
    }

    public static int hashCode(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n ^= objectArray[i].hashCode();
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < byArray.length; ++i) {
            n = 31 * n + i;
        }
        return n;
    }

    public static String toString(int[] nArray) {
        int n = nArray.length;
        if (n < 1) {
            return null;
        }
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer("int[");
        for (int i = 0; i < n; ++i) {
            unsyncStringBuffer.append(nArray[i]);
            if (i >= n - 1) continue;
            unsyncStringBuffer.append(", ");
        }
        unsyncStringBuffer.append(']');
        return unsyncStringBuffer.toString();
    }

    public static String toString(Object[] objectArray) {
        int n = objectArray.length;
        if (n < 1) {
            return null;
        }
        Class<?> clazz = objectArray[0].getClass();
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer(clazz.getName());
        unsyncStringBuffer.append('[');
        for (int i = 0; i < n; ++i) {
            unsyncStringBuffer.append(objectArray[i].toString());
            if (i >= n - 1) continue;
            unsyncStringBuffer.append(", ");
        }
        unsyncStringBuffer.append(']');
        return unsyncStringBuffer.toString();
    }

    public static boolean addAll(Collection collection, Object[] objectArray) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            bl |= collection.add(objectArray[i]);
        }
        return bl;
    }

    public static boolean removeAll(Collection collection, Object[] objectArray) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            bl |= collection.remove(objectArray[i]);
        }
        return bl;
    }

    public static boolean retainAll(Collection collection, Object[] objectArray) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (ArrayUtils.contains(objectArray, e)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean containsAll(Collection collection, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (collection.contains(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        if (object == null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static void computeDiff(Object[] objectArray, Object[] objectArray2, DiffHandler diffHandler, Comparator comparator) {
        if (comparator == null) {
            ArrayUtils.computeDiff(objectArray, objectArray2, diffHandler);
            return;
        }
        Arrays.sort(objectArray, comparator);
        Arrays.sort(objectArray2, comparator);
        int n = 0;
        int n2 = 0;
        int n3 = objectArray.length;
        int n4 = objectArray2.length;
        if (n3 <= 0) {
            for (int i = 0; i < n4; ++i) {
                diffHandler.addObject(objectArray2[i]);
            }
            return;
        }
        if (n4 <= 0) {
            for (int i = 0; i < n3; ++i) {
                diffHandler.removeObject(objectArray[i]);
            }
            return;
        }
        while (n <= n3) {
            int n5 = n >= n3 ? 1 : (n2 >= n4 ? -1 : comparator.compare(objectArray[n], objectArray2[n2]));
            if (n5 == 0) {
                ++n;
                ++n2;
            } else if (n5 < 0) {
                diffHandler.removeObject(objectArray[n]);
                ++n;
            } else {
                diffHandler.addObject(objectArray2[n2]);
                ++n2;
            }
            if (n2 < n4 || n < n3) continue;
            break;
        }
    }

    public static void computeDiff(Object[] objectArray, Object[] objectArray2, DiffHandler diffHandler) {
        Object object;
        int n;
        Object[] objectArray3 = objectArray2 != null ? (Object[])objectArray2.clone() : EMPTY_ARRAY;
        for (n = 0; objectArray != null && n < objectArray.length; ++n) {
            int n2;
            object = objectArray[n];
            for (n2 = 0; n2 < objectArray3.length; ++n2) {
                Object object2 = objectArray3[n2];
                if (object2 == null || !object2.equals(object)) continue;
                objectArray3[n2] = null;
                break;
            }
            if (n2 != objectArray3.length) continue;
            diffHandler.removeObject(object);
        }
        for (n = 0; n < objectArray3.length; ++n) {
            object = objectArray3[n];
            if (object == null) continue;
            diffHandler.addObject(object);
        }
    }

    public static boolean[] copyAndSort(boolean[] blArray) {
        int n;
        if (blArray == null) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n2;
        }
        boolean[] blArray2 = new boolean[blArray.length];
        for (n = 0; n < n2; ++n) {
            blArray2[n] = true;
        }
        for (n = n2; n < blArray.length; ++n) {
            blArray2[n] = false;
        }
        return blArray2;
    }

    public static byte[] copyAndSort(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Arrays.sort(byArray2);
        return byArray2;
    }

    public static char[] copyAndSort(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        Arrays.sort(cArray2);
        return cArray2;
    }

    public static double[] copyAndSort(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        Arrays.sort(dArray2);
        return dArray2;
    }

    public static float[] copyAndSort(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        Arrays.sort(fArray2);
        return fArray2;
    }

    public static int[] copyAndSort(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray2);
        return nArray2;
    }

    public static long[] copyAndSort(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        long[] lArray2 = new long[lArray.length];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        Arrays.sort(lArray2);
        return lArray2;
    }

    public static short[] copyAndSort(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        short[] sArray2 = new short[sArray.length];
        System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        Arrays.sort(sArray2);
        return sArray2;
    }

    public static Object[] copyAndSort(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    public static interface DiffHandler {
        public void addObject(Object var1);

        public void removeObject(Object var1);
    }
}

