/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class KeyTable {
    private static final Class preload = KeyTableEnumeration.class;
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private Object[] table;
    private int mask;
    private int alpha;
    private int size = 0;
    private int power;

    public KeyTable() {
        this(5);
    }

    public KeyTable(int n) {
        this.setPower(n);
    }

    private void setPower(int n) {
        this.power = n;
        this.table = new Object[1 << n];
        this.mask = this.table.length - 1;
        this.alpha = ALPHA[n];
    }

    private final int firstBucket(int n) {
        return (n & this.mask ^ n >> 32 - this.power) & this.mask;
    }

    private final int nextBucket(int n) {
        return n + this.alpha & this.mask;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration elements() {
        return new KeyTableEnumeration(this.table);
    }

    public Enumeration keys() {
        return new KeyTableEnumeration(this.table, true);
    }

    public Object get(int n) {
        int n2 = this.firstBucket(n);
        Object object;
        while ((object = this.table[n2]) != null && object.hashCode() != n) {
            n2 = this.nextBucket(n2);
        }
        return object;
    }

    public Object put(Object object) {
        Object object2;
        int n;
        if (this.size >= this.table.length * 3 / 4) {
            Object[] objectArray = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (n = 0; n < objectArray.length; ++n) {
                object2 = objectArray[n];
                if (object2 == null) continue;
                this.put(object2);
            }
        }
        int n2 = object.hashCode();
        n = this.firstBucket(n2);
        while (true) {
            if ((object2 = this.table[n]) == null) {
                ++this.size;
                this.table[n] = object;
                return object2;
            }
            if (object2.hashCode() == n2) {
                this.table[n] = object;
                return object2;
            }
            n = this.nextBucket(n);
        }
    }

    public Object remove(int n) {
        int n2 = this.firstBucket(n);
        Object object = this.table[n2];
        while (object != null && object.hashCode() != n) {
            n2 = this.nextBucket(n2);
            object = this.table[n2];
        }
        if (object == null) {
            return null;
        }
        this.table[n2] = null;
        --this.size;
        Object object2;
        while ((object2 = this.table[n2 = this.nextBucket(n2)]) != null) {
            this.table[n2] = null;
            --this.size;
            this.put(object2);
        }
        return object;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        Enumeration enumeration = this.elements();
        Enumeration enumeration2 = this.keys();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append("<" + enumeration2.nextElement() + "," + enumeration.nextElement() + ">");
        }
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(", ").append("<" + enumeration2.nextElement() + "," + enumeration.nextElement() + ">");
        }
        return stringBuffer.append("}").toString();
    }

    private static final class KeyTableEnumeration
    implements Enumeration {
        private int i = 0;
        private final Object[] table;
        private boolean returnKeys = false;

        public KeyTableEnumeration(Object[] objectArray) {
            this.table = objectArray;
        }

        public KeyTableEnumeration(Object[] objectArray, boolean bl) {
            this.table = objectArray;
            this.returnKeys = bl;
        }

        public boolean hasMoreElements() {
            while (this.i < this.table.length && this.table[this.i] == null) {
                ++this.i;
            }
            return this.i < this.table.length;
        }

        public Object nextElement() {
            while (this.i < this.table.length && this.table[this.i] == null) {
                ++this.i;
            }
            if (this.i == this.table.length) {
                throw new NoSuchElementException("KeytableEnumerator");
            }
            if (!this.returnKeys) {
                return this.table[this.i++];
            }
            return new Integer(this.table[this.i++].hashCode());
        }
    }
}

