/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentCircularQueue<E> {
    private AtomicReferenceArray contents;
    private final int capacity;
    private final int lastPos;
    public AtomicInteger getter;
    public AtomicInteger putter;
    public AtomicInteger size;

    public ConcurrentCircularQueue(int n) {
        this.capacity = n;
        this.lastPos = this.capacity - 1;
        this.contents = new AtomicReferenceArray(this.capacity);
        this.getter = new AtomicInteger();
        this.putter = new AtomicInteger();
        this.size = new AtomicInteger();
    }

    public E remove() {
        int n;
        do {
            if ((n = this.size.get()) != 0) continue;
            return null;
        } while (!this.size.compareAndSet(n, n - 1));
        return this.contents.getAndSet(this.nextPos(this.getter), null);
    }

    public boolean add(E e) {
        int n;
        do {
            if ((n = this.size.get()) != this.capacity) continue;
            return false;
        } while (!this.size.compareAndSet(n, n + 1));
        this.contents.set(this.nextPos(this.putter), e);
        return true;
    }

    public int size() {
        return this.size.get();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.capacity == this.size();
    }

    private int nextPos(AtomicInteger atomicInteger) {
        int n;
        int n2;
        while (!atomicInteger.compareAndSet(n2, n = (n2 = atomicInteger.get()) == this.lastPos ? 0 : n2 + 1)) {
        }
        return n;
    }
}

