/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import weblogic.utils.UnsyncStringBuffer;

public class ConcurrentHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry[] table;
    private transient int size;
    private int threshold;
    private final float loadFactor;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;
    private transient Set keySet = null;
    private transient Collection values = null;
    private static final long serialVersionUID = -6452706556724125778L;

    public ConcurrentHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
    }

    public ConcurrentHashMap(int n) {
        this(n, 0.75f);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f);
    }

    public ConcurrentHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    private static int hash(Object object) {
        int n = object.hashCode();
        return n - (n << 7);
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public final int capacity() {
        return this.table.length;
    }

    public final float loadFactor() {
        return this.loadFactor;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object object) {
        Entry entry = this.getEntry(object);
        return entry == null ? null : entry.value;
    }

    public final boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    protected Entry getEntry(Object object) {
        Object object2 = ConcurrentHashMap.maskNull(object);
        int n = ConcurrentHashMap.hash(object2);
        Entry[] entryArray = this.table;
        Entry entry = entryArray[n & entryArray.length - 1];
        while (entry != null) {
            if (entry.hash == n && ConcurrentHashMap.eq(object2, entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Object object3 = ConcurrentHashMap.maskNull(object);
        int n = ConcurrentHashMap.hash(object3);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int n2 = n & this.table.length - 1;
            Entry entry = this.table[n2];
            while (entry != null) {
                if (entry.hash == n && ConcurrentHashMap.eq(object3, entry.key)) {
                    Object object4 = entry.value;
                    entry.value = object2;
                    return object4;
                }
                entry = entry.next;
            }
            this.table[n2] = this.createEntry(n, object3, object2, this.table[n2]);
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Object object, Object object2) {
        Object object3 = ConcurrentHashMap.maskNull(object);
        int n = ConcurrentHashMap.hash(object3);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int n2 = n & this.table.length - 1;
            Entry entry = this.table[n2];
            while (entry != null) {
                if (entry.hash == n && ConcurrentHashMap.eq(object3, entry.key)) {
                    return entry.value;
                }
                entry = entry.next;
            }
            this.table[n2] = this.createEntry(n, object3, object2, this.table[n2]);
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return null;
    }

    private void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (this.size < this.threshold || n2 > n) {
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        int n3 = n - 1;
        int n4 = n2;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = (Entry)entry.clone();
                int n5 = entry2.hash & n3;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
                entry = entry.next;
            }
        }
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    public final synchronized void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int n2;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n; n2 <<= 1) {
            }
            this.resize(n2);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Entry entry = this.removeEntryForKey(object);
        return entry == null ? entry : entry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry removeEntryForKey(Object object) {
        Object object2 = ConcurrentHashMap.maskNull(object);
        int n = ConcurrentHashMap.hash(object2);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int n2 = n & this.table.length - 1;
            Entry entry = this.table[n2];
            if (entry == null) {
                return null;
            }
            if (entry.hash == n && ConcurrentHashMap.eq(object2, entry.key)) {
                --this.size;
                this.table[n2] = entry.next;
                return entry;
            }
            Entry entry2 = entry;
            entry = entry.next;
            while (entry != null) {
                if (entry.hash == n && ConcurrentHashMap.eq(object2, entry.key)) {
                    --this.size;
                    entry2.next = entry.next;
                    return entry;
                }
                entry2 = entry;
                entry = entry.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry removeMapping(Object object) {
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)object;
        Object object2 = ConcurrentHashMap.maskNull(entry.getKey());
        int n = ConcurrentHashMap.hash(object2);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int n2 = n & this.table.length - 1;
            Entry entry2 = this.table[n2];
            if (entry2 == null) {
                return null;
            }
            if (entry2.hash == n && entry2.equals(entry)) {
                --this.size;
                this.table[n2] = entry2.next;
                return entry2;
            }
            Entry entry3 = entry2;
            entry2 = entry2.next;
            while (entry2 != null) {
                if (entry2.hash == n && entry2.equals(entry)) {
                    --this.size;
                    entry3.next = entry2.next;
                    return entry2;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
        }
        return null;
    }

    public synchronized void clear() {
        this.table = new Entry[this.table.length];
        this.size = 0;
    }

    public final boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public final Object clone() {
        return new ConcurrentHashMap(this);
    }

    protected Entry createEntry(int n, Object object, Object object2, Entry entry) {
        return new Entry(n, object, object2, entry);
    }

    public final String toPrettyString() {
        return this.toPrettyString(0);
    }

    public final String toPrettyString(int n) {
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer();
        for (int i = 0; i < n; ++i) {
            unsyncStringBuffer.append("  ");
        }
        UnsyncStringBuffer unsyncStringBuffer2 = new UnsyncStringBuffer();
        unsyncStringBuffer2.append(unsyncStringBuffer.toString() + "Size: [" + this.size() + ", " + this.entrySet().size() + "] {\n");
        Set set = this.entrySet();
        Iterator iterator = set.iterator();
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (entry.getValue() instanceof ConcurrentHashMap) {
                unsyncStringBuffer2.append(unsyncStringBuffer.toString() + "  " + entry.getKey() + "=" + ((ConcurrentHashMap)entry.getValue()).toPrettyString(n + 1) + "\n");
                continue;
            }
            unsyncStringBuffer2.append(unsyncStringBuffer.toString() + "  " + entry.getKey() + "=" + entry.getValue() + "\n");
        }
        unsyncStringBuffer2.append(unsyncStringBuffer.toString() + "}\n");
        return unsyncStringBuffer2.toString();
    }

    public final Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    public final Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public final Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        for (Map.Entry entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private final class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = ConcurrentHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return ConcurrentHashMap.this.removeMapping(object) != null;
        }

        public int size() {
            return ConcurrentHashMap.this.size;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size;
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size;
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return ConcurrentHashMap.this.removeEntryForKey(object) != null;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        final Entry[] table;
        Entry next;
        int index;
        Entry current;

        HashIterator() {
            this.table = ConcurrentHashMap.this.table;
            if (ConcurrentHashMap.this.size == 0) {
                return;
            }
            Entry[] entryArray = this.table;
            int n = entryArray.length - 1;
            Entry entry = entryArray[n];
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.index = n;
            this.next = entry;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry[] entryArray = this.table;
            int n = this.index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this.index = n;
            this.next = entry2;
            this.current = entry;
            return this.current;
        }

        public final void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object object = this.current.key;
            this.current = null;
            ConcurrentHashMap.this.removeEntryForKey(object);
        }
    }

    protected static class Entry
    implements Map.Entry {
        final Object key;
        Object value;
        final int hash;
        Entry next;

        protected Entry(int n, Object object, Object object2, Entry entry) {
            this.value = object2;
            this.next = entry;
            this.key = object;
            this.hash = n;
        }

        public Object getKey() {
            return ConcurrentHashMap.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            Object v;
            Object object2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object3 = this.getKey();
            return (object3 == (k = entry.getKey()) || object3 != null && object3.equals(k)) && ((object2 = this.getValue()) == (v = entry.getValue()) || object2 != null && object2.equals(v));
        }

        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, null);
        }
    }
}

