/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class ConcurrentPool {
    private AtomicReferenceArray contents;
    private final int capacity;
    private AtomicLong getter;
    private AtomicLong putter;

    public ConcurrentPool(int n) {
        this.contents = new AtomicReferenceArray(n);
        this.capacity = n;
        this.getter = new AtomicLong(0L);
        this.putter = new AtomicLong(0L);
    }

    public Object remove() {
        if (this.getter.get() >= this.putter.get()) {
            return null;
        }
        int n = (int)(this.getter.getAndIncrement() % (long)this.capacity);
        return this.contents.getAndSet(n, null);
    }

    public void add(Object object) {
        int n = (int)(this.putter.getAndIncrement() % (long)this.capacity);
        this.contents.set(n, object);
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.contents.length(); ++i) {
            if (this.contents.get(i) == null) continue;
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            final int n3 = Integer.parseInt(stringArray[2]);
            final ConcurrentPool concurrentPool = new ConcurrentPool(n);
            final AtomicLong atomicLong = new AtomicLong();
            Thread[] threadArray = new Thread[n2];
            for (int i = 0; i < 10; ++i) {
                int n4;
                System.out.println("Run no. " + (i + 1));
                for (int j = 0; j < threadArray.length; ++j) {
                    final int n5 = j + 1;
                    threadArray[j] = new Thread(){

                        public void run() {
                            try {
                                for (int i = 0; i < n3; ++i) {
                                    Integer n = (Integer)concurrentPool.remove();
                                    if (n == null) {
                                        atomicLong.incrementAndGet();
                                        concurrentPool.add(new Integer(n5));
                                        continue;
                                    }
                                    concurrentPool.add(n);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    };
                }
                long l = System.currentTimeMillis();
                for (n4 = 0; n4 < threadArray.length; ++n4) {
                    threadArray[n4].start();
                }
                for (n4 = 0; n4 < threadArray.length; ++n4) {
                    threadArray[n4].join();
                }
                long l2 = System.currentTimeMillis();
                System.out.println("Fail ratio       : " + (float)atomicLong.get() * 1.0f / (float)(n2 * n3));
                System.out.println("Throughput       : " + (float)(n2 * n3) * 1000.0f / (float)(l2 - l));
                System.out.println("Time taken (secs): " + (float)(l2 - l) / 1000.0f);
                System.out.println("Contents sz      : " + concurrentPool.size());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

