/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MatchMap
extends AbstractMap {
    private static final int FREE_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private Entry[] data = new Entry[64];
    private int[] base = new int[64];
    private int[] firstInput = new int[64];
    private int[] check = new int[64];
    private int[] next = new int[64];
    private int[] nextInput = new int[64];
    private int freeList = 0;
    private int size;
    private final boolean ignoreCase;

    public MatchMap() {
        this(false);
    }

    public MatchMap(boolean bl) {
        this.ignoreCase = bl;
        for (int i = this.base.length - 2; i > 1; --i) {
            this.base[i] = i + 1;
        }
        this.freeList = 2;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Object clone() {
        MatchMap matchMap = new MatchMap(this.ignoreCase);
        matchMap.data = new Entry[this.data.length];
        System.arraycopy(this.data, 0, matchMap.data, 0, this.data.length);
        matchMap.base = MatchMap.clone(this.base);
        matchMap.firstInput = MatchMap.clone(this.firstInput);
        matchMap.check = MatchMap.clone(this.check);
        matchMap.next = MatchMap.clone(this.next);
        matchMap.nextInput = MatchMap.clone(this.nextInput);
        matchMap.freeList = this.freeList;
        matchMap.size = this.size;
        return matchMap;
    }

    private static int[] clone(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public Map.Entry match(String string) {
        int n = 1;
        Entry entry = this.data[n];
        int n2 = 0;
        int n3 = this.check.length;
        if (this.ignoreCase) {
            int n4;
            for (int i = string.length(); i > 0 && (n4 = this.base[n] + Character.toUpperCase(string.charAt(n2))) < n3 && this.check[n4] == n; --i) {
                n = this.next[n4];
                Entry entry2 = this.data[n];
                if (entry2 != null) {
                    entry = entry2;
                }
                ++n2;
            }
        } else {
            int n5;
            for (int i = string.length(); i > 0 && (n5 = this.base[n] + string.charAt(n2)) < n3 && this.check[n5] == n; --i) {
                n = this.next[n5];
                Entry entry3 = this.data[n];
                if (entry3 != null) {
                    entry = entry3;
                }
                ++n2;
            }
        }
        return entry;
    }

    public Object get(char[] cArray, int n, int n2) {
        int n3 = 1;
        int n4 = this.check.length;
        while (n2 > 0) {
            int n5 = this.base[n3] + cArray[n];
            if (n5 >= n4 || this.check[n5] != n3) {
                return null;
            }
            n3 = this.next[n5];
            ++n;
            --n2;
        }
        Entry entry = this.data[n3];
        return entry == null ? null : entry.value;
    }

    public Object get(String string) {
        return this.get(string.toCharArray(), 0, string.length());
    }

    public Entry put(CharSequence charSequence, Object object) {
        int n = 1;
        for (int i = 0; i < charSequence.length(); ++i) {
            int n2;
            int n3;
            char c = charSequence.charAt(i);
            if (this.ignoreCase) {
                c = Character.toUpperCase(c);
            }
            if ((n3 = this.safeCheck(n2 = this.base[n] + c)) == n) {
                n = this.next[n2];
                continue;
            }
            if (n3 != 0) {
                this.rebase(n, c);
                n2 = this.base[n] + c;
            }
            this.check[n2] = n;
            this.nextInput[n2] = this.firstInput[n];
            this.firstInput[n] = c;
            this.next[n2] = n = this.newState();
        }
        Entry entry = this.data[n];
        this.data[n] = new Entry(charSequence, object);
        if (entry == null) {
            ++this.size;
        }
        return entry;
    }

    public Object remove(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = charSequence.length();
        int[] nArray = new int[n3];
        int n4 = 1;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = n4;
            n2 = charSequence.charAt(i);
            if (this.ignoreCase) {
                n2 = Character.toUpperCase((char)n2);
            }
            if ((n = this.base[n4] + n2) >= this.check.length || this.check[n] != n4) {
                return null;
            }
            n4 = this.next[n];
        }
        Entry entry = this.data[n4];
        if (entry != null) {
            --this.size;
            this.data[n4] = null;
        }
        for (n2 = n3 - 1; n2 >= 0 && this.isLeaf(n4) && this.data[n4] == null; --n2) {
            n = nArray[n2];
            this.freeState(n, charSequence.charAt(n2), n4);
            n4 = n;
        }
        return entry == null ? null : entry.value;
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return MatchMap.this.size;
            }

            public Iterator iterator() {
                return new EntryIterator();
            }
        };
    }

    private int safeCheck(int n) {
        if (n >= this.check.length) {
            this.check = MatchMap.grow(this.check, 2 * n);
            this.next = MatchMap.grow(this.next, 2 * n);
            this.nextInput = MatchMap.grow(this.nextInput, 2 * n);
        }
        return this.check[n];
    }

    private static int[] grow(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private static Entry[] grow(Entry[] entryArray, int n) {
        Entry[] entryArray2 = new Entry[n];
        System.arraycopy(entryArray, 0, entryArray2, 0, entryArray.length);
        return entryArray2;
    }

    private void rebase(int n, char c) {
        int n2 = this.base[n];
        int n3 = this.firstInput[n];
        int n4 = 0;
        while (!this.isFree(n4, n2, n3, c)) {
            ++n4;
        }
        this.base[n] = n4;
        int n5 = n3;
        while (n5 != 0) {
            this.check[n4 + n5] = n;
            this.next[n4 + n5] = this.next[n2 + n5];
            this.nextInput[n4 + n5] = this.nextInput[n2 + n5];
            this.check[n2 + n5] = 0;
            n5 = this.nextInput[n2 + n5];
        }
    }

    private boolean isFree(int n, int n2, int n3, char c) {
        if (this.safeCheck(n + c) != 0) {
            return false;
        }
        int n4 = n3;
        while (n4 != 0) {
            if (this.safeCheck(n + n4) != 0) {
                return false;
            }
            n4 = this.nextInput[n2 + n4];
        }
        return true;
    }

    private int newState() {
        if (this.freeList == 0) {
            int n = this.base.length;
            int n2 = 2 * n;
            this.base = MatchMap.grow(this.base, n2);
            this.data = MatchMap.grow(this.data, n2);
            this.firstInput = MatchMap.grow(this.firstInput, n2);
            for (int i = n2 - 2; i > n; --i) {
                this.base[i] = i + 1;
            }
            this.freeList = n + 1;
            return n;
        }
        int n = this.freeList;
        this.freeList = this.base[this.freeList];
        this.base[n] = 0;
        this.firstInput[n] = 0;
        return n;
    }

    void freeState(int n, char c, int n2) {
        this.base[n2] = this.freeList;
        this.freeList = n2;
        int n3 = this.base[n];
        this.check[n3 + c] = 0;
        int n4 = this.firstInput[n];
        if (n4 == c) {
            this.firstInput[n] = this.nextInput[n3 + n4];
            return;
        }
        while (true) {
            int n5;
            if ((n5 = this.nextInput[n3 + n4]) == c) {
                this.nextInput[n3 + n4] = this.nextInput[n3 + n5];
                return;
            }
            n4 = n5;
        }
    }

    private boolean isLeaf(int n) {
        return this.firstInput[n] == 0;
    }

    public static class Test {
        public static void main(String[] stringArray) throws Exception {
            String string;
            String string2 = stringArray.length > 0 ? stringArray[0] : "c:/emacs-20.3.1/ispell4/ispell.words";
            MatchMap matchMap = new MatchMap();
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string2));
            for (int i = 0; i < 2000; ++i) {
                String string3 = dataInputStream.readLine();
                matchMap.put(string3, string3);
            }
            dataInputStream.close();
            dataInputStream = new DataInputStream(new FileInputStream(string2));
            long l = System.currentTimeMillis();
            int n = 0;
            while ((string = dataInputStream.readLine()) != null) {
                for (int i = 10000; i > 0; --i) {
                    matchMap.match(string);
                    ++n;
                }
            }
            long l2 = System.currentTimeMillis() - l;
            System.out.println(n + " in " + l2 + "ms = " + ((long)n + l2 / 2L) / l2 + "K/s");
        }
    }

    static final class Entry
    implements Map.Entry {
        private final CharSequence key;
        private final Object value;

        Entry(CharSequence charSequence, Object object) {
            this.key = charSequence;
            this.value = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    class EntryIterator
    implements Iterator {
        private int index;

        EntryIterator() {
            int n;
            for (n = MatchMap.this.data.length - 1; n >= 0 && MatchMap.this.data[n] == null; --n) {
            }
            this.index = n;
        }

        public boolean hasNext() {
            return this.index >= 0;
        }

        public Object next() {
            Entry entry = MatchMap.this.data[this.index--];
            while (this.index >= 0 && MatchMap.this.data[this.index] == null) {
                --this.index;
            }
            return entry;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

