/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Arrays;

public class NumericValueHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public NumericValueHashMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public NumericValueHashMap(int n) {
        this(n, 0.75f);
    }

    public NumericValueHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(long l) {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value == l) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (NumericValueHashMap.eq(entry.key, object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public long get(Object object) {
        return this.get(object, 0L);
    }

    public long get(Object object, long l) {
        Entry[] entryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (NumericValueHashMap.eq(entry.key, object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return l;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key.hashCode() & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public long put(Object object, long l) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (NumericValueHashMap.eq(entry.key, object)) {
                long l2 = entry.value;
                entry.value = l;
                return l2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, l);
        }
        entryArray[n] = new Entry(object, l, entryArray[n]);
        ++this.count;
        return 0L;
    }

    public long remove(Object object) {
        Entry[] entryArray = this.table;
        int n = (object.hashCode() & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n];
        Entry entry2 = null;
        while (entry != null) {
            if (NumericValueHashMap.eq(entry.key, object)) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return 0L;
    }

    public void clear() {
        Object[] objectArray = this.table;
        Arrays.fill(objectArray, null);
        this.count = 0;
    }

    static class Entry {
        final Object key;
        long value;
        Entry next;

        Entry(Object object, long l, Entry entry) {
            this.key = object;
            this.value = l;
            this.next = entry;
        }
    }
}

