/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.utils.collections.CircularQueue;
import weblogic.utils.collections.ConcurrentHashMap;

public class SecondChanceCacheMap
extends AbstractMap {
    private final int capacity;
    private final ConcurrentHashMap map = new ConcurrentHashMap();
    private final CircularQueue list = new CircularQueue();
    private Set entrySet;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public SecondChanceCacheMap(int n) {
        this.capacity = n;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.map.get(object);
        if (entry == null) {
            return null;
        }
        entry.setSecondChance(true);
        return entry.getValue();
    }

    public synchronized Object put(Object object, Object object2) {
        Entry entry = new Entry(object, object2);
        Entry entry2 = (Entry)this.map.putIfAbsent(object, entry);
        if (entry2 != null) {
            Object object3 = entry2.getValue();
            entry2.setValue(object2);
            return object3;
        }
        this.list.add(entry);
        if (this.capacity < this.size()) {
            Entry entry3 = this.getEntryForEviction();
            this.map.remove(entry3.getKey());
            return entry3.getValue();
        }
        return null;
    }

    public synchronized Object insert(Object object, Object object2) {
        Entry entry = new Entry(object, object2);
        Entry entry2 = (Entry)this.map.putIfAbsent(object, entry);
        if (entry2 != null) {
            Object object3 = entry2.getValue();
            entry2.setValue(object2);
            return null;
        }
        this.list.add(entry);
        if (this.capacity < this.size()) {
            Entry entry3 = this.getEntryForEviction();
            Object object4 = entry3.getKey();
            this.map.remove(object4);
            return object4;
        }
        return null;
    }

    protected Entry getEntryForEviction() {
        Entry entry;
        while (true) {
            if (!(entry = (Entry)this.list.remove()).getValid()) {
                continue;
            }
            if (!entry.getSecondChance()) break;
            entry.setSecondChance(false);
            this.list.add(entry);
        }
        return entry;
    }

    public synchronized Object remove(Object object) {
        Entry entry = (Entry)this.map.remove(object);
        if (entry == null) {
            return null;
        }
        entry.setValid(false);
        if (this.list.size() > this.capacity) {
            this.cleanupInvalidObjects();
        }
        return entry.getValue();
    }

    private void cleanupInvalidObjects() {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Entry entry = (Entry)this.list.remove();
            if (!entry.getValid()) continue;
            this.list.add(entry);
        }
    }

    public synchronized void clear() {
        this.map.clear();
        this.list.clear();
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new SecondChanceIterator(2);
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return SecondChanceCacheMap.this.map.get(entry.getKey()) != null;
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = SecondChanceCacheMap.this.remove(entry.getKey());
                    return object2 != null;
                }

                public int size() {
                    return SecondChanceCacheMap.this.size();
                }

                public void clear() {
                    SecondChanceCacheMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private class SecondChanceIterator
    implements Iterator {
        Iterator mapIterator;
        final int type;

        public SecondChanceIterator(int n) {
            this.mapIterator = SecondChanceCacheMap.this.map.values().iterator();
            this.type = n;
        }

        public boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        public Object next() {
            Entry entry = (Entry)this.mapIterator.next();
            return this.type == 0 ? entry.getKey() : (this.type == 1 ? entry.getValue() : entry);
        }

        public void remove() {
            this.mapIterator.remove();
        }
    }

    protected static class Entry
    implements Map.Entry {
        private final Object key;
        private Object value;
        private boolean secondChance;
        private boolean valid;

        public Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
            this.secondChance = false;
            this.valid = true;
        }

        public boolean getSecondChance() {
            return this.secondChance;
        }

        public void setSecondChance(boolean bl) {
            this.secondChance = bl;
        }

        public boolean getValid() {
            return this.valid;
        }

        public void setValid(boolean bl) {
            this.valid = bl;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return super.toString() + " - key: " + this.key.toString() + " value: " + this.value.toString();
        }
    }
}

