/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakConcurrentHashMap
extends AbstractMap
implements Map,
Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public WeakConcurrentHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f > 1.0f || f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public WeakConcurrentHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakConcurrentHashMap() {
        this(101, 0.75f);
    }

    public WeakConcurrentHashMap(Map map) {
        this(Math.max(3 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (WeakConcurrentHashMap.eq(object, entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            throw new IllegalArgumentException("Null keys not supported");
        }
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && WeakConcurrentHashMap.eq(object, entry.get())) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null keys not supported");
        }
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && WeakConcurrentHashMap.eq(object, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2;
                if (entry.get() == null) {
                    entry2 = entry;
                    entry = entry.next;
                    entry2.next = null;
                    entry2.value = null;
                    --this.count;
                    continue;
                }
                entry2 = (Entry)entry.clone(this.queue);
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("Null keys not supported");
        }
        int n = object.hashCode();
        WeakConcurrentHashMap weakConcurrentHashMap = this;
        synchronized (weakConcurrentHashMap) {
            this.expungeStaleEntries();
            Entry[] entryArray = this.table;
            int n2 = 0;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && WeakConcurrentHashMap.eq(object, entry.get())) {
                    Object object3 = entry.value;
                    entry.value = object2;
                    return object3;
                }
                entry = entry.next;
            }
            if (this.count >= this.threshold) {
                this.rehash();
                entryArray = this.table;
                n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            }
            entryArray[n2] = entry = new Entry(n, object, object2, entryArray[n2], this.queue);
            ++this.count;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null keys not supported");
        }
        int n = object.hashCode();
        WeakConcurrentHashMap weakConcurrentHashMap = this;
        synchronized (weakConcurrentHashMap) {
            this.expungeStaleEntries();
            Entry[] entryArray = this.table;
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n && WeakConcurrentHashMap.eq(object, entry.get())) {
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                    Object object2 = entry.value;
                    entry.value = null;
                    return object2;
                }
                entry2 = entry;
                entry = entry.next;
            }
        }
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        while (this.queue.poll() != null) {
        }
        this.table = new Entry[this.table.length];
        this.count = 0;
        while (this.queue.poll() != null) {
        }
    }

    public synchronized Object clone() {
        try {
            this.expungeStaleEntries();
            WeakConcurrentHashMap weakConcurrentHashMap = (WeakConcurrentHashMap)super.clone();
            weakConcurrentHashMap.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                Entry entry = this.table[n];
                if (entry == null) continue;
                weakConcurrentHashMap.table[n] = (Entry)entry.clone(weakConcurrentHashMap.queue);
                entry = entry.next;
                Entry entry2 = weakConcurrentHashMap.table[n];
                while (entry != null) {
                    entry2 = entry2.next = (Entry)entry.clone(weakConcurrentHashMap.queue);
                    entry = entry.next;
                }
            }
            weakConcurrentHashMap.keySet = null;
            weakConcurrentHashMap.entrySet = null;
            weakConcurrentHashMap.values = null;
            return weakConcurrentHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new HashIterator(0);
                }

                public int size() {
                    return WeakConcurrentHashMap.this.count;
                }

                public boolean contains(Object object) {
                    return WeakConcurrentHashMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    return WeakConcurrentHashMap.this.remove(object) != null;
                }

                public void clear() {
                    WeakConcurrentHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new HashIterator(1);
                }

                public int size() {
                    return WeakConcurrentHashMap.this.count;
                }

                public boolean contains(Object object) {
                    return WeakConcurrentHashMap.this.containsValue(object);
                }

                public void clear() {
                    WeakConcurrentHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new HashIterator(2);
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = WeakConcurrentHashMap.this.table;
                    int n = k == null ? 0 : k.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    while (entry2 != null) {
                        if (entry2.hash == n && WeakConcurrentHashMap.eq(entry2, entry)) {
                            return true;
                        }
                        entry2 = entry2.next;
                    }
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    WeakConcurrentHashMap weakConcurrentHashMap = WeakConcurrentHashMap.this;
                    synchronized (weakConcurrentHashMap) {
                        Entry[] entryArray = WeakConcurrentHashMap.this.table;
                        int n = k == null ? 0 : k.hashCode();
                        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                        Entry entry2 = entryArray[n2];
                        Entry entry3 = null;
                        while (entry2 != null) {
                            if (entry2.hash == n && WeakConcurrentHashMap.eq(entry2, entry)) {
                                if (entry3 != null) {
                                    entry3.next = entry2.next;
                                } else {
                                    entryArray[n2] = entry2.next;
                                }
                                WeakConcurrentHashMap.this.count--;
                                entry2.value = null;
                                return true;
                            }
                            entry3 = entry2;
                            entry2 = entry2.next;
                        }
                        return false;
                    }
                }

                public int size() {
                    return WeakConcurrentHashMap.this.count;
                }

                public void clear() {
                    WeakConcurrentHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.queue.poll()) != null) {
            Entry entry = (Entry)reference;
            int n = entry.hash;
            Entry[] entryArray = this.table;
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            Entry entry3 = null;
            while (entry2 != null) {
                if (entry2 == entry) {
                    if (entry3 != null) {
                        entry3.next = entry2.next;
                    } else {
                        entryArray[n2] = entry2.next;
                    }
                    --this.count;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;

        HashIterator(int n) {
            this.table = WeakConcurrentHashMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = n;
        }

        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry entry = this.lastReturned = this.entry;
                this.entry = entry.next;
                return this.type == 0 ? entry.get() : (this.type == 1 ? entry.value : entry);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            WeakConcurrentHashMap weakConcurrentHashMap = WeakConcurrentHashMap.this;
            synchronized (weakConcurrentHashMap) {
                Entry[] entryArray = WeakConcurrentHashMap.this.table;
                int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        WeakConcurrentHashMap.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new AssertionError((Object)"Iterated off table when doing remove");
            }
        }
    }

    private static class Entry
    extends WeakReference
    implements Map.Entry {
        int hash;
        Object value;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = n;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone(ReferenceQueue referenceQueue) {
            return new Entry(this.hash, this.get(), this.value, null, referenceQueue);
        }

        public Object getKey() {
            return this.get();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object t = this.get();
            Object k = entry.getKey();
            return (t == null ? k == null : WeakConcurrentHashMap.eq(t, k)) && (this.value == null ? entry.getValue() == null : WeakConcurrentHashMap.eq(this.value, entry.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return "" + this.get() + "=" + this.value.toString();
        }
    }
}

