/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import weblogic.utils.AssertionError;
import weblogic.utils.BadOptionException;
import weblogic.utils.CharUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.PlatformConstants;
import weblogic.utils.compiler.BadOutputException;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.DefaultCompilerFactory;
import weblogic.utils.compiler.ICompilerFactory;
import weblogic.utils.compiler.IndentingWriter;

public abstract class CodeGenerator
implements PlatformConstants {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private Getopt2 opts = null;
    protected boolean verboseCodegen;
    private Output currentOutput;
    private String encoding = null;
    protected String targetDirectory = null;
    protected boolean CheckValidChar = true;
    protected ICompilerFactory compilerFactory = null;
    public static final String NON_WORD_CHARS = "@.,();:[]=+-*/\" \r\n\t'";
    private Hashtable productionRules;

    public CodeGenerator() {
        this(new Getopt2());
    }

    public CodeGenerator(Getopt2 getopt2) {
        this.opts = getopt2;
        getopt2.addOption("d", "dir", "Target (top-level) directory for compilation.");
        getopt2.addFlag("verboseCodegen", "Emit debugging output during codegen.");
        getopt2.markPrivate("verboseCodegen");
    }

    protected void extractOptionValues(Getopt2 getopt2) {
    }

    protected Enumeration outputs(List list) throws Exception {
        return null;
    }

    protected Enumeration outputs(Object[] objectArray) throws Exception {
        return null;
    }

    protected void prepare(Output output) throws Exception {
        this.currentOutput = output;
    }

    protected void cleanup() throws Exception {
    }

    public final String[] generate() throws Exception {
        return this.generate(this.opts.args());
    }

    public final List generate(Object object) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return this.generate(arrayList);
    }

    public final List generate(List list) throws Exception {
        this.verboseCodegen = this.opts.hasOption("verboseCodegen");
        this.extractOptionValues(this.opts);
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.outputs(list);
        while (enumeration.hasMoreElements()) {
            Output output = null;
            Object object = null;
            try {
                object = enumeration.nextElement();
                output = (Output)object;
            }
            catch (ClassCastException classCastException) {
                throw new BadOutputException("outputs() returned a " + object.getClass().getName() + " instead of an Output.");
            }
            this.currentOutput = output;
            this.prepare(output);
            arrayList.add(this.generateCode(output));
            arrayList.addAll(output.getExtraOutputFiles());
            this.cleanup();
        }
        return arrayList;
    }

    public final String[] generate(Object[] objectArray) throws Exception {
        String[] stringArray;
        this.verboseCodegen = this.opts.hasOption("verboseCodegen");
        this.extractOptionValues(this.opts);
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.outputs(objectArray);
        if (enumeration == null) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            stringArray = null;
            Object object = null;
            try {
                object = enumeration.nextElement();
                stringArray = (Output)object;
            }
            catch (ClassCastException classCastException) {
                throw new BadOutputException("outputs() returned a " + object.getClass().getName() + " instead of an Output.");
            }
            this.currentOutput = stringArray;
            this.prepare((Output)stringArray);
            arrayList.add(this.generateCode((Output)stringArray));
            arrayList.addAll(stringArray.getExtraOutputFiles());
            this.cleanup();
        }
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public final String generateCode(Output output) throws IOException, CodeGenerationException {
        if (this.verboseCodegen) {
            System.out.println("Generating code for " + output.getOutputFile());
        }
        this.productionRules = new Hashtable();
        this.processTemplate(this.productionRules, output, output.getTemplate());
        String[] stringArray = output.getExtraTemplates();
        for (int i = 0; i < stringArray.length; ++i) {
            this.processTemplate(this.productionRules, output, stringArray[i]);
        }
        String string = output.getOutputFile().replace('/', File.separatorChar);
        File file = this.targetFile(string, output.getPackage());
        String string2 = this.parse((String)this.productionRules.get("main"));
        this.writeToFile(string2, file);
        return file.getAbsolutePath();
    }

    protected void writeToFile(String string, File file) throws IOException {
        if (this.verboseCodegen) {
            System.out.println("Output file:  " + file.getAbsolutePath());
        }
        CodeGenerator.ensureDir(file);
        PrintWriter printWriter = this.makeOutputStream(file);
        if (this.CheckValidChar) {
            printWriter.print(CharUtils.unicodeEscapeInvalidChars(string, this.encoding));
        } else {
            printWriter.print(string);
        }
        printWriter.close();
    }

    protected Writer makeWriter(File file) throws IOException {
        if (null == this.compilerFactory) {
            this.compilerFactory = new DefaultCompilerFactory();
        }
        return this.compilerFactory.makeWriter(file);
    }

    protected PrintWriter makeOutputStream(File file) throws IOException {
        return new PrintWriter(this.makeWriter(file));
    }

    protected PrintWriter makeIndentingOutputStream(File file) throws IOException {
        IndentingWriter indentingWriter = new IndentingWriter(this.makeWriter(file), 2);
        return new PrintWriter(indentingWriter);
    }

    public File installResource(File file, String string) throws IOException {
        String string2 = file.getAbsolutePath();
        File file2 = this.targetFile(string2, string);
        if (file2.getCanonicalPath().equals(file.getCanonicalPath())) {
            return file;
        }
        CodeGenerator.ensureDir(file2);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        bufferedWriter.write(CodeGenerator.getFileChars(file));
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
        return file2;
    }

    public static char[] getFileChars(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        char[] cArray = null;
        int n = ((InputStream)fileInputStream).available();
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        if (n > 0) {
            cArray = new char[n];
            inputStreamReader.read(cArray);
        }
        ((InputStream)fileInputStream).close();
        return cArray;
    }

    public void setRootDirectoryName(String string) {
        try {
            this.opts.setOption("d", string);
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError(badOptionException);
        }
    }

    public String getRootDirectoryName() {
        return this.opts.getOption("d");
    }

    public File targetFile(String string, String string2) {
        File file;
        File file2 = new File(string);
        String string3 = file2.getAbsolutePath();
        if (string3.equals(string)) {
            return file2;
        }
        if (this.getRootDirectoryName() == null) {
            return new File(string == null ? "." : string);
        }
        String string4 = this.rootDirectory();
        File file3 = new File(string4);
        File file4 = file = string2 == null ? file3 : new File(file3, string2.replace('.', File.separatorChar));
        if (string == null) {
            return file;
        }
        return new File(file, string);
    }

    public String rootDirectory() {
        if (this.targetDirectory != null) {
            return this.targetDirectory;
        }
        String string = this.getRootDirectoryName();
        return string == null ? "." : string;
    }

    public void setTargetDirectory(String string) {
        this.targetDirectory = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public static void ensureDir(File file) {
        File file2;
        String string = file.getParent();
        if (string != null && !(file2 = new File(string)).exists()) {
            file2.mkdirs();
        }
    }

    public String parse(String string) throws CodeGenerationException {
        return this.parse(string, NON_WORD_CHARS);
    }

    public String parse(String string, String string2) throws CodeGenerationException {
        StringBuffer stringBuffer;
        block17: {
            int n = 1;
            stringBuffer = new StringBuffer(256);
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            String string3 = null;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new Error("Template has no tokens.");
            }
            string3 = stringTokenizer.nextToken();
            try {
                boolean bl = false;
                block13: while (true) {
                    char c = string3.charAt(0);
                    switch (c) {
                        case '@': {
                            string3 = stringTokenizer.nextToken();
                            this.processAt(string3, stringBuffer, n);
                            break;
                        }
                        case '\n': 
                        case '\r': {
                            try {
                                string3 = stringTokenizer.nextToken();
                                char c2 = string3.charAt(0);
                                switch (c2) {
                                    case '\n': 
                                    case '\r': {
                                        if (c2 != c) {
                                            string3 = stringTokenizer.nextToken();
                                        }
                                        stringBuffer.append(EOL);
                                        ++n;
                                        continue block13;
                                    }
                                    case '@': {
                                        stringBuffer.append(EOL);
                                        string3 = stringTokenizer.nextToken();
                                        this.processAt(string3, stringBuffer, ++n);
                                        string3 = stringTokenizer.nextToken();
                                        continue block13;
                                    }
                                }
                                stringBuffer.append(EOL);
                                ++n;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                stringBuffer.append(EOL);
                                break block17;
                            }
                        }
                        default: {
                            stringBuffer.append(string3);
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (CodeGenerationException codeGenerationException) {
                throw codeGenerationException;
            }
            catch (Exception exception) {
                throw new CodeGenerationException(exception);
            }
        }
        return stringBuffer.toString();
    }

    private void processAt(String string, StringBuffer stringBuffer, int n) throws CodeGenerationException {
        Method method = null;
        if (string.equals("@")) {
            stringBuffer.append("@");
            return;
        }
        try {
            if (this.verboseCodegen) {
                System.out.println("Invoking " + string);
            }
            method = this.getClass().getMethod(string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string2 = (String)this.productionRules.get(string);
            if (string2 != null) {
                String string3 = this.parse(string2);
                if (this.verboseCodegen) {
                    System.out.println("Adding '" + string3 + "'");
                }
                stringBuffer.append(string3);
                return;
            }
            throw new CodeGenerationException("Neither method nor production rule found for '" + string + "' " + "in " + this.currentOutput.getTemplate() + " at line " + n);
        }
        try {
            Object object = method.invoke((Object)this, (Object[])null);
            if (object == null) {
                throw new CodeGenerationException("res == null with m = " + method.getName());
            }
            String string4 = object.toString();
            if (this.verboseCodegen) {
                System.out.println("Adding '" + string4 + "'");
            }
            stringBuffer.append(string4);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string5 = "Exception: '" + throwable + "' while trying to invoke: " + method.getName() + " at line " + n;
            if (throwable.getClass().equals(CodeGenerationException.class)) {
                throw (CodeGenerationException)throwable;
            }
            throw new CodeGenerationException(string5, throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CodeGenerationException(illegalAccessException);
        }
    }

    protected void processTemplate(Hashtable hashtable, String string) throws IOException, CodeGenerationException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        this.processTemplate(hashtable, inputStream, string);
    }

    protected void processTemplate(Hashtable hashtable, Output output, String string) throws IOException, CodeGenerationException {
        this.processTemplate(hashtable, output.getTemplateStream(string), string);
    }

    private void processTemplate(Hashtable hashtable, InputStream inputStream, String string) throws IOException, CodeGenerationException {
        if (inputStream == null) {
            throw new FileNotFoundException("Production rule file '" + string + "' not found.");
        }
        if (this.verboseCodegen) {
            System.out.println("Processing template " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.processProductionRules(bufferedReader, hashtable);
        bufferedReader.close();
    }

    protected void processProductionRules(BufferedReader bufferedReader, Hashtable hashtable) throws IOException, CodeGenerationException {
        String string = null;
        String string2 = null;
        StringBuffer stringBuffer = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("@end rule: ")) {
                string2 = this.getRuleName(string);
                if (hashtable.put(string2, stringBuffer.toString()) != null) {
                    throw new CodeGenerationException("Rule '" + string2 + "' already defined.");
                }
                stringBuffer = null;
                string2 = null;
            }
            if (string2 != null) {
                stringBuffer.append(string + "\n");
            }
            if (!string.startsWith("@start rule: ")) continue;
            string2 = this.getRuleName(string);
            stringBuffer = new StringBuffer(512);
        }
        if (this.verboseCodegen) {
            System.out.println();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                System.out.println("Found rule " + string2);
            }
        }
    }

    protected String getRuleName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new Error("Invalid configuration file: " + string);
        }
        return string2;
    }

    protected String getProductionRule(String string) {
        String string2 = (String)this.productionRules.get(string);
        if (string2 == null) {
            throw new Error("No production '" + string + "' in template.");
        }
        return string2;
    }

    public String generator() {
        return this.getClass().getName();
    }

    public String time() {
        return MessageFormat.format("{0,time}", new Date());
    }

    public String date() {
        return MessageFormat.format("{0,date}", new Date());
    }

    public String year() {
        return "" + new GregorianCalendar().get(1);
    }

    public String timeAndDate() {
        return new Date().toString();
    }

    public String buildString() {
        return "Unknown";
    }

    public String javaCodeForType(Class clazz) {
        if (clazz.isPrimitive()) {
            return this.primitive_type(clazz);
        }
        if (clazz.isArray() && this.is_primitive_array(clazz)) {
            return this.primitive_type_array(clazz);
        }
        if (clazz.isArray()) {
            return this.type_array(clazz);
        }
        return clazz.getName().replace('$', '.');
    }

    public String primitive_type(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (clazz.equals(Character.TYPE)) {
            return "char";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "byte";
        }
        if (clazz.equals(Short.TYPE)) {
            return "short";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "int";
        }
        if (clazz.equals(Long.TYPE)) {
            return "long";
        }
        if (clazz.equals(Float.TYPE)) {
            return "float";
        }
        if (clazz.equals(Double.TYPE)) {
            return "double";
        }
        if (clazz.equals(Void.TYPE)) {
            return "void";
        }
        throw new AssertionError("Primitive type not found for: [" + clazz + "]");
    }

    public String type_array(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer("[]");
        int n = clazz.getName().lastIndexOf(91);
        for (int i = 0; i < n; ++i) {
            stringBuffer = stringBuffer.append("[]");
        }
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2.getName().replace('$', '.') + stringBuffer;
    }

    public Class get_component_type(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public String primitive_type_array(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        int n = clazz.getName().length() - 1;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuffer = stringBuffer.append("[]");
            }
        }
        if (clazz.getName().endsWith("[Z")) {
            return "boolean" + stringBuffer;
        }
        if (clazz.getName().endsWith("[C")) {
            return "char" + stringBuffer;
        }
        if (clazz.getName().endsWith("[B")) {
            return "byte" + stringBuffer;
        }
        if (clazz.getName().endsWith("[S")) {
            return "short" + stringBuffer;
        }
        if (clazz.getName().endsWith("[I")) {
            return "int" + stringBuffer;
        }
        if (clazz.getName().endsWith("[J")) {
            return "long" + stringBuffer;
        }
        if (clazz.getName().endsWith("[F")) {
            return "float" + stringBuffer;
        }
        if (clazz.getName().endsWith("[D")) {
            return "double" + stringBuffer;
        }
        throw new AssertionError("Primitive type not found");
    }

    public boolean is_primitive_array(Class clazz) {
        if (clazz.getName().endsWith("[Z")) {
            return true;
        }
        if (clazz.getName().endsWith("[C")) {
            return true;
        }
        if (clazz.getName().endsWith("[B")) {
            return true;
        }
        if (clazz.getName().endsWith("[S")) {
            return true;
        }
        if (clazz.getName().endsWith("[I")) {
            return true;
        }
        if (clazz.getName().endsWith("[J")) {
            return true;
        }
        if (clazz.getName().endsWith("[F")) {
            return true;
        }
        return clazz.getName().endsWith("[D");
    }

    public String exceptions(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (classArray.length == 0) {
            return "";
        }
        stringBuffer.append("throws");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(" " + classArray[i].getName());
            if (i == classArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String exceptions(Method method) {
        return this.exceptions(method.getExceptionTypes());
    }

    public String readLookup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sis.read" + this.writeLookup(string) + "();\n");
        return stringBuffer.toString();
    }

    public String argumentLookup(String string, String string2) {
        String string3 = this.baseConversion(string);
        if (string3 != null) {
            return "new " + string3 + " ( " + string2 + " )";
        }
        return string2;
    }

    public String lookupConvert(String string) {
        if (string.equals("Boolean")) {
            return ".booleanValue()";
        }
        if (string.equals("Integer")) {
            return ".intValue()";
        }
        if (string.equals("Float")) {
            return ".floatValue()";
        }
        if (string.equals("Double")) {
            return ".doubleValue()";
        }
        if (string.equals("Long")) {
            return ".longValue()";
        }
        if (string.equals("Short")) {
            return ".shortValue()";
        }
        if (string.equals("Character")) {
            return ".charValue()";
        }
        if (string.equals("Byte")) {
            return ".byteValue()";
        }
        return "";
    }

    public String classLookup(String string) {
        if (string.equals("java.lang.String")) {
            return "String";
        }
        if (string.equals("boolean")) {
            return "Boolean";
        }
        if (string.equals("int")) {
            return "Integer";
        }
        if (string.equals("short")) {
            return "Short";
        }
        if (string.equals("long")) {
            return "Long";
        }
        if (string.equals("double")) {
            return "Double";
        }
        if (string.equals("float")) {
            return "Float";
        }
        if (string.equals("char")) {
            return "Character";
        }
        if (string.equals("byte")) {
            return "Byte";
        }
        return string;
    }

    public String writeLookup(String string) {
        if (string.equals("java.lang.String")) {
            return "String";
        }
        if (string.equals("boolean")) {
            return "Boolean";
        }
        if (string.equals("int")) {
            return "Int";
        }
        if (string.equals("short")) {
            return "Short";
        }
        if (string.equals("long")) {
            return "Long";
        }
        if (string.equals("double")) {
            return "Double";
        }
        if (string.equals("float")) {
            return "Float";
        }
        if (string.equals("char")) {
            return "Char";
        }
        if (string.equals("byte")) {
            return "Byte";
        }
        return "ObjectWL";
    }

    public String parameters(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            return "";
        }
        for (int i = 0; i < classArray.length; ++i) {
            String string = this.expandArrayClass(classArray[i].getName());
            stringBuffer.append(" " + string);
            stringBuffer.append(" arg" + i);
            if (i == classArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String expandArrayClass(String string) {
        if (!string.startsWith("[")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.endsWith(";")) {
            stringBuffer.append(string.substring(string.lastIndexOf("[") + 2, string.length() - 1));
        } else if (string.endsWith("B")) {
            stringBuffer.append("byte");
        } else if (string.endsWith("I")) {
            stringBuffer.append("int");
        } else if (string.endsWith("S")) {
            stringBuffer.append("short");
        } else if (string.endsWith("J")) {
            stringBuffer.append("long");
        } else if (string.endsWith("Z")) {
            stringBuffer.append("boolean");
        } else if (string.endsWith("D")) {
            stringBuffer.append("double");
        } else if (string.endsWith("C")) {
            stringBuffer.append("char");
        } else if (string.endsWith("F")) {
            stringBuffer.append("float");
        }
        for (int i = 0; i < string.lastIndexOf("[") + 1; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public String baseConversion(String string) {
        String string2 = null;
        if (string.equals("boolean")) {
            string2 = "Boolean";
        }
        if (string.equals("int")) {
            string2 = "Integer";
        }
        if (string.equals("short")) {
            string2 = "Short";
        }
        if (string.equals("long")) {
            string2 = "Long";
        }
        if (string.equals("double")) {
            string2 = "Double";
        }
        if (string.equals("float")) {
            string2 = "Float";
        }
        if (string.equals("char")) {
            string2 = "Character";
        }
        if (string.equals("byte")) {
            string2 = "Byte";
        }
        return string2;
    }

    public void setCompilerFactory(ICompilerFactory iCompilerFactory) {
        this.compilerFactory = iCompilerFactory;
    }

    public ICompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public static class Output {
        private String outputFile;
        private String template;
        private List extraTemplates = new ArrayList();
        private String pkg;
        private List extraOutputFiles = new ArrayList();

        public Output() {
        }

        public Output(String string, String string2, String string3) {
            this.setOutputFile(string);
            this.setTemplate(string2);
            this.setPackage(string3);
        }

        public int hashCode() {
            return this.pkg == null ? this.outputFile.hashCode() : this.pkg.hashCode() ^ this.outputFile.hashCode();
        }

        public boolean equals(Object object) {
            try {
                Output output = (Output)object;
                return this.pkg == null ? this.outputFile.equals(output.outputFile) : this.pkg.equals(output.pkg) && this.outputFile.equals(output.outputFile);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public String getOutputFile() {
            return this.outputFile;
        }

        public void setOutputFile(String string) {
            this.outputFile = string;
        }

        public String getTemplate() {
            return this.template;
        }

        public InputStream getTemplateStream(String string) throws IOException {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            }
            if (inputStream == null) {
                throw new FileNotFoundException("Production rule file '" + string + "' not found.");
            }
            return inputStream;
        }

        public void setTemplate(String string) {
            this.template = string;
        }

        public void addExtraTemplate(String string) {
            this.extraTemplates.add(string);
        }

        public String[] getExtraTemplates() {
            String[] stringArray = new String[this.extraTemplates.size()];
            this.extraTemplates.toArray(stringArray);
            return stringArray;
        }

        public void addExtraOutputFiles(List list) {
            this.extraOutputFiles.addAll(list);
        }

        public List getExtraOutputFiles() {
            return this.extraOutputFiles;
        }

        public String getPackage() {
            return this.pkg;
        }

        public void setPackage(String string) {
            this.pkg = string;
        }
    }
}

