/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    protected Writer out;
    protected int indentLevel;
    private boolean needIndent = false;
    protected int depth = 0;

    public IndentingWriter(Writer writer) {
        this(writer, Integer.getInteger("weblogic.codegen.indentLevel", 4));
    }

    public IndentingWriter(Writer writer, int n) {
        this.out = writer;
        this.indentLevel = n;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n + n2;
        for (n3 = n; n3 < n4 && cArray[n] == ' '; ++n3) {
            ++n;
            --n2;
        }
        for (n3 = n; n3 < n + n2; ++n3) {
            char c = cArray[n3];
            if (c == '}') {
                this.decrDepth();
            }
            if ((c == ' ' || c == '\t') && this.needIndent) continue;
            if (this.needIndent) {
                this.indent();
            }
            this.out.write(c);
            if (c == '\n') {
                this.needIndent = true;
            }
            if (c != '{') continue;
            this.incrDepth();
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.depth; ++i) {
            this.out.write(32);
        }
        this.needIndent = false;
    }

    private void incrDepth() {
        this.depth += this.indentLevel;
    }

    private void decrDepth() {
        this.depth -= this.indentLevel;
        if (this.depth < 0) {
            this.depth = 0;
        }
    }
}

