/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SequencingEnumerator
implements Enumeration {
    private static final int SIZE_UNIT = 8;
    private Enumeration[] enums;
    private int cur = 0;
    private int tail = 0;

    public SequencingEnumerator() {
        this.enums = new Enumeration[8];
    }

    public SequencingEnumerator(Enumeration[] enumerationArray) {
        this.enums = enumerationArray;
        this.tail = enumerationArray.length;
    }

    public synchronized void addEnumeration(Enumeration enumeration) {
        if (enumeration == null) {
            throw new IllegalArgumentException("Null Enumeration passed in");
        }
        if (this.tail == this.enums.length) {
            int n = this.enums.length;
            Enumeration[] enumerationArray = new Enumeration[n + 8];
            System.arraycopy(this.enums, 0, enumerationArray, 0, n);
            this.enums = enumerationArray;
        }
        this.enums[this.tail++] = enumeration;
    }

    public boolean hasMoreElements() {
        while (this.cur < this.tail) {
            if (this.enums[this.cur].hasMoreElements()) {
                return true;
            }
            ++this.cur;
        }
        return false;
    }

    public Object nextElement() {
        while (this.cur < this.tail) {
            if (this.enums[this.cur].hasMoreElements()) {
                return this.enums[this.cur].nextElement();
            }
            ++this.cur;
        }
        throw new NoSuchElementException();
    }
}

