/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.utils.Hex;
import weblogic.utils.UnsyncStringBuffer;

public final class HttpChunkInputStream
extends FilterInputStream {
    private long currentChunkSize = -1L;
    private long chunkDataRead = 0L;
    private boolean zeroChunk = false;
    private byte[] buf = null;
    private int rdptr = -1;
    private int wtptr = -1;

    private void initChunk() throws IOException {
        if (this.zeroChunk) {
            return;
        }
        if (this.currentChunkSize > 0L && this.chunkDataRead < this.currentChunkSize) {
            return;
        }
        if (this.chunkDataRead == this.currentChunkSize && (this.in.read() != 13 || this.in.read() != 10)) {
            throw new IOException("Malformed chunk");
        }
        try {
            this.currentChunkSize = this.readChunkSize();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
        this.chunkDataRead = 0L;
        if (this.currentChunkSize == 0L) {
            this.zeroChunk = true;
            int n = -1;
            boolean bl = false;
            while (!bl && (n = this.in.read()) != -1) {
                if (n != 13) continue;
                n = this.in.read();
                if (n != 10) {
                    throw new IOException("Malformed chunk");
                }
                bl = true;
            }
            if (!bl) {
                throw new IOException("Malformed chunk");
            }
        }
    }

    private int readChunkSize() throws IOException {
        int n;
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer();
        int n2 = 0;
        boolean bl = false;
        while ((n = this.in.read()) != -1 && (n != 13 || (n = this.in.read()) != 10)) {
            char c = (char)n;
            if (!bl && Hex.isHexChar(c)) {
                unsyncStringBuffer.append(c);
                continue;
            }
            bl = true;
        }
        n2 = Integer.parseInt(unsyncStringBuffer.toString(), 16);
        return n2;
    }

    public HttpChunkInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        this.ensureOpened();
        if (this.rdptr >= 0 && this.rdptr < this.wtptr) {
            return this.readFromBuffer();
        }
        this.initChunk();
        if (this.zeroChunk) {
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        this.writeToBuffer(n);
        ++this.chunkDataRead;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        if (n4 == 0) {
            return -1;
        }
        return n4;
    }

    private long skip() throws IOException {
        this.initChunk();
        if (this.zeroChunk) {
            return -1L;
        }
        long l = this.in.skip(this.currentChunkSize - this.chunkDataRead);
        if (l == -1L) {
            return 0L;
        }
        this.chunkDataRead += l;
        return l;
    }

    public long skip(long l) throws IOException {
        long l2;
        this.ensureOpened();
        if (l <= 0L) {
            return 0L;
        }
        long l3 = 0L;
        if (this.rdptr >= 0) {
            if ((long)(this.wtptr - this.rdptr) >= l) {
                this.rdptr = (int)((long)this.rdptr + l);
                return l;
            }
            l3 = this.wtptr - this.rdptr;
            this.rdptr = -1;
            this.wtptr = -1;
            this.buf = null;
        }
        while (l - l3 >= this.currentChunkSize) {
            l2 = this.skip();
            if (l2 == -1L) {
                return l3;
            }
            l3 += l2;
        }
        if (l > l3) {
            this.initChunk();
            if (this.zeroChunk) {
                return l3;
            }
            l2 = this.in.skip(l - l3);
            this.chunkDataRead += l2;
            if (l2 == -1L) {
                return l3;
            }
            l3 += l2;
        }
        return l3;
    }

    public int available() throws IOException {
        this.ensureOpened();
        int n = 0;
        if (this.wtptr > 0) {
            n = this.wtptr;
        }
        n = this.in.available();
        return n;
    }

    private void ensureOpened() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.skipAllChunk();
        this.in.close();
        this.in = null;
    }

    public synchronized void mark(int n) {
        if (n <= 0 || this.zeroChunk) {
            return;
        }
        if (this.buf == null) {
            this.buf = new byte[n];
            this.wtptr = 0;
            this.rdptr = -1;
        } else {
            if (this.rdptr == -1) {
                this.rdptr = 0;
            }
            int n2 = this.wtptr - this.rdptr;
            byte[] byArray = new byte[n + n2];
            System.arraycopy(this.buf, this.rdptr, byArray, 0, n2);
            this.buf = null;
            this.buf = byArray;
            this.wtptr = n2;
            this.rdptr = -1;
        }
    }

    private byte readFromBuffer() {
        byte by = this.buf[this.rdptr];
        ++this.rdptr;
        return by;
    }

    private void writeToBuffer(int n) {
        if (this.buf == null) {
            return;
        }
        if (this.rdptr == this.wtptr || this.buf.length <= this.wtptr) {
            this.buf = null;
            this.rdptr = -1;
            this.wtptr = -1;
            return;
        }
        this.buf[this.wtptr] = (byte)n;
        ++this.wtptr;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpened();
        if (this.wtptr == -1) {
            throw new IOException("marked position is invalid");
        }
        this.rdptr = 0;
    }

    public boolean markSupported() {
        return true;
    }

    public boolean hasUnconsumedChunk() {
        return !this.zeroChunk;
    }

    public void skipAllChunk() throws IOException {
        while (this.hasUnconsumedChunk()) {
            this.skip();
        }
    }
}

