/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import weblogic.utils.io.ByteBufferInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringInput;

public class ByteBufferDataInputStream
extends ByteBufferInputStream
implements DataInput,
StringInput {
    public ByteBufferDataInputStream(ByteBuffer[] byteBufferArray) {
        super(byteBufferArray);
    }

    public void readFully(byte[] byArray) throws IOException {
        DataIO.readFully(this, byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        DataIO.readFully(this, byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return DataIO.skipBytes(this, n);
    }

    public boolean readBoolean() throws IOException {
        return DataIO.readBoolean(this);
    }

    public byte readByte() throws IOException {
        if (this.currentBuffer.remaining() >= 1) {
            return this.currentBuffer.get();
        }
        return DataIO.readByte(this);
    }

    public int readUnsignedByte() throws IOException {
        return DataIO.readUnsignedByte(this);
    }

    public short readShort() throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            return this.currentBuffer.getShort();
        }
        return DataIO.readShort(this);
    }

    public int readUnsignedShort() throws IOException {
        return DataIO.readUnsignedShort(this);
    }

    public char readChar() throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            return this.currentBuffer.getChar();
        }
        return DataIO.readChar(this);
    }

    public int readInt() throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            return this.currentBuffer.getInt();
        }
        return DataIO.readInt(this);
    }

    public long readLong() throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            return this.currentBuffer.getLong();
        }
        return DataIO.readLong(this);
    }

    public float readFloat() throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            return this.currentBuffer.getFloat();
        }
        return DataIO.readFloat(this);
    }

    public double readDouble() throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            return this.currentBuffer.getDouble();
        }
        return DataIO.readDouble(this);
    }

    public String readLine() throws IOException {
        return DataIO.readLine(this);
    }

    public String readUTF() throws IOException {
        return DataIO.readUTF(this);
    }

    public String readASCII() throws IOException {
        return DataIO.readASCII(this);
    }

    public String readUTF8() throws IOException {
        return DataIO.readUTF8(this);
    }
}

