/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import weblogic.utils.Hex;
import weblogic.utils.collections.PartitionedConcurrentPool;
import weblogic.utils.collections.Pool;

public final class Chunk {
    private static final int DEFAULT_CHUNK_SIZE = 4080;
    private static final int DEFAULT_PARTITION_SIZE = 4;
    private static final int DEFAULT_CHUNK_POOL_SIZE = 2048;
    public static final int CHUNK_SIZE = Chunk.getChunkSize();
    private static final Pool chunkPool = new PartitionedConcurrentPool(Chunk.getPoolSize(), Chunk.getPartitionSize());
    private static boolean memoryLow = false;
    private static final ArrayList memoryManagedList = new ArrayList();
    public final byte[] buf;
    public int end;
    public Chunk next;
    private ByteBuffer byteBuf;

    private static int getChunkSize() {
        Integer n = null;
        try {
            n = Integer.getInteger("weblogic.Chunksize");
            if (n == null) {
                n = Integer.getInteger("weblogic.utils.io.Chunk.ChunkSize");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (n == null) {
            n = new Integer(4080);
        }
        return n;
    }

    private static int getPartitionSize() {
        Integer n = null;
        try {
            n = Integer.getInteger("weblogic.PartitionSize");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (n == null) {
            n = new Integer(4);
        }
        return n;
    }

    private static int getPoolSize() {
        Integer n = null;
        try {
            n = Integer.getInteger("weblogic.utils.io.chunkpoolsize");
            if (n == null) {
                n = Integer.getInteger("weblogic.utils.io.Chunk.PoolSize");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (n == null) {
            n = new Integer(2048);
        }
        return n;
    }

    public static Chunk getChunk() {
        Chunk chunk = (Chunk)chunkPool.remove();
        if (chunk == null) {
            chunk = new Chunk();
        }
        return chunk;
    }

    public static void releaseChunk(Chunk chunk) {
        chunk.end = 0;
        chunk.next = null;
        chunk.byteBuf.clear();
        chunkPool.add(chunk);
    }

    public static void releaseChunks(Chunk chunk) {
        while (chunk != null) {
            Chunk chunk2 = chunk.next;
            Chunk.releaseChunk(chunk);
            chunk = chunk2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalLowMemoryCondition() {
        ArrayList arrayList = memoryManagedList;
        synchronized (arrayList) {
            memoryLow = true;
            memoryManagedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLowMemoryCondition() {
        ArrayList arrayList = memoryManagedList;
        synchronized (arrayList) {
            memoryLow = false;
        }
    }

    public static int size(Chunk chunk) {
        int n = 0;
        while (chunk != null) {
            n += chunk.end;
            chunk = chunk.next;
        }
        return n;
    }

    public static Chunk tail(Chunk chunk) {
        Chunk chunk2 = chunk;
        while (chunk2.next != null) {
            chunk2 = chunk2.next;
        }
        return chunk2;
    }

    public static Chunk ensureCapacity(Chunk chunk) {
        if (CHUNK_SIZE == chunk.end) {
            chunk.next = Chunk.getChunk();
            return chunk.next;
        }
        return chunk;
    }

    public static int chunkFully(Chunk chunk, InputStream inputStream) throws IOException {
        Chunk chunk2 = Chunk.tail(chunk);
        int n = 0;
        while (true) {
            chunk2 = Chunk.ensureCapacity(chunk2);
            int n2 = inputStream.read(chunk2.buf, chunk2.end, CHUNK_SIZE - chunk2.end);
            if (n2 == -1) break;
            chunk2.end += n2;
            n += n2;
        }
        return n;
    }

    public static int chunk(Chunk chunk, InputStream inputStream, int n) throws IOException {
        Chunk chunk2 = Chunk.tail(chunk);
        int n2 = n;
        while (n > 0) {
            chunk2 = Chunk.ensureCapacity(chunk2);
            int n3 = Math.min(n, CHUNK_SIZE - chunk2.end);
            int n4 = inputStream.read(chunk2.buf, chunk2.end, n3);
            if (n4 == -1) {
                return n2 - n;
            }
            chunk2.end += n4;
            n -= n4;
        }
        return n2;
    }

    public static Chunk split(Chunk chunk, int n) {
        Chunk chunk2;
        int n2 = 0;
        while (n2 < n) {
            if ((n2 += chunk.end) >= n) continue;
            chunk = chunk.next;
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            chunk2 = chunk.next;
        } else {
            chunk2 = Chunk.getChunk();
            System.arraycopy(chunk.buf, chunk.end - n3, chunk2.buf, 0, n3);
            chunk.end -= n3;
            chunk2.end = n3;
            chunk2.next = chunk.next;
        }
        chunk.next = null;
        return chunk2;
    }

    private Chunk() {
        this(CHUNK_SIZE);
    }

    public Chunk(int n) {
        this.buf = new byte[n];
        this.end = 0;
        this.next = null;
        this.byteBuf = ByteBuffer.wrap(this.buf);
    }

    public String toString() {
        return super.toString() + " - end: '" + this.end + "', buf: '" + Hex.dump(this.buf) + "', next: '" + this.next + "'";
    }

    public ByteBuffer getReadByteBuffer() {
        this.byteBuf.position(this.end);
        return this.byteBuf;
    }

    public ByteBuffer getWriteByteBuffer() {
        this.byteBuf.limit(this.end);
        return this.byteBuf;
    }
}

