/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ChunkedDataOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.ObjectOutput;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.StringOutput;

public class ChunkedObjectOutputStream
extends ChunkedDataOutputStream
implements ObjectOutput {
    private static final boolean DEBUG = false;
    private ObjectOutputStream objectStream = new NestedObjectOutputStream(this);
    private Replacer replacer = null;
    private boolean objectStreamNeedsReset = true;

    public void reset() {
        super.reset();
        try {
            this.initNestedStream();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        this.objectStreamNeedsReset = true;
    }

    public final void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    protected final Object replaceObject(Object object) throws IOException {
        return this.replacer == null ? object : this.replacer.replaceObject(object);
    }

    protected Object replaceNonSerializable(Object object) throws IOException {
        return object;
    }

    protected final void annotateClass(Class clazz) {
    }

    protected void annotateProxyClass(Class clazz) throws IOException {
    }

    protected void writeClassDescriptor(java.io.ObjectStreamClass objectStreamClass) throws IOException {
        this.writeUTF(objectStreamClass.getName());
        this.writeLong(objectStreamClass.getSerialVersionUID());
        this.writeUTF("");
    }

    public void writeObject(Object object, Class clazz) throws IOException {
        this.writeObject(object);
    }

    public void writeObject(Object object) throws IOException {
        this.getOutputStream().writeObject(object);
    }

    public ObjectOutputStream getOutputStream() {
        return this.objectStream;
    }

    public void writeObjectToPreDiabloPeer(Object object) throws IOException {
        if (!this.objectStreamNeedsReset) {
            this.getOutputStream().flush();
        }
        if (object instanceof Externalizable) {
            Externalizable externalizable = (Externalizable)object;
            Class<?> clazz = externalizable.getClass();
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
            while (objectStreamClass.hasWriteReplace() && (object = objectStreamClass.writeReplace(object)) != null && object.getClass() != clazz) {
                clazz = object.getClass();
                objectStreamClass = ObjectStreamClass.lookup(clazz);
            }
            this.writeByte(4);
            this.writeClassDescriptor(objectStreamClass.getObjectStreamClass());
            int n = this.getPosition();
            this.skip(4);
            externalizable.writeExternal(this);
            int n2 = this.getPosition();
            this.setPosition(n);
            this.writeInt(n2 - (n + 4));
            this.setPosition(n2);
        } else {
            this.writeByte(2);
            if (!(object instanceof Serializable)) {
                object = this.replaceNonSerializable(object);
            }
            if (this.objectStreamNeedsReset) {
                this.getOutputStream().reset();
                this.objectStreamNeedsReset = false;
            }
            this.getOutputStream().writeObject(object);
        }
    }

    protected void initNestedStream() throws IOException {
        this.objectStream = new NestedObjectOutputStream(this);
    }

    protected class NestedObjectOutputStream
    extends ObjectOutputStream
    implements ChunkOutput,
    StringOutput {
        protected NestedObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            try {
                this.enableReplaceObject(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        protected final void annotateClass(Class clazz) throws IOException {
            ChunkedObjectOutputStream.this.annotateClass(clazz);
        }

        protected final void annotateProxyClass(Class clazz) throws IOException {
            ChunkedObjectOutputStream.this.annotateProxyClass(clazz);
        }

        protected final Object replaceObject(Object object) throws IOException {
            return ChunkedObjectOutputStream.this.replaceObject(object);
        }

        protected final void writeClassDescriptor(java.io.ObjectStreamClass objectStreamClass) throws IOException {
            this.drain();
            ChunkedObjectOutputStream.this.writeClassDescriptor(objectStreamClass);
        }

        protected final void writeStreamHeader() throws IOException {
        }

        public final void writeChunks(Chunk chunk) throws IOException {
            this.drain();
            ChunkedObjectOutputStream.this.writeChunks(chunk);
        }

        public final void writeASCII(String string) throws IOException {
            DataIO.writeASCII(this, string);
        }

        public final void writeUTF8(String string) throws IOException {
            DataIO.writeUTF8(this, string);
        }
    }
}

