/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_SIZE = 32;
    protected byte[] buf;
    protected int count;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int n) {
        this.buf = new byte[n];
    }

    protected final void resizeBuffer(int n) {
        byte[] byArray = new byte[Math.max(this.buf.length << 1, n)];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.buf = byArray;
    }

    public final void write(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            this.resizeBuffer(n2);
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    public final void write(byte[] byArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            this.resizeBuffer(n3);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public final void reset() {
        this.count = 0;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public byte[] toRawBytes() {
        return this.buf;
    }

    public final int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }
}

