/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.VirtualJarFile;

abstract class BaseExplodedJarFile
implements VirtualJarFile {
    private Manifest manifest;
    private final HashMap entryCache = new HashMap();

    BaseExplodedJarFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            String string = "META-INF/MANIFEST.MF";
            VirtualJarEntry virtualJarEntry = (VirtualJarEntry)this.getEntry(string);
            if (virtualJarEntry == null) {
                return null;
            }
            File file = virtualJarEntry.getFile();
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    this.manifest = new Manifest(fileInputStream);
                }
                finally {
                    fileInputStream.close();
                }
            }
        }
        return this.manifest;
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        VirtualJarEntry virtualJarEntry = (VirtualJarEntry)zipEntry;
        return new FileInputStream(virtualJarEntry.getFile());
    }

    protected ZipEntry getEntry(File file, String string) {
        File file2;
        VirtualJarEntry virtualJarEntry = (VirtualJarEntry)this.entryCache.get(string);
        if (virtualJarEntry == null && (file2 = new File(file, string.replace('/', File.separatorChar))).exists()) {
            virtualJarEntry = new VirtualJarEntry(file, string);
            this.entryCache.put(string, virtualJarEntry);
        }
        return virtualJarEntry;
    }

    public boolean isDirectory() {
        return true;
    }

    public JarFile getJarFile() {
        return null;
    }

    public URL getResource(String string) {
        VirtualJarEntry virtualJarEntry = (VirtualJarEntry)this.getEntry(string);
        try {
            return virtualJarEntry == null ? null : virtualJarEntry.getFile().toURL();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static class VirtualJarEntry
    extends JarEntry {
        private File file;
        private long crc = -1L;

        VirtualJarEntry(File file, String string) {
            super(string);
            this.file = new File(file, string);
        }

        File getFile() {
            return this.file;
        }

        public int hashCode() {
            return this.file.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof VirtualJarEntry) {
                VirtualJarEntry virtualJarEntry = (VirtualJarEntry)object;
                try {
                    return this.file.getCanonicalPath().equals(virtualJarEntry.file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    throw new AssertionError((Object)("Unexpected exception " + iOException));
                }
            }
            return false;
        }

        public void setTime(long l) {
            if (this.file == null) {
                super.setTime(l);
            }
            this.file.setLastModified(l);
        }

        public long getTime() {
            if (this.file == null) {
                return super.getTime();
            }
            return this.file.lastModified();
        }

        public void setSize(long l) {
            if (this.file == null) {
                super.setSize(l);
            }
        }

        public long getSize() {
            if (this.file == null) {
                return super.getSize();
            }
            return this.file.length();
        }

        public long getCompressedSize() {
            if (this.file == null) {
                return super.getCompressedSize();
            }
            return this.file.length();
        }

        public void setCompressedSize(long l) {
            if (this.file == null) {
                super.setCompressedSize(l);
            }
        }

        public void setCrc(long l) {
            if (this.file == null) {
                super.setCrc(l);
            }
            this.crc = l;
        }

        public long getCrc() {
            if (this.crc != -1L) {
                return this.crc;
            }
            if (this.file == null) {
                return super.getCrc();
            }
            try {
                return FileUtils.computeCRC(this.file);
            }
            catch (IOException iOException) {
                return -1L;
            }
        }

        public boolean isDirectory() {
            if (this.file == null) {
                return super.isDirectory();
            }
            return this.file.isDirectory();
        }

        public String getName() {
            if (this.file != null && this.file.isDirectory()) {
                return super.getName() + "/";
            }
            return super.getName();
        }
    }
}

