/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import weblogic.utils.collections.FilteringIterator;
import weblogic.utils.jars.VirtualJarFile;

final class JarFileDelegate
implements VirtualJarFile {
    private final JarFile jarFile;

    public JarFileDelegate(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public JarFileDelegate(File file) throws IOException {
        try {
            this.jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(iOException.getMessage() + " with : " + file.getPath());
            StackTraceElement[] stackTraceElementArray = iOException.getStackTrace();
            iOException2.setStackTrace(stackTraceElementArray);
            throw iOException2;
        }
    }

    public String getName() {
        return this.jarFile.getName();
    }

    public void close() throws IOException {
        this.jarFile.close();
    }

    public Iterator entries() {
        return new Iterator(){
            Enumeration e;
            {
                this.e = JarFileDelegate.this.jarFile.entries();
            }

            public Object next() {
                return this.e.nextElement();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getEntries(String string) {
        if (string == null) {
            return this.entries();
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        Iterator iterator = this.entries();
        final String string2 = string;
        return new FilteringIterator(iterator){

            public boolean accept(Object object) {
                ZipEntry zipEntry = (ZipEntry)object;
                String string = zipEntry.getName();
                return string.startsWith(string2);
            }
        };
    }

    public URL getResource(String string) {
        ZipEntry zipEntry = this.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        String string2 = this.jarFile.getName().replace(File.separatorChar, '/');
        String string3 = string2 + '!' + '/' + zipEntry.getName();
        try {
            return new URL("zip", "", string3);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL("jar", "", new File(string3).toURL().toString());
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    public ZipEntry getEntry(String string) {
        return this.jarFile.getEntry(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.jarFile.getInputStream(zipEntry);
    }

    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    public File[] getRootFiles() {
        return new File[]{new File(this.jarFile.getName())};
    }

    public boolean isDirectory() {
        return false;
    }

    public File getDirectory() {
        return null;
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    public String toString() {
        return super.toString() + " - " + this.getName();
    }
}

