/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StreamUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class JarFileUtils {
    private static final boolean debug = true;
    private static final boolean verbose = false;
    private static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";
    private static final byte[] MAGIC_NUMBER = new byte[]{80, 75, 3, 4};

    private JarFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileFromDirectory(File file, File file2, String string) throws IOException {
        Debug.assertion(file != null);
        Debug.assertion(file2 != null);
        Debug.assertion(file2.isDirectory());
        if (file.exists()) {
            Debug.assertion(!file.isDirectory());
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(bufferedOutputStream);
            try {
                JarFileUtils.addFilesToJar(jarOutputStream, string, file2);
            }
            finally {
                jarOutputStream.close();
            }
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFilesToJar(JarOutputStream jarOutputStream, String string, File file) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string2 = file2.isDirectory() ? string + file2.getName() + '/' : string + file2.getName();
            if (MANIFEST_FILE_NAME.equals(string2)) continue;
            ZipEntry zipEntry = new ZipEntry(string2);
            zipEntry.setTime(file2.lastModified());
            jarOutputStream.putNextEntry(zipEntry);
            if (file2.isDirectory()) {
                jarOutputStream.closeEntry();
                JarFileUtils.addFilesToJar(jarOutputStream, string2, file2);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                StreamUtils.writeTo(fileInputStream, jarOutputStream);
                jarOutputStream.closeEntry();
                continue;
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    public static void createJarFileFromDirectory(String string, File file) throws IOException {
        JarFileUtils.createJarFileFromDirectory(new File(string), file);
    }

    public static void createJarFileFromDirectory(File file, File file2) throws IOException {
        JarFileUtils.createJarFileFromDirectory(file, file2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileFromDirectory(File file, File file2, boolean bl) throws IOException {
        Manifest manifest;
        File file3 = new File(file2, MANIFEST_FILE_NAME);
        if (file3.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file3);
            try {
                manifest = new Manifest(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        } else {
            manifest = bl ? new Manifest() : null;
        }
        JarFileUtils.createJarFileFromDirectory(file, file2, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileFromDirectory(File file, File file2, Manifest manifest) throws IOException {
        Debug.assertion(file != null);
        Debug.assertion(file2 != null);
        Debug.assertion(file2.isDirectory());
        if (file.exists()) {
            Debug.assertion(!file.isDirectory());
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JarOutputStream jarOutputStream = manifest != null ? new JarOutputStream((OutputStream)bufferedOutputStream, manifest) : new JarOutputStream(bufferedOutputStream);
            try {
                JarFileUtils.addFilesToJar(jarOutputStream, "", file2);
            }
            finally {
                jarOutputStream.close();
            }
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(InputStream inputStream, File file) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = File.createTempFile("__tmp", ".jar", file);
        try {
            FileUtils.writeToFile(inputStream, file2);
            JarFileUtils.extract(file2, file);
        }
        finally {
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File file, File file2) throws IOException {
        VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar(file);
        try {
            JarFileUtils.extract(virtualJarFile, file2);
        }
        finally {
            virtualJarFile.close();
        }
    }

    public static void extract(JarFile jarFile, File file) throws IOException {
        JarFileUtils.extract(VirtualJarFactory.createVirtualJar(jarFile), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(VirtualJarFile virtualJarFile, File file) throws IOException {
        Debug.assertion(virtualJarFile != null);
        Debug.assertion(file != null);
        if (file.exists()) {
            Debug.assertion(file.isDirectory());
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        file = file.getCanonicalFile();
        ArrayList<DirLastModSetter> arrayList = new ArrayList<DirLastModSetter>();
        Iterator iterator = virtualJarFile.entries();
        while (iterator.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)iterator.next();
            long l = zipEntry.getTime();
            try {
                String string = zipEntry.getName().replace('/', File.separatorChar);
                File file2 = new File(file, string);
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    arrayList.add(new DirLastModSetter(file2, l));
                    continue;
                }
                InputStream inputStream = virtualJarFile.getInputStream(zipEntry);
                try {
                    FileUtils.writeToFile(inputStream, file2);
                }
                finally {
                    inputStream.close();
                }
                file2.setLastModified(l);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PathLengthException(fileNotFoundException);
            }
        }
        JarFileUtils.updateLastModified(arrayList);
    }

    private static final void updateLastModified(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (DirLastModSetter dirLastModSetter : list) {
            dirLastModSetter.updateLastModified();
        }
        list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJar(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                int n;
                byte[] byArray = new byte[4];
                DataIO.readFully(fileInputStream, byArray);
                for (n = 0; n < 4; ++n) {
                    if (byArray[n] == MAGIC_NUMBER[n]) continue;
                    boolean bl = false;
                    return bl;
                }
                n = 1;
                return n != 0;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static final class DirLastModSetter {
        private File dir;
        private long lastModified;

        DirLastModSetter(File file, long l) {
            this.dir = file;
            this.lastModified = l;
        }

        void updateLastModified() {
            this.dir.setLastModified(this.lastModified);
        }
    }

    public static class PathLengthException
    extends FileNotFoundException {
        public PathLengthException(FileNotFoundException fileNotFoundException) {
            super(fileNotFoundException.getMessage() + "::" + "Probably the string length of the path of the file being " + "extracted was too long or failed to overwrite the file");
            super.setStackTrace(fileNotFoundException.getStackTrace());
        }
    }
}

