/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import weblogic.utils.jars.BaseExplodedJarFile;
import weblogic.utils.jars.VirtualJarFile;

final class SplitExplodedJarFile
extends BaseExplodedJarFile
implements VirtualJarFile {
    private File[] dirs;

    public SplitExplodedJarFile(File[] fileArray) {
        this.dirs = fileArray;
    }

    public SplitExplodedJarFile(File file, File file2) {
        this.dirs = new File[]{file, file2};
    }

    public String getName() {
        return this.dirs[0].toString();
    }

    public void close() {
    }

    public Iterator entries() {
        return this.getEntries("/");
    }

    public Iterator getEntries(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        HashSet hashSet = new HashSet();
        String string2 = string.replace('/', File.separatorChar);
        for (int i = 0; i < this.dirs.length; ++i) {
            if (!this.dirs[i].exists()) continue;
            this.addEntries(hashSet, new File(this.dirs[i], string2), this.dirs[i]);
        }
        return hashSet.iterator();
    }

    private void addEntries(Set set, File file, File file2) {
        File[] fileArray = file.listFiles();
        int n = file2.toString().length();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string;
            if (fileArray[i].isDirectory()) {
                this.addEntries(set, fileArray[i], file2);
                continue;
            }
            string = string.substring(n + (n == (string = fileArray[i].toString()).length() ? 0 : 1)).replace(File.separatorChar, '/');
            set.add(new BaseExplodedJarFile.VirtualJarEntry(file2, string));
        }
    }

    public ZipEntry getEntry(String string) {
        for (int i = 0; i < this.dirs.length; ++i) {
            ZipEntry zipEntry = this.getEntry(this.dirs[i], string);
            if (zipEntry == null) continue;
            return zipEntry;
        }
        return null;
    }

    public File[] getRootFiles() {
        return this.dirs;
    }

    public File getDirectory() {
        return this.dirs[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SplitExplodedJarFile{");
        if (this.dirs == null) {
            stringBuffer.append("null");
        } else {
            for (int i = 0; i < this.dirs.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.dirs[i].toString());
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

