/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.reflect;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import weblogic.utils.collections.StackPool;

public class MethodSignatureBuilder {
    public static boolean ignoreGenerics = false;
    private static final Map<String, String> typeMap = new HashMap<String, String>();

    public static String compute(Method method) {
        Class<?>[] classArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(method.getName());
        stringBuilder.append('(');
        for (Class<?> clazz : classArray = method.getParameterTypes()) {
            while (clazz.isArray()) {
                stringBuilder.append('[');
                clazz = clazz.getComponentType();
            }
            MethodSignatureBuilder.encode(clazz.getName(), stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString().intern();
    }

    private static void encode(String string, StringBuilder stringBuilder) {
        String string2 = typeMap.get(string);
        if (string2 == null) {
            stringBuilder.append("L").append(string).append(';');
        } else {
            stringBuilder.append(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compute(String string) {
        if ("*".equals(string)) {
            return string;
        }
        Parser parser = Parser.getInstance();
        parser.initialize(string);
        try {
            String string2 = parser.parse();
            return string2;
        }
        finally {
            Parser.releaseInstance(parser);
        }
    }

    static {
        typeMap.put(Byte.TYPE.getName(), "B");
        typeMap.put(Character.TYPE.getName(), "C");
        typeMap.put(Double.TYPE.getName(), "D");
        typeMap.put(Float.TYPE.getName(), "F");
        typeMap.put(Integer.TYPE.getName(), "I");
        typeMap.put(Long.TYPE.getName(), "J");
        typeMap.put(Short.TYPE.getName(), "S");
        typeMap.put(Boolean.TYPE.getName(), "Z");
    }

    private static final class Parser {
        private static final StackPool parserPool = new StackPool(5);
        private static final Object poolLock = new Object();
        private int pos = 0;
        private int strLen = 0;
        private CharSequence cs;
        private StringBuilder sb = new StringBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Parser getInstance() {
            Parser parser;
            Object object = poolLock;
            synchronized (object) {
                parser = (Parser)parserPool.remove();
            }
            if (parser == null) {
                parser = new Parser();
            }
            return parser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void releaseInstance(Parser parser) {
            parser.reset();
            Object object = poolLock;
            synchronized (object) {
                parserPool.add(parser);
            }
        }

        private Parser() {
        }

        private void initialize(CharSequence charSequence) {
            this.cs = charSequence;
            this.strLen = this.cs.length();
        }

        private void reset() {
            this.sb.delete(0, this.sb.length());
            this.pos = 0;
            this.strLen = 0;
            this.cs = null;
        }

        private String parse() {
            this.method();
            if (!this.available()) {
                this.sb.append("()");
            } else {
                this.parameterBegin();
                this.buildArgumentList();
                this.parameterEnd();
            }
            return this.sb.toString();
        }

        private void method() {
            this.consumeSpaces();
            int n = this.pos;
            while (!(!this.available() || this.isOpenBracket() || this.isSpaceTab() || this.isSquareBracketBegin() || this.isSquareBracketEnd())) {
                this.incPos(1);
            }
            this.sb.append(this.cs, n, this.pos);
            this.consumeSpaces();
        }

        private void parameterBegin() {
            if (!this.isOpenBracket()) {
                throw new IllegalArgumentException("Method Parsing failed for '" + ((Object)this.cs).toString() + "' at position " + this.pos);
            }
            this.incPos(1);
            this.sb.append('(');
        }

        private void parameterEnd() {
            if (!this.isCloseBracket()) {
                throw new IllegalArgumentException("Method Parsing failed for '" + ((Object)this.cs).toString() + "' at position " + this.pos);
            }
            this.sb.append(')');
        }

        private void buildArgumentList() {
            while (true) {
                this.consumeSpaces();
                int n = this.pos;
                while (!(!this.available() || this.isComma() || this.isCloseBracket() || this.isSpace() || this.isSquareBracketBegin())) {
                    if (this.isLessThan()) {
                        throw new IllegalArgumentException("Method Parsing failed for '" + ((Object)this.cs).toString() + "' at position " + this.pos);
                    }
                    if (this.isGreaterThan()) {
                        throw new IllegalArgumentException("Method Parsing failed for '" + ((Object)this.cs).toString() + "' at position " + this.pos);
                    }
                    this.incPos(1);
                }
                if (n == this.pos) break;
                int n2 = this.pos;
                this.handleArrays();
                this.typeStart(n, n2);
                this.typeEnd();
            }
        }

        private void handleArrays() {
            this.consumeSpaces();
            while (this.available() && !this.isComma() && !this.isCloseBracket()) {
                if (this.isSquareBracketBegin()) {
                    this.incPos(1);
                    if (this.available() && this.isSquareBracketEnd()) {
                        this.incPos(1);
                        this.sb.append('[');
                        this.consumeSpaces();
                        continue;
                    }
                }
                throw new IllegalArgumentException("Couldn't parse '" + ((Object)this.cs).toString() + "'. Found '" + this.cs.charAt(this.pos) + "' at position " + this.pos);
            }
        }

        private void typeStart(int n, int n2) {
            switch (n2 - n) {
                case 3: {
                    if (this.cs.charAt(n) == 'i' && this.cs.charAt(n + 1) == 'n' && this.cs.charAt(n + 2) == 't') {
                        this.sb.append('I');
                        break;
                    }
                    this.sb.append('L').append(this.cs, n, n2).append(';');
                    break;
                }
                case 4: {
                    if (this.cs.charAt(n) == 'b' && this.cs.charAt(n + 1) == 'y' && this.cs.charAt(n + 2) == 't' && this.cs.charAt(n + 3) == 'e') {
                        this.sb.append('B');
                        break;
                    }
                    if (this.cs.charAt(n) == 'c' && this.cs.charAt(n + 1) == 'h' && this.cs.charAt(n + 2) == 'a' && this.cs.charAt(n + 3) == 'r') {
                        this.sb.append('C');
                        break;
                    }
                    if (this.cs.charAt(n) == 'l' && this.cs.charAt(n + 1) == 'o' && this.cs.charAt(n + 2) == 'n' && this.cs.charAt(n + 3) == 'g') {
                        this.sb.append('J');
                        break;
                    }
                    this.sb.append('L').append(this.cs, n, n2).append(';');
                    break;
                }
                case 5: {
                    if (this.cs.charAt(n) == 'f' && this.cs.charAt(n + 1) == 'l' && this.cs.charAt(n + 2) == 'o' && this.cs.charAt(n + 3) == 'a' && this.cs.charAt(n + 4) == 't') {
                        this.sb.append('F');
                        break;
                    }
                    if (this.cs.charAt(n) == 's' && this.cs.charAt(n + 1) == 'h' && this.cs.charAt(n + 2) == 'o' && this.cs.charAt(n + 3) == 'r' && this.cs.charAt(n + 4) == 't') {
                        this.sb.append('S');
                        break;
                    }
                    this.sb.append('L').append(this.cs, n, n2).append(';');
                    break;
                }
                case 6: {
                    if (this.cs.charAt(n) == 'd' && this.cs.charAt(n + 1) == 'o' && this.cs.charAt(n + 2) == 'u' && this.cs.charAt(n + 3) == 'b' && this.cs.charAt(n + 4) == 'l' && this.cs.charAt(n + 5) == 'e') {
                        this.sb.append('D');
                        break;
                    }
                    this.sb.append('L').append(this.cs, n, n2).append(';');
                    break;
                }
                case 7: {
                    if (this.cs.charAt(n) == 'b' && this.cs.charAt(n + 1) == 'o' && this.cs.charAt(n + 2) == 'o' && this.cs.charAt(n + 3) == 'l' && this.cs.charAt(n + 4) == 'e' && this.cs.charAt(n + 5) == 'a' && this.cs.charAt(n + 6) == 'n') {
                        this.sb.append('Z');
                        break;
                    }
                }
                default: {
                    this.sb.append('L').append(this.cs, n, n2).append(';');
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void typeEnd() {
            if (!this.available()) {
                throw new IllegalArgumentException("Method Parsing failed for '" + ((Object)this.cs).toString() + "' at position " + this.pos);
            }
            if (this.isSpaceTab()) {
                this.consumeSpaces();
                if (!this.available()) throw new IllegalArgumentException("Method Parsing failed for '" + ((Object)this.cs).toString() + "' at position " + this.pos);
                if (!this.isComma()) return;
                this.incPos(1);
                return;
            } else if (this.isComma()) {
                this.incPos(1);
                return;
            } else {
                if (this.isCloseBracket()) return;
                throw new IllegalArgumentException("Method Parsing failed for '" + ((Object)this.cs).toString() + "' at position " + this.pos);
            }
        }

        private boolean isOpenBracket() {
            return this.cs.charAt(this.pos) == '(';
        }

        private boolean isCloseBracket() {
            return this.cs.charAt(this.pos) == ')';
        }

        private boolean isLessThan() {
            return this.cs.charAt(this.pos) == '<';
        }

        private boolean isGreaterThan() {
            return this.cs.charAt(this.pos) == '>';
        }

        private boolean isSquareBracketBegin() {
            return this.cs.charAt(this.pos) == '[';
        }

        private boolean isSquareBracketEnd() {
            return this.cs.charAt(this.pos) == ']';
        }

        private boolean isComma() {
            return this.cs.charAt(this.pos) == ',';
        }

        private boolean isSpaceTab(char c) {
            return c == ' ' || c == '\t';
        }

        private boolean isSpace() {
            return this.isSpaceTab();
        }

        private boolean isSpaceTab() {
            return this.isSpaceTab(this.cs.charAt(this.pos));
        }

        private int incPos(int n) {
            this.pos += n;
            return this.pos;
        }

        private void consumeSpaces() {
            while (this.available() && this.isSpaceTab()) {
                this.incPos(1);
            }
        }

        private boolean available() {
            return this.strLen > this.pos;
        }
    }
}

