/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security;

import com.bea.common.logger.spi.LoggableMessageSpi;
import com.bea.common.logger.spi.LoggerSpi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ProvidersLogger {
    private static final String PROPERTIES_PREFIX = "BEA";
    private static final String PROPERTIES_SUBSYSTEM = "Security";
    private static final String PROPERTIES_NAME = "ProvidersLogger";
    private static final String PROPERTIES_EXT = ".properties";
    private static final String MESSAGEBODY_PRE = "messagebody";
    private static final String SEVERITY_PRE = "severity";
    private static final String PREFIX_PRE = "[Security:";
    private static final String PREFIX_POST = "]";
    private static PropertyResourceBundle theBundle = null;

    private static String escape(String message) {
        if (message == null) {
            return null;
        }
        int index = -1;
        int len = message.length();
        for (int i = 0; i < len; ++i) {
            char c = message.charAt(i);
            if (c != '$' && c != '\\') continue;
            index = i;
            break;
        }
        if (index == -1) {
            return message;
        }
        StringBuffer buffer = new StringBuffer(len + len - index);
        if (index != 0) {
            buffer.append(message.substring(0, index));
        }
        buffer.append('\\').append(message.charAt(index));
        for (int i = index + 1; i < len; ++i) {
            char c = message.charAt(i);
            if (c == '$' || c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String formatMessage(String messageIn, Object[] args) {
        if (args == null || args.length == 0 || messageIn == null) {
            return messageIn;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            messageIn = messageIn.replaceAll("\\x7B" + i + "\\x7D", ProvidersLogger.escape(args[i].toString()));
        }
        return messageIn;
    }

    private static String getMessageBody(String messageId) {
        ResourceBundle bundle = ProvidersLogger.getResourceBundle();
        if (bundle == null) {
            return messageId;
        }
        String theMessage = null;
        try {
            theMessage = bundle.getString(MESSAGEBODY_PRE + messageId);
        }
        catch (MissingResourceException mre) {
            theMessage = messageId;
        }
        return theMessage;
    }

    private static synchronized ResourceBundle getResourceBundle() {
        if (theBundle != null) {
            return theBundle;
        }
        Locale defLocale = Locale.getDefault();
        String[] bundleNames = new String[]{"ProvidersLogger_" + defLocale.getLanguage() + "_" + defLocale.getCountry() + "_" + defLocale.getVariant() + PROPERTIES_EXT, "ProvidersLogger_" + defLocale.getLanguage() + "_" + defLocale.getCountry() + PROPERTIES_EXT, "ProvidersLogger_" + defLocale.getLanguage() + PROPERTIES_EXT, "ProvidersLogger.properties"};
        InputStream theBundleStream = null;
        ClassLoader theLoader = ProvidersLogger.class.getClassLoader();
        for (int i = 0; theBundleStream == null && i < bundleNames.length; ++i) {
            theBundleStream = theLoader.getResourceAsStream(bundleNames[i]);
        }
        if (theBundleStream == null) {
            return null;
        }
        try {
            theBundle = new PropertyResourceBundle(theBundleStream);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return theBundle;
    }

    private static void logMessage(LoggerSpi logger, String severity, LoggableMessageSpiImpl message) {
        if (severity.equals("info")) {
            logger.info((Object)message);
        } else if (severity.equals("warning")) {
            logger.warn((Object)message);
        } else if (severity.equals("error")) {
            logger.error((Object)message);
        } else if (severity.equals("alert") || severity.equals("severe")) {
            logger.severe((Object)message);
        }
    }

    public static String getNullParameterSuppliedToMethod(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099000";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullParameterSuppliedToMethodLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099000";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderUnexpectedContextElementType(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099001";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
        ProvidersLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderUnexpectedContextElementTypeLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099001";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderNullOrEmptyCertificateChain(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "099002";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
        ProvidersLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderNullOrEmptyCertificateChainLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099002";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderListenerError(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "099003";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
        ProvidersLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderListenerErrorLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "099003";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLAssertionCreateFail(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099004";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
        ProvidersLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLAssertionCreateFailLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099004";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLCouldNotMapConfirmMeth(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "099005";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
        ProvidersLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLCouldNotMapConfirmMethLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099005";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProvidereInvalidKeyConfiguration(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099006";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
        ProvidersLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProvidereInvalidKeyConfigurationLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099006";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProvidereNotInit(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099007";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
        ProvidersLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProvidereNotInitLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099007";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getStoreServicePropertiesIsNull() {
        Object[] args = new Object[]{};
        String messageId = "099008";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getStoreServicePropertiesIsNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099008";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getStoreServicePropertiesHasNullField(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099009";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getStoreServicePropertiesHasNullFieldLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099009";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getUnableDeriveKeyWithNullField(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099010";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableDeriveKeyWithNullFieldLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099010";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getUnablePasswordDigestWithNullField(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099011";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnablePasswordDigestWithNullFieldLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099011";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getUnablePasswordDigestUtf8Required(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099012";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnablePasswordDigestUtf8RequiredLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099012";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getLDAPX509IATokenNotCorrect(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099013";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getLDAPX509IATokenNotCorrectLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099013";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getNullHandlerInSAMLAssertion(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099014";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullHandlerInSAMLAssertionLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099014";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLInvalidImpExpFormat() {
        Object[] args = new Object[]{};
        String messageId = "099015";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLInvalidImpExpFormatLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099015";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotGetPartner(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099016";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotGetPartnerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099016";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotAddPartnerWithoutId() {
        Object[] args = new Object[]{};
        String messageId = "099017";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotAddPartnerWithoutIdLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099017";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotUpdateBusinessObject() {
        Object[] args = new Object[]{};
        String messageId = "099018";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotUpdateBusinessObjectLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099018";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotParseAssertion(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099019";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotParseAssertionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099019";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLAssertionCheckFail(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099020";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLAssertionCheckFailLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099020";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLAssertionNotSigned() {
        Object[] args = new Object[]{};
        String messageId = "099021";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLAssertionNotSignedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099021";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNoSigningCertAlias() {
        Object[] args = new Object[]{};
        String messageId = "099022";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNoSigningCertAliasLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099022";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNoCertForAlias(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099023";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNoCertForAliasLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099023";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNoCertInSignature() {
        Object[] args = new Object[]{};
        String messageId = "099024";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNoCertInSignatureLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099024";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCertificateNotMatch() {
        Object[] args = new Object[]{};
        String messageId = "099025";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCertificateNotMatchLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099025";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCertificateNotTrusted() {
        Object[] args = new Object[]{};
        String messageId = "099026";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCertificateNotTrustedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099026";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotCreateMapper(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099027";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotCreateMapperLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099027";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLMappingNameError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099028";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLMappingNameErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099028";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLMappingGroupError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099029";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLMappingGroupErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099029";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLMappingNoName() {
        Object[] args = new Object[]{};
        String messageId = "099030";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLMappingNoNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099030";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLAssertionInvalidBefore(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099031";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLAssertionInvalidBeforeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099031";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLAssertionInvalidOnOrAfter(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099032";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLAssertionInvalidOnOrAfterLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099032";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNoMatchingAudience() {
        Object[] args = new Object[]{};
        String messageId = "099033";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNoMatchingAudienceLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099033";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLUnrecognizedAssertionCondition() {
        Object[] args = new Object[]{};
        String messageId = "099034";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLUnrecognizedAssertionConditionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099034";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNoTargetInContextHandler() {
        Object[] args = new Object[]{};
        String messageId = "099035";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNoTargetInContextHandlerLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099035";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotMapConfirmMethod(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099036";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotMapConfirmMethodLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099036";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotGetAssertParty() {
        Object[] args = new Object[]{};
        String messageId = "099037";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotGetAssertPartyLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099037";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotVerifySignature(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099038";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotVerifySignatureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099038";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNoAssertPartyIssuerConfig() {
        Object[] args = new Object[]{};
        String messageId = "099039";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNoAssertPartyIssuerConfigLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099039";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLAssertPartyNotMatch() {
        Object[] args = new Object[]{};
        String messageId = "099040";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLAssertPartyNotMatchLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099040";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLConfirmMethodNotMatch() {
        Object[] args = new Object[]{};
        String messageId = "099041";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLConfirmMethodNotMatchLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099041";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotFindAttributeInLdift(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099042";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotFindAttributeInLdiftLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099042";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotGetBeanDescriptor(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099043";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotGetBeanDescriptorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099043";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidProviderTypeSuffix(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099044";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidProviderTypeSuffixLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099044";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownProviderType(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099045";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownProviderTypeLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099045";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalValue(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099046";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalValueLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099046";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getMissingParameter(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099047";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMissingParameterLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099047";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalValueForContext(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "099048";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalValueForContextLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "099048";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotLoadPartnerRegistryFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099049";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotLoadPartnerRegistryFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099049";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotGeneratePartnerRegistryFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099050";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotGeneratePartnerRegistryFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099050";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLImportTerminateInFailMode(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099051";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLImportTerminateInFailModeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099051";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLImportFailForCouldNotLocateFromFile(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099052";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLImportFailForCouldNotLocateFromFileLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099052";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLImportFailForAlreadyExists(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099053";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLImportFailForAlreadyExistsLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099053";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLImportFailForCouldNotLocateFromRegistry(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099054";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLImportFailForCouldNotLocateFromRegistryLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099054";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotLocateFromRegistry(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099055";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotLocateFromRegistryLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099055";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLCouldNotExportPartner(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099056";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLCouldNotExportPartnerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099056";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotDecryptPassword(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099057";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotDecryptPasswordLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099057";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNoSenderCert() {
        Object[] args = new Object[]{};
        String messageId = "099058";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNoSenderCertLoggable() {
        Object[] args = new Object[]{};
        String messageId = "099058";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLNotFoundIn(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099059";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLNotFoundInLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "099059";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    public static String getStoreServiceInvalidURL(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099060";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getStoreServiceInvalidURLLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "099060";
        return new LoggableMessageSpiImpl(messageId, ProvidersLogger.formatMessage(ProvidersLogger.getMessageBody(messageId), args));
    }

    private static class LoggableMessageSpiImpl
    implements LoggableMessageSpi {
        private String messageId = null;
        private String formattedMessageBody = null;

        LoggableMessageSpiImpl(String messageId, String formattedMessageBody) {
            this.messageId = messageId;
            this.formattedMessageBody = formattedMessageBody;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getPrefix() {
            return ProvidersLogger.PROPERTIES_PREFIX;
        }

        public String getSubsystem() {
            return ProvidersLogger.PROPERTIES_SUBSYSTEM;
        }

        public String getFormattedMessageBody() {
            return this.formattedMessageBody;
        }

        public String toString() {
            return ProvidersLogger.PREFIX_PRE + this.messageId + ProvidersLogger.PREFIX_POST + this.formattedMessageBody;
        }
    }
}

