/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security;

import com.bea.common.logger.spi.LoggableMessageSpi;
import com.bea.common.logger.spi.LoggerSpi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class SecurityLogger {
    private static final String PROPERTIES_PREFIX = "BEA";
    private static final String PROPERTIES_SUBSYSTEM = "Security";
    private static final String PROPERTIES_NAME = "SecurityLogger";
    private static final String PROPERTIES_EXT = ".properties";
    private static final String MESSAGEBODY_PRE = "messagebody";
    private static final String SEVERITY_PRE = "severity";
    private static final String PREFIX_PRE = "[Security:";
    private static final String PREFIX_POST = "]";
    private static PropertyResourceBundle theBundle = null;

    private static String escape(String message) {
        if (message == null) {
            return null;
        }
        int index = -1;
        int len = message.length();
        for (int i = 0; i < len; ++i) {
            char c = message.charAt(i);
            if (c != '$' && c != '\\') continue;
            index = i;
            break;
        }
        if (index == -1) {
            return message;
        }
        StringBuffer buffer = new StringBuffer(len + len - index);
        if (index != 0) {
            buffer.append(message.substring(0, index));
        }
        buffer.append('\\').append(message.charAt(index));
        for (int i = index + 1; i < len; ++i) {
            char c = message.charAt(i);
            if (c == '$' || c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String formatMessage(String messageIn, Object[] args) {
        if (args == null || args.length == 0 || messageIn == null) {
            return messageIn;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            messageIn = messageIn.replaceAll("\\x7B" + i + "\\x7D", SecurityLogger.escape(args[i].toString()));
        }
        return messageIn;
    }

    private static String getMessageBody(String messageId) {
        ResourceBundle bundle = SecurityLogger.getResourceBundle();
        if (bundle == null) {
            return messageId;
        }
        String theMessage = null;
        try {
            theMessage = bundle.getString(MESSAGEBODY_PRE + messageId);
        }
        catch (MissingResourceException mre) {
            theMessage = messageId;
        }
        return theMessage;
    }

    private static synchronized ResourceBundle getResourceBundle() {
        if (theBundle != null) {
            return theBundle;
        }
        Locale defLocale = Locale.getDefault();
        String[] bundleNames = new String[]{"SecurityLogger_" + defLocale.getLanguage() + "_" + defLocale.getCountry() + "_" + defLocale.getVariant() + PROPERTIES_EXT, "SecurityLogger_" + defLocale.getLanguage() + "_" + defLocale.getCountry() + PROPERTIES_EXT, "SecurityLogger_" + defLocale.getLanguage() + PROPERTIES_EXT, "SecurityLogger.properties"};
        InputStream theBundleStream = null;
        ClassLoader theLoader = SecurityLogger.class.getClassLoader();
        for (int i = 0; theBundleStream == null && i < bundleNames.length; ++i) {
            theBundleStream = theLoader.getResourceAsStream(bundleNames[i]);
        }
        if (theBundleStream == null) {
            return null;
        }
        try {
            theBundle = new PropertyResourceBundle(theBundleStream);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return theBundle;
    }

    private static void logMessage(LoggerSpi logger, String severity, LoggableMessageSpiImpl message) {
        if (severity.equals("info")) {
            logger.info((Object)message);
        } else if (severity.equals("warning")) {
            logger.warn((Object)message);
        } else if (severity.equals("error")) {
            logger.error((Object)message);
        } else if (severity.equals("alert") || severity.equals("severe")) {
            logger.severe((Object)message);
        }
    }

    public static void logUnsupportedCircularGroup(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090000";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logUnsupportedCircularGroupLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090000";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSendingLoginFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090001";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSendingLoginFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090001";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logBroadcastUnlockUserFailure(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090002";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logBroadcastUnlockUserFailureLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090002";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNativeCryptoProblemWarning(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090003";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNativeCryptoProblemWarningLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090003";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logClosingEnumerationWarning(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090004";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logClosingEnumerationWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090004";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNonexistentPrincipalWarning(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090010";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNonexistentPrincipalWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090010";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLockoutExpiredInfo(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090020";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logLockoutExpiredInfoLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090020";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logExplicitUserUnlockInfo(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090022";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logExplicitUserUnlockInfoLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090022";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSwitchedToGroupInfo(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090030";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logSwitchedToGroupInfoLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090030";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailedToSwitchGroupError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090031";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logFailedToSwitchGroupErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090031";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSwitchedToUserInfo(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090032";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logSwitchedToUserInfoLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090032";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailedToSwitchUserError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090033";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logFailedToSwitchUserErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090033";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNotListeningForSSLInfo(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090034";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "emergency", loggable);
    }

    public static LoggableMessageSpi logNotListeningForSSLInfoLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090034";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCheckUserPermissionInfo(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090038";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logCheckUserPermissionInfoLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090038";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAccessFailedInfo(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090039";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logAccessFailedInfoLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090039";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logMaxUserWarning(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090040";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logMaxUserWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090040";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logMaxGroupWarning(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090041";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logMaxGroupWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090041";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logMaxAclWarning(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090042";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logMaxAclWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090042";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logMissingGroupWarning(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090043";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logMissingGroupWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090043";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNonexistentPrincipalGroupWarning(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090044";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNonexistentPrincipalGroupWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090044";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNonexistentPermissionWarning(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090045";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNonexistentPermissionWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090045";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNonexistentAclWarning(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090046";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNonexistentAclWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090046";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNonexistentPrincipalAclWarning(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090047";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNonexistentPrincipalAclWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090047";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInMemoryFileRealmChangeWarning(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090048";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logInMemoryFileRealmChangeWarningLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090048";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNonexistentSystemUserWarning(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090049";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNonexistentSystemUserWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090049";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logErrorCreatingSecurityRuntime(LoggerSpi logger, Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090051";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logErrorCreatingSecurityRuntimeLoggable(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090051";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logErrorBadPasswordRegistered(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090052";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logErrorBadPasswordRegisteredLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090052";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLDAPRealmV1DeprecatedWarning(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090055";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logLDAPRealmV1DeprecatedWarningLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090055";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLockingUser(LoggerSpi logger, String arg0, int arg1, int arg2) {
        Object[] args = new Object[]{arg0, new Integer(arg1), new Integer(arg2)};
        String messageId = "090056";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logLockingUserLoggable(String arg0, int arg1, int arg2) {
        Object[] args = new Object[]{arg0, new Integer(arg1), new Integer(arg2)};
        String messageId = "090056";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultAuditorWriteEventError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090057";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultAuditorWriteEventErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090057";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAuditWriteEventError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090058";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logAuditWriteEventErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090058";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInvalidPrincipalError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090059";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logInvalidPrincipalErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090059";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAccessDecisionError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090060";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logAccessDecisionErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090060";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRoleMapperError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090061";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logRoleMapperErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090061";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUserProfilerError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090062";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logUserProfilerErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090062";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDeployableRoleProviderError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090063";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDeployableRoleProviderErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090063";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDeployableAuthorizationProviderError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090064";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDeployableAuthorizationProviderErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090064";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logGettingBootIdentityFromUser(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090065";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logGettingBootIdentityFromUserLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090065";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logBootPropertiesWarning(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090066";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logBootPropertiesWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090066";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRealmLockoutExpiredInfo(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090067";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logRealmLockoutExpiredInfoLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090067";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRealmBroadcastUnlockUserFailure(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090070";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logRealmBroadcastUnlockUserFailureLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090070";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logBootFilterCritical(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090072";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logBootFilterCriticalLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090072";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUpdateFilterWarn(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090073";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logUpdateFilterWarnLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090073";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInitializingLDIFForProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090074";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logInitializingLDIFForProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090074";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadedLDIFForProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090075";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logLoadedLDIFForProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090075";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailureLoadingLDIFForProvider(LoggerSpi logger, String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090076";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logFailureLoadingLDIFForProviderLoggable(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090076";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailureCreatingProviderInitFile(LoggerSpi logger, String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090077";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logFailureCreatingProviderInitFileLoggable(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090077";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRealmLockingUser(LoggerSpi logger, String arg0, String arg1, long arg2, long arg3) {
        Object[] args = new Object[]{arg0, arg1, new Long(arg2), new Long(arg3)};
        String messageId = "090078";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logRealmLockingUserLoggable(String arg0, String arg1, long arg2, long arg3) {
        Object[] args = new Object[]{arg0, arg1, new Long(arg2), new Long(arg3)};
        String messageId = "090078";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRealmSendingLoginFailure(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090079";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logRealmSendingLoginFailureLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090079";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFoundPrivateKeyInSSLConfig(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090080";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logFoundPrivateKeyInSSLConfigLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090080";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInitializingUsingRealm(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090082";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logInitializingUsingRealmLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090082";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logStoringBootIdentity(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090083";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logStoringBootIdentityLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090083";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNotBindingOnAdminPortInfo(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090084";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "emergency", loggable);
    }

    public static LoggableMessageSpi logNotBindingOnAdminPortInfoLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090084";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNotBindingOnAnyPortInfo(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090085";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "emergency", loggable);
    }

    public static LoggableMessageSpi logNotBindingOnAnyPortInfoLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090085";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNotInitOnAnyPortInfo(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090087";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "emergency", loggable);
    }

    public static LoggableMessageSpi logNotInitOnAnyPortInfoLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090087";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLDidNotFindPrivateKeyAlias(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090088";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logSSLDidNotFindPrivateKeyAliasLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090088";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLDidNotFindPrivateKeyPassPhrase(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090089";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logSSLDidNotFindPrivateKeyPassPhraseLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090089";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLCouldNotGetSecurityService(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090091";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSSLCouldNotGetSecurityServiceLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090091";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNoKeyStoreConfiguration(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090093";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logNoKeyStoreConfigurationLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090093";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLCannotInstantiateKeyStoreProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090095";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSSLCannotInstantiateKeyStoreProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090095";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLNotKeyStoreMBeans(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090096";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSSLNotKeyStoreMBeansLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090096";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCannotFindKeyManager(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090097";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logCannotFindKeyManagerLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090097";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logKeyStoreException(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090101";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logKeyStoreExceptionLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090101";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnexpectedExceptionPrivateKeyStore(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090108";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logUnexpectedExceptionPrivateKeyStoreLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090108";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLKeyFileNameError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090109";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSSLKeyFileNameErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090109";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLCertificateFileNameError(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090110";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSSLCertificateFileNameErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090110";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logClientCertEnforcedNoTrustedCA(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090112";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logClientCertEnforcedNoTrustedCALoggable() {
        Object[] args = new Object[]{};
        String messageId = "090112";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustedCAsLoadedFromKeyStore(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090113";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logTrustedCAsLoadedFromKeyStoreLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090113";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAdministrativeUserCreated(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090115";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logAdministrativeUserCreatedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090115";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUsingPrivateKeyFromKeyStore(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090116";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logUsingPrivateKeyFromKeyStoreLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090116";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLDIFEmptyForProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090118";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logLDIFEmptyForProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090118";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLDIFNotFoundForProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090119";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logLDIFNotFoundForProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090119";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustedCAFileNotFound(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090120";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logTrustedCAFileNotFoundLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090120";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustedCAsLoadedFromTrustedCAFile(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090121";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logTrustedCAsLoadedFromTrustedCAFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090121";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustedCAsLoadedFromDefaultKeyStore(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090122";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logTrustedCAsLoadedFromDefaultKeyStoreLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090122";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCannotAccessTrustedCAFile(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090123";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCannotAccessTrustedCAFileLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090123";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInvalidTrustedCAFileFormat(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090124";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logInvalidTrustedCAFileFormatLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090124";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustedCAsLoadedFromCmdLnKeyStore(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090125";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logTrustedCAsLoadedFromCmdLnKeyStoreLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090125";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logMisconfiguredWLSProviderUpdateFile(LoggerSpi logger, String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090126";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logMisconfiguredWLSProviderUpdateFileLoggable(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090126";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnreadableWLSProviderUpdateFile(LoggerSpi logger, String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090127";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logUnreadableWLSProviderUpdateFileLoggable(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090127";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUpdatingLDIFForProvider(LoggerSpi logger, String arg0, String arg1, int arg2) {
        Object[] args = new Object[]{arg0, arg1, new Integer(arg2)};
        String messageId = "090129";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logUpdatingLDIFForProviderLoggable(String arg0, String arg1, int arg2) {
        Object[] args = new Object[]{arg0, arg1, new Integer(arg2)};
        String messageId = "090129";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailureUpdatingLDIFVersion(LoggerSpi logger, String arg0, String arg1, int arg2, Exception arg3) {
        Object[] args = new Object[]{arg0, arg1, new Integer(arg2), arg3};
        String messageId = "090130";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logFailureUpdatingLDIFVersionLoggable(String arg0, String arg1, int arg2, Exception arg3) {
        Object[] args = new Object[]{arg0, arg1, new Integer(arg2), arg3};
        String messageId = "090130";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadKeyStoreKeyStoreException(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090131";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logLoadKeyStoreKeyStoreExceptionLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090131";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadKeyStoreFileNotFoundException(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090132";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logLoadKeyStoreFileNotFoundExceptionLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090132";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadKeyStoreIOException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090133";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logLoadKeyStoreIOExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090133";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadKeyStoreCertificateException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090134";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logLoadKeyStoreCertificateExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090134";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadKeyStoreNoSuchAlgorithmException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090135";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logLoadKeyStoreNoSuchAlgorithmExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090135";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logStoreKeyStoreFileNotFoundException(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090136";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logStoreKeyStoreFileNotFoundExceptionLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090136";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logStoreKeyStoreIOException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090137";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logStoreKeyStoreIOExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090137";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logStoreKeyStoreCertificateException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090138";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logStoreKeyStoreCertificateExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090138";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logStoreKeyStoreNoSuchAlgorithmException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090139";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logStoreKeyStoreNoSuchAlgorithmExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090139";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logStoreKeyStoreKeyStoreException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090140";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logStoreKeyStoreKeyStoreExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090140";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultKeyStorePrivateKeyKeyStoreNotConfigured(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090141";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logDefaultKeyStorePrivateKeyKeyStoreNotConfiguredLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090141";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultKeyStoreTrustedCAKeyStoreNotConfigured(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090142";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logDefaultKeyStoreTrustedCAKeyStoreNotConfiguredLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090142";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultKeyStorePrivateKeyKeyStoreDoesntExist(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090143";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logDefaultKeyStorePrivateKeyKeyStoreDoesntExistLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090143";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultKeyStoreTrustedCAKeyStoreDoesntExist(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090144";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logDefaultKeyStoreTrustedCAKeyStoreDoesntExistLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090144";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultKeyStorePrivateKeyKeyStoreError(LoggerSpi logger, String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090145";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultKeyStorePrivateKeyKeyStoreErrorLoggable(String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090145";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultKeyStoreTrustedCAKeyStoreError(LoggerSpi logger, String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090146";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultKeyStoreTrustedCAKeyStoreErrorLoggable(String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090146";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFilenameNotFoundInCanonicalPathCache(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090147";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logFilenameNotFoundInCanonicalPathCacheLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090147";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDomainSaveFailed(LoggerSpi logger, Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090148";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDomainSaveFailedLoggable(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090148";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSecurityConfigLoadedFromBootstrap(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090149";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logSecurityConfigLoadedFromBootstrapLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090149";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDemoTrustCertificateUsed(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090152";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logDemoTrustCertificateUsedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090152";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDemoIdentityCertificateUsed(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090153";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logDemoIdentityCertificateUsedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090153";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIdentityCertificateExpired(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090154";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logIdentityCertificateExpiredLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090154";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIdentityCertificateNotYetValid(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090155";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "emergency", loggable);
    }

    public static LoggableMessageSpi logIdentityCertificateNotYetValidLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090155";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIdentityCertificateNotValid(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090156";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logIdentityCertificateNotValidLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090156";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnableToVerifyIdentityCertificate(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090157";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logUnableToVerifyIdentityCertificateLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090157";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logPrivateKeyStoreNotFound(LoggerSpi logger, String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090158";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logPrivateKeyStoreNotFoundLoggable(String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090158";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustedCAKeyStoreNotFound(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090160";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logTrustedCAKeyStoreNotFoundLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090160";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailureSavingLDIFForProvider(LoggerSpi logger, String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090161";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logFailureSavingLDIFForProviderLoggable(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090161";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSavedLDIFForProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090162";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logSavedLDIFForProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090162";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDuplicateLDAPEntryForProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090163";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logDuplicateLDAPEntryForProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090163";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustedCAFromKeyStoreLoadFailed(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090164";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logTrustedCAFromKeyStoreLoadFailedLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090164";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIdentityKeyStoreFileNotFound(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090165";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logIdentityKeyStoreFileNotFoundLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090165";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIdentityKeyStoreLoadFailed(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090166";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logIdentityKeyStoreLoadFailedLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090166";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIdentityKeyStoreAliasNotSpecified(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090167";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logIdentityKeyStoreAliasNotSpecifiedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090167";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIdentityEntryNotFoundUnderAlias(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090168";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logIdentityEntryNotFoundUnderAliasLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090168";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadTrustedCAsFromKeyStore(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090169";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logLoadTrustedCAsFromKeyStoreLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090169";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadPrivateKeyFromKeyStore(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090170";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logLoadPrivateKeyFromKeyStoreLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090170";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadIdentityCertificateFromKeyStore(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090171";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logLoadIdentityCertificateFromKeyStoreLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090171";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNoTrustedCAsLoaded(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090172";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNoTrustedCAsLoadedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090172";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logServerTrustKeyStoreConfigError(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090173";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logServerTrustKeyStoreConfigErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090173";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logServerTrustKeyStoreMisMatchError(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090174";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logServerTrustKeyStoreMisMatchErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090174";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnrecognizedCallback() {
        Object[] args = new Object[]{};
        String messageId = "090175";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnrecognizedCallbackLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090175";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalNullSubject() {
        Object[] args = new Object[]{};
        String messageId = "090176";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalNullSubjectLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090176";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidMessageDigestRequested() {
        Object[] args = new Object[]{};
        String messageId = "090177";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidMessageDigestRequestedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090177";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullClass() {
        Object[] args = new Object[]{};
        String messageId = "090178";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullClassLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090178";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullAction() {
        Object[] args = new Object[]{};
        String messageId = "090179";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullActionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090179";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotConvertASToAU(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090180";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotConvertASToAULoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090180";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAttemptingToModifySealedSubject() {
        Object[] args = new Object[]{};
        String messageId = "090181";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAttemptingToModifySealedSubjectLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090181";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNotAPrincipal(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090182";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNotAPrincipalLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090182";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNPEInAUHashCode(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090183";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNPEInAUHashCodeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090183";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidConstraintsNone() {
        Object[] args = new Object[]{};
        String messageId = "090184";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidConstraintsNoneLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090184";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoCallbackHandlerSpecified() {
        Object[] args = new Object[]{};
        String messageId = "090185";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoCallbackHandlerSpecifiedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090185";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorCallbackNotAvailable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090186";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorCallbackNotAvailableLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090186";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToDelete(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090187";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToDeleteLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090187";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCantUpdateReadonlyPermColl() {
        Object[] args = new Object[]{};
        String messageId = "090188";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCantUpdateReadonlyPermCollLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090188";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCommoGetProxyFailed() {
        Object[] args = new Object[]{};
        String messageId = "090189";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCommoGetProxyFailedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090189";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorCreatingFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090190";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorCreatingFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090190";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorWritingRealmContents(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090191";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorWritingRealmContentsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090191";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotCreateTempFileNew(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090192";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotCreateTempFileNewLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090192";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotCreateTempFileOld(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090193";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotCreateTempFileOldLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090193";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotClearTempFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090194";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotClearTempFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090194";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotRenameTempFile(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090195";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotRenameTempFileLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090195";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotDeleteTempFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090196";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotDeleteTempFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090196";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCantFindPermission(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090197";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCantFindPermissionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090197";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoAppropriateConstructor(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090198";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoAppropriateConstructorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090198";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCantInstantiateClass(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090199";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCantInstantiateClassLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090199";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoPermissionToInstantiate(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090200";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoPermissionToInstantiateLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090200";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIncorrectArgForConstructor(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090201";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIncorrectArgForConstructorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090201";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExcInConstructor(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090202";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExcInConstructorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090202";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getTrailingTextAfterGrant() {
        Object[] args = new Object[]{};
        String messageId = "090203";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getTrailingTextAfterGrantLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090203";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnexpectedEndOfGrant() {
        Object[] args = new Object[]{};
        String messageId = "090204";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnexpectedEndOfGrantLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090204";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExpectedConstantButFound(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090205";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExpectedConstantButFoundLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090205";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExpectedQuoteButFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090206";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExpectedQuoteButFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090206";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIniVersionMismatch(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090207";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIniVersionMismatchLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090207";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIniCorruptFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090208";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIniCorruptFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090208";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIniCouldNotClose(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090209";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIniCouldNotCloseLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090209";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIniErrorOpeningFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090210";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIniErrorOpeningFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090210";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIniMgdServersCannotCallGetSalt() {
        Object[] args = new Object[]{};
        String messageId = "090211";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIniMgdServersCannotCallGetSaltLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090211";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIniMgdServersCannotCallGetKey() {
        Object[] args = new Object[]{};
        String messageId = "090212";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIniMgdServersCannotCallGetKeyLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090212";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorGettingEncryptionSvc() {
        Object[] args = new Object[]{};
        String messageId = "090213";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorGettingEncryptionSvcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090213";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnsupportedMsgType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090214";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnsupportedMsgTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090214";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnrecognizedCallbackServer() {
        Object[] args = new Object[]{};
        String messageId = "090215";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnrecognizedCallbackServerLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090215";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoCallbackHandlerSpecifiedServer() {
        Object[] args = new Object[]{};
        String messageId = "090216";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoCallbackHandlerSpecifiedServerLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090216";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorCallbackNotAvailableServer(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090217";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorCallbackNotAvailableServerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090217";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDecodingError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090218";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDecodingErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090218";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorDecryptingKey(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090219";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorDecryptingKeyLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090219";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRuleDenied(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090220";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRuleDeniedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090220";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getConnFilterInternalErr() {
        Object[] args = new Object[]{};
        String messageId = "090221";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getConnFilterInternalErrLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090221";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownProtocol(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090222";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownProtocolLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090222";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getBadNetMaskBits(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090223";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getBadNetMaskBitsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090223";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getBadNetMaskTokens(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090224";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getBadNetMaskTokensLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090224";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getBadNetMaskNum(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090225";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getBadNetMaskNumLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090225";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getBadNetMaskFormat(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090226";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getBadNetMaskFormatLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090226";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getBadAction(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090227";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getBadActionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090227";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullFilter() {
        Object[] args = new Object[]{};
        String messageId = "090228";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullFilterLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090228";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSetFilterMoreThanOnce() {
        Object[] args = new Object[]{};
        String messageId = "090229";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSetFilterMoreThanOnceLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090229";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getZeroLengthPemInputStream() {
        Object[] args = new Object[]{};
        String messageId = "090230";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getZeroLengthPemInputStreamLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090230";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecurityAlreadyConfigured() {
        Object[] args = new Object[]{};
        String messageId = "090231";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecurityAlreadyConfiguredLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090231";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSaltNotSet() {
        Object[] args = new Object[]{};
        String messageId = "090232";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSaltNotSetLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090232";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemWithConnFilterRules() {
        Object[] args = new Object[]{};
        String messageId = "090233";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemWithConnFilterRulesLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090233";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuditorProviderNotInitialized() {
        Object[] args = new Object[]{};
        String messageId = "090234";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuditorProviderNotInitializedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090234";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidAuditSeverity() {
        Object[] args = new Object[]{};
        String messageId = "090235";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidAuditSeverityLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090235";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefAtnConstructorFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090236";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefAtnConstructorFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090236";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getValidationOldPwFailed() {
        Object[] args = new Object[]{};
        String messageId = "090237";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getValidationOldPwFailedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090237";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotCreateMapper() {
        Object[] args = new Object[]{};
        String messageId = "090238";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotCreateMapperLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090238";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIATypeCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090239";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIATypeCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090239";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIATokenCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090240";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIATokenCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090240";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIATypeNotConfigured(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090241";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIATypeNotConfiguredLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090241";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getClientNotTrusted(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090242";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getClientNotTrustedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090242";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserNameMapperNotConfig() {
        Object[] args = new Object[]{};
        String messageId = "090243";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserNameMapperNotConfigLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090243";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownIdentityAssertionType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090244";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownIdentityAssertionTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090244";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoMappingForUsername() {
        Object[] args = new Object[]{};
        String messageId = "090245";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoMappingForUsernameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090245";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getTokenNotTypeAU(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090246";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getTokenNotTypeAULoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090246";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToVerify(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090247";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToVerifyLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090247";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnrecognizedIACallback() {
        Object[] args = new Object[]{};
        String messageId = "090248";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnrecognizedIACallbackLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090248";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCursorIsNull() {
        Object[] args = new Object[]{};
        String messageId = "090249";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCursorIsNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090249";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCursorNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090250";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCursorNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090250";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getHaveCurrentError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090251";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getHaveCurrentErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090251";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAdvanceError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090252";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAdvanceErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090252";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCloseError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090253";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCloseErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090253";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNameCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090254";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNameCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090254";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserOrGroupNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090255";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserOrGroupNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090255";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorSettingDesc(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090256";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorSettingDescLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090256";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getGroupCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090257";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getGroupCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090257";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMaxCanNotBeLessThanZero() {
        Object[] args = new Object[]{};
        String messageId = "090258";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMaxCanNotBeLessThanZeroLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090258";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getGroupNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090259";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getGroupNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090259";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorListingGroupMembers(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090260";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorListingGroupMembersLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090260";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWildcardCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090261";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWildcardCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090261";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorListingGroups(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090262";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorListingGroupsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090262";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getParentGroupCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090263";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getParentGroupCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090263";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMemberCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090264";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMemberCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090264";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMemberCanNotBeParent() {
        Object[] args = new Object[]{};
        String messageId = "090265";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMemberCanNotBeParentLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090265";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getGroupNameCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090266";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getGroupNameCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090266";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getGroupAlreadyExists(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090267";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getGroupAlreadyExistsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090267";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserAlreadyExistsGroup(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090268";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserAlreadyExistsGroupLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090268";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorAddingGroup(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090269";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorAddingGroupLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090269";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getGroupCanNotBeSameAsMember() {
        Object[] args = new Object[]{};
        String messageId = "090270";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getGroupCanNotBeSameAsMemberLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090270";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMemberNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090271";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMemberNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090271";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorAddingMemberToGroup(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090272";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorAddingMemberToGroupLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090272";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMemberCanNotBeGroup() {
        Object[] args = new Object[]{};
        String messageId = "090273";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMemberCanNotBeGroupLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090273";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorRemovingMemberFromGroup(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090274";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorRemovingMemberFromGroupLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090274";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorRemovingGroup(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090275";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorRemovingGroupLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090275";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorRemovingGroupInvCursor(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090276";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorRemovingGroupInvCursorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090276";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorDestroyingProvider() {
        Object[] args = new Object[]{};
        String messageId = "090277";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorDestroyingProviderLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090277";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorListingMemberGroups(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090278";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorListingMemberGroupsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090278";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorListingUsers(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090279";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorListingUsersLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090279";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090280";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090280";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserNameCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090281";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserNameCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090281";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPasswordCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090282";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPasswordCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090282";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserAlreadyExists(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090283";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserAlreadyExistsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090283";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getGroupAlreadyExistsUser(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090284";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getGroupAlreadyExistsUserLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090284";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPasswordMinLength(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090285";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPasswordMinLengthLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090285";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorAddingUser(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090286";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorAddingUserLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090286";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090287";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090287";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidPasswordForUser(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090288";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidPasswordForUserLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090288";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorChangingPassword(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090289";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorChangingPasswordLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090289";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorRemovingUser(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090290";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorRemovingUserLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090290";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvSearchScope(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090291";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvSearchScopeLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090291";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getErrorCreatingProvider() {
        Object[] args = new Object[]{};
        String messageId = "090293";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getErrorCreatingProviderLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090293";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotGetConnection() {
        Object[] args = new Object[]{};
        String messageId = "090294";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotGetConnectionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090294";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCaughtUnexpectedExc() {
        Object[] args = new Object[]{};
        String messageId = "090295";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCaughtUnexpectedExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090295";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidURL(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090296";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidURLLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090296";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoCallbackHdlrSpecified() {
        Object[] args = new Object[]{};
        String messageId = "090297";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoCallbackHdlrSpecifiedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090297";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoDelegateSpecified() {
        Object[] args = new Object[]{};
        String messageId = "090298";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoDelegateSpecifiedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090298";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUsernameNotSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090299";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUsernameNotSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090299";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserDoesNotExist(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090300";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserDoesNotExistLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090300";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPasswordNotSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090301";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPasswordNotSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090301";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserDenied(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090302";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserDeniedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090302";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuthFailedLDAP(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090303";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuthFailedLDAPLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090303";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuthFailedExc(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090304";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuthFailedExcLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090304";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuthFailedNotFnd(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090305";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuthFailedNotFndLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090305";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuthFailedGroupsExc(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090306";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuthFailedGroupsExcLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090306";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefAuthImplConstrFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090307";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefAuthImplConstrFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090307";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getValidationOldPasswordFailed() {
        Object[] args = new Object[]{};
        String messageId = "090308";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getValidationOldPasswordFailedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090308";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullSubject() {
        Object[] args = new Object[]{};
        String messageId = "090309";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullSubjectLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090309";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToCreateResource() {
        Object[] args = new Object[]{};
        String messageId = "090310";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToCreateResourceLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090310";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToSetResource() {
        Object[] args = new Object[]{};
        String messageId = "090311";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToSetResourceLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090311";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPolicyRemovalError() {
        Object[] args = new Object[]{};
        String messageId = "090313";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPolicyRemovalErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090313";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToConnectLDAP(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090314";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToConnectLDAPLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090314";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefAuthImplInitFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090315";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefAuthImplInitFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090315";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullHelper() {
        Object[] args = new Object[]{};
        String messageId = "090316";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullHelperLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090316";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getBugInPredicateArg() {
        Object[] args = new Object[]{};
        String messageId = "090317";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getBugInPredicateArgLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090317";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefRoleMapperInitFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090318";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefRoleMapperInitFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090318";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownResourceType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090319";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownResourceTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090319";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToCreateRole() {
        Object[] args = new Object[]{};
        String messageId = "090320";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToCreateRoleLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090320";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToSetRoleExpr() {
        Object[] args = new Object[]{};
        String messageId = "090321";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToSetRoleExprLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090321";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRoleRemovalError() {
        Object[] args = new Object[]{};
        String messageId = "090322";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRoleRemovalErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090322";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMapCanNotBeModified() {
        Object[] args = new Object[]{};
        String messageId = "090323";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMapCanNotBeModifiedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090323";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefCredMapperInitFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090324";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefCredMapperInitFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090324";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoListAvailable() {
        Object[] args = new Object[]{};
        String messageId = "090325";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoListAvailableLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090325";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getListCredentialsLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090326";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getListCredentialsLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090326";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoSuchCredListCursorAvail() {
        Object[] args = new Object[]{};
        String messageId = "090327";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoSuchCredListCursorAvailLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090327";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoSuchCredListCursorAvailPw() {
        Object[] args = new Object[]{};
        String messageId = "090328";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoSuchCredListCursorAvailPwLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090328";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getListMappingsGotLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090329";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getListMappingsGotLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090329";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoSuchResourceMapsCursor() {
        Object[] args = new Object[]{};
        String messageId = "090330";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoSuchResourceMapsCursorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090330";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoSuchResourceMapsCursorRemoteUser() {
        Object[] args = new Object[]{};
        String messageId = "090331";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoSuchResourceMapsCursorRemoteUserLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090331";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRemoteUserNameGotLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090332";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRemoteUserNameGotLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090332";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRemoteUserPasswordGotLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090333";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRemoteUserPasswordGotLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090333";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSetUserPasswordCredGotLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090334";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSetUserPasswordCredGotLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090334";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSetUserPasswordCredMapGotLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090335";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSetUserPasswordCredMapGotLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090335";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRemoveUserPasswordCredGotLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090336";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRemoveUserPasswordCredGotLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090336";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRemoveUserPwCredMapGotLDAPExc() {
        Object[] args = new Object[]{};
        String messageId = "090337";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRemoveUserPwCredMapGotLDAPExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090337";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotCreateAuditLogFileExc(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090339";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotCreateAuditLogFileExcLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090339";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCouldNotDeleteAuditLog() {
        Object[] args = new Object[]{};
        String messageId = "090343";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCouldNotDeleteAuditLogLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090343";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getValidRealmNameMustBeSpecifed() {
        Object[] args = new Object[]{};
        String messageId = "090344";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getValidRealmNameMustBeSpecifedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090344";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMissingAuditorConfigMBean() {
        Object[] args = new Object[]{};
        String messageId = "090345";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMissingAuditorConfigMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090345";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuditorInitializeExc() {
        Object[] args = new Object[]{};
        String messageId = "090346";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuditorInitializeExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090346";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuditorNotInitialized() {
        Object[] args = new Object[]{};
        String messageId = "090347";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuditorNotInitializedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090347";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoAuthAndNoAdjMBeans() {
        Object[] args = new Object[]{};
        String messageId = "090348";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoAuthAndNoAdjMBeansLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090348";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNeedAtLeastOneAuthMBean() {
        Object[] args = new Object[]{};
        String messageId = "090349";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNeedAtLeastOneAuthMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090349";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRoleMgrMustBeInitBeforeAuth() {
        Object[] args = new Object[]{};
        String messageId = "090350";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRoleMgrMustBeInitBeforeAuthLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090350";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemGettingAccessDecision() {
        Object[] args = new Object[]{};
        String messageId = "090351";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemGettingAccessDecisionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090351";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemGettingAdjudicator() {
        Object[] args = new Object[]{};
        String messageId = "090352";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemGettingAdjudicatorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090352";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getOnlyAuthAndAdjPassedToInit() {
        Object[] args = new Object[]{};
        String messageId = "090353";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getOnlyAuthAndAdjPassedToInitLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090353";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoDeployableAuthProvidersConfigured() {
        Object[] args = new Object[]{};
        String messageId = "090354";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoDeployableAuthProvidersConfiguredLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090354";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMultipleAuthNoAdjudicator() {
        Object[] args = new Object[]{};
        String messageId = "090355";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMultipleAuthNoAdjudicatorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090355";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoAuthMBean() {
        Object[] args = new Object[]{};
        String messageId = "090356";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoAuthMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090356";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCallingIsProtectedBeforeInit() {
        Object[] args = new Object[]{};
        String messageId = "090357";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCallingIsProtectedBeforeInitLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090357";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getReqParamNotSuppliedIsAccess() {
        Object[] args = new Object[]{};
        String messageId = "090358";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getReqParamNotSuppliedIsAccessLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090358";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getReqParamNotSuppliedIsProt() {
        Object[] args = new Object[]{};
        String messageId = "090359";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getReqParamNotSuppliedIsProtLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090359";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDeployableAuthProvNotConfig() {
        Object[] args = new Object[]{};
        String messageId = "090360";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDeployableAuthProvNotConfigLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090360";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvCredMgrConfigMBean() {
        Object[] args = new Object[]{};
        String messageId = "090361";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvCredMgrConfigMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090361";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCredMgrInitFailed() {
        Object[] args = new Object[]{};
        String messageId = "090362";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCredMgrInitFailedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090362";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCredMgrNotYetInit() {
        Object[] args = new Object[]{};
        String messageId = "090363";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCredMgrNotYetInitLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090363";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCredentialsTypeNull() {
        Object[] args = new Object[]{};
        String messageId = "090364";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCredentialsTypeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090364";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDelegateLoginModuleError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090365";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDelegateLoginModuleErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090365";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullDelegateLoginModule() {
        Object[] args = new Object[]{};
        String messageId = "090366";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullDelegateLoginModuleLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090366";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvResourceInitNYI() {
        Object[] args = new Object[]{};
        String messageId = "090367";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvResourceInitNYILoggable() {
        Object[] args = new Object[]{};
        String messageId = "090367";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMBeansNotKeyStoreMBean() {
        Object[] args = new Object[]{};
        String messageId = "090368";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMBeansNotKeyStoreMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090368";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemInitKeyStoreProv() {
        Object[] args = new Object[]{};
        String messageId = "090369";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemInitKeyStoreProvLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090369";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoAuthMBeansInvConfig() {
        Object[] args = new Object[]{};
        String messageId = "090370";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoAuthMBeansInvConfigLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090370";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemInitAuthProv(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090371";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemInitAuthProvLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090371";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoCallbackHandlerSuppliedPA() {
        Object[] args = new Object[]{};
        String messageId = "090372";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoCallbackHandlerSuppliedPALoggable() {
        Object[] args = new Object[]{};
        String messageId = "090372";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAuthFailedUserLockedOut(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090373";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuthFailedUserLockedOutLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090373";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoConfiguredAuthProviders() {
        Object[] args = new Object[]{};
        String messageId = "090374";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoConfiguredAuthProvidersLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090374";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullTokenTypeParam() {
        Object[] args = new Object[]{};
        String messageId = "090375";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullTokenTypeParamLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090375";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullTokenParam() {
        Object[] args = new Object[]{};
        String messageId = "090376";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullTokenParamLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090376";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIdentityAssertionFailedExc(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090377";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIdentityAssertionFailedExcLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090377";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIdentityAssertionHdlrFailedExc(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090378";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIdentityAssertionHdlrFailedExcLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090378";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIdentityAssertionHdlrNoUser() {
        Object[] args = new Object[]{};
        String messageId = "090379";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIdentityAssertionHdlrNoUserLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090379";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIAHdlrUnsupTokenType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090380";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIAHdlrUnsupTokenTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090380";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoChallengeIAConfiguredForToken(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090381";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoChallengeIAConfiguredForTokenLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090381";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoChallengeIAAvailableForToken(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090382";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoChallengeIAAvailableForTokenLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090382";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getConfigErrorPrinValidatorMapping(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090383";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getConfigErrorPrinValidatorMappingLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090383";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoProviderMBeans() {
        Object[] args = new Object[]{};
        String messageId = "090384";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoProviderMBeansLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090384";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNonRoleMapperMBeanPassed() {
        Object[] args = new Object[]{};
        String messageId = "090385";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNonRoleMapperMBeanPassedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090385";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemGettingRoleMapper() {
        Object[] args = new Object[]{};
        String messageId = "090386";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemGettingRoleMapperLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090386";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoBackPointerToRealmMBean() {
        Object[] args = new Object[]{};
        String messageId = "090388";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoBackPointerToRealmMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090388";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRoleMgrNotYetInitialized() {
        Object[] args = new Object[]{};
        String messageId = "090389";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRoleMgrNotYetInitializedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090389";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullUserIdentity() {
        Object[] args = new Object[]{};
        String messageId = "090391";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullUserIdentityLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090391";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecServiceMgrNotYetInit() {
        Object[] args = new Object[]{};
        String messageId = "090392";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecServiceMgrNotYetInitLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090392";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecServiceNotYetInit(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090393";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecServiceNotYetInitLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090393";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMustSpecifyRealm() {
        Object[] args = new Object[]{};
        String messageId = "090394";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMustSpecifyRealmLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090394";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMustSpecifySecServiceType() {
        Object[] args = new Object[]{};
        String messageId = "090395";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMustSpecifySecServiceTypeLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090395";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getRealmDoesNotExist(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090396";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getRealmDoesNotExistLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090396";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPrincipalSetDoesNotContainRAUser() {
        Object[] args = new Object[]{};
        String messageId = "090397";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPrincipalSetDoesNotContainRAUserLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090397";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidSubject(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090398";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidSubjectLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090398";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecurityServicesUnavailable() {
        Object[] args = new Object[]{};
        String messageId = "090399";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecurityServicesUnavailableLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090399";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSetSecCredExc() {
        Object[] args = new Object[]{};
        String messageId = "090400";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSetSecCredExcLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090400";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotLookupInfoForNonDefaultRealm() {
        Object[] args = new Object[]{};
        String messageId = "090401";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotLookupInfoForNonDefaultRealmLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090401";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logBootIdentityNotValid(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090402";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logBootIdentityNotValidLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090402";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAuthDeniedForUser(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090403";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logAuthDeniedForUserLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090403";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUserNotPermittedToBoot(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090404";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logUserNotPermittedToBootLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090404";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanOnlyInitSecServiceOnce() {
        Object[] args = new Object[]{};
        String messageId = "090405";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanOnlyInitSecServiceOnceLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090405";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailureLoadingMBeans(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090406";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailureLoadingMBeansLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090406";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvSecConfigNoDefaultRealm() {
        Object[] args = new Object[]{};
        String messageId = "090407";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvSecConfigNoDefaultRealmLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090407";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecConfigUnavailable() {
        Object[] args = new Object[]{};
        String messageId = "090408";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecConfigUnavailableLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090408";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecCredUnavailable() {
        Object[] args = new Object[]{};
        String messageId = "090409";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecCredUnavailableLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090409";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmName(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090410";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNameLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090410";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecRealmInvConfig(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090411";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecRealmInvConfigLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090411";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToInitRealm(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090412";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToInitRealmLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090412";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoRealmMBeanUnableToInit() {
        Object[] args = new Object[]{};
        String messageId = "090413";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoRealmMBeanUnableToInitLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090413";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNeedToConfigureOneRoleMapper() {
        Object[] args = new Object[]{};
        String messageId = "090414";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNeedToConfigureOneRoleMapperLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090414";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNeedToConfigureOneAtzMBean() {
        Object[] args = new Object[]{};
        String messageId = "090415";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNeedToConfigureOneAtzMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090415";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotConfigureKeyStoreProviders(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090416";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotConfigureKeyStoreProvidersLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090416";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotConfigureSSLInvParam(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090417";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotConfigureSSLInvParamLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090417";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotConfigureSSLPermDenied(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090418";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotConfigureSSLPermDeniedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090418";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSubjectIsNotTheKernelIdentity(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090419";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSubjectIsNotTheKernelIdentityLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090419";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecProvErrorCreationExc(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090420";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecProvErrorCreationExcLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090420";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecProvErrorNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090421";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecProvErrorNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090421";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToConvertToJavaxCert() {
        Object[] args = new Object[]{};
        String messageId = "090422";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToConvertToJavaxCertLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090422";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToFindServerCertFile(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090423";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToFindServerCertFileLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090423";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotFindPrivateKeyWithAlias(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090424";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotFindPrivateKeyWithAliasLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090424";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotPrivateKeyFile(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090425";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotPrivateKeyFileLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090425";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotReadPrivateKeyFile(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090426";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotReadPrivateKeyFileLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090426";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotFindPrivateKeyFile(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090427";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotFindPrivateKeyFileLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090427";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCanNotCallSetJava2SecurityMoreThanOnce() {
        Object[] args = new Object[]{};
        String messageId = "090428";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCanNotCallSetJava2SecurityMoreThanOnceLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090428";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNotInAWeblogicServerContext() {
        Object[] args = new Object[]{};
        String messageId = "090429";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNotInAWeblogicServerContextLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090429";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUserLockoutImplConstrFailedExc(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090430";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUserLockoutImplConstrFailedExcLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090430";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getReceivedANullUserName() {
        Object[] args = new Object[]{};
        String messageId = "090431";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getReceivedANullUserNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090431";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getHashTableHasKeyButCanNotGet() {
        Object[] args = new Object[]{};
        String messageId = "090432";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getHashTableHasKeyButCanNotGetLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090432";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInconsistentInvalidLoginRecord() {
        Object[] args = new Object[]{};
        String messageId = "090433";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInconsistentInvalidLoginRecordLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090433";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEnumeratorReturnedNullElement() {
        Object[] args = new Object[]{};
        String messageId = "090434";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEnumeratorReturnedNullElementLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090434";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSubjectDoesNotHavePermissionToUnlock(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090435";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSubjectDoesNotHavePermissionToUnlockLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090435";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInconsistentHashTableKeyExists() {
        Object[] args = new Object[]{};
        String messageId = "090436";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInconsistentHashTableKeyExistsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090436";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSecurityServiceUnavailable() {
        Object[] args = new Object[]{};
        String messageId = "090437";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSecurityServiceUnavailableLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090437";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidParameterAdminAccount() {
        Object[] args = new Object[]{};
        String messageId = "090438";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidParameterAdminAccountLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090438";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidFileParameterAdminAccount(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090439";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidFileParameterAdminAccountLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090439";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEncryptionError() {
        Object[] args = new Object[]{};
        String messageId = "090440";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEncryptionErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090440";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInternalError() {
        Object[] args = new Object[]{};
        String messageId = "090441";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInternalErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090441";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getLocationNullOrEmpty() {
        Object[] args = new Object[]{};
        String messageId = "090442";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getLocationNullOrEmptyLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090442";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullFile() {
        Object[] args = new Object[]{};
        String messageId = "090443";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullFileLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090443";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullKeystore() {
        Object[] args = new Object[]{};
        String messageId = "090444";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullKeystoreLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090444";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullOrEmptyPassPhrase() {
        Object[] args = new Object[]{};
        String messageId = "090445";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullOrEmptyPassPhraseLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090445";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidBaseTemplate() {
        Object[] args = new Object[]{};
        String messageId = "090446";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidBaseTemplateLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090446";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidFlagValue(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090447";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidFlagValueLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090447";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidFormat(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090448";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidFormatLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090448";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidConstraints() {
        Object[] args = new Object[]{};
        String messageId = "090449";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidConstraintsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090449";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidNameSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090450";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidNameSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090450";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToReadFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090451";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToReadFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090451";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getImportOnlyAvailableOnAdminServer() {
        Object[] args = new Object[]{};
        String messageId = "090452";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getImportOnlyAvailableOnAdminServerLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090452";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getImportFileError() {
        Object[] args = new Object[]{};
        String messageId = "090453";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getImportFileErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090453";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoBaseDataToExport() {
        Object[] args = new Object[]{};
        String messageId = "090454";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoBaseDataToExportLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090454";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExportFileError() {
        Object[] args = new Object[]{};
        String messageId = "090455";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExportFileErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090455";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getThreeArgumentsRequired() {
        Object[] args = new Object[]{};
        String messageId = "090456";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getThreeArgumentsRequiredLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090456";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getTypeMustValueIs(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090457";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getTypeMustValueIsLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090457";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSignatureTypeCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090458";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSignatureTypeCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090458";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSignedByCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090459";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSignedByCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090459";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSSLContextWrapperConfigError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090460";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSSLContextWrapperConfigErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090460";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getClassNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090461";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getClassNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090461";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalAccessOnContextWrapper(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090462";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalAccessOnContextWrapperLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090462";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInstantiationExcOnContextWrapper(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090463";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInstantiationExcOnContextWrapperLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090463";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemAccessingPrivateKey() {
        Object[] args = new Object[]{};
        String messageId = "090464";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemAccessingPrivateKeyLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090464";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemWithCertificateChain(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090465";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemWithCertificateChainLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090465";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAssertionIllegalKeystoresValue(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090466";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAssertionIllegalKeystoresValueLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090466";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getProblemWithConnFilter() {
        Object[] args = new Object[]{};
        String messageId = "090467";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getProblemWithConnFilterLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090467";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMustSetAuditProviderClassName() {
        Object[] args = new Object[]{};
        String messageId = "090468";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMustSetAuditProviderClassNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090468";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidFileFormat() {
        Object[] args = new Object[]{};
        String messageId = "090469";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidFileFormatLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090469";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNoDeployableProviderProperlyConfigured(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090470";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logNoDeployableProviderProperlyConfiguredLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090470";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnableToDeploySecurityInformation(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090471";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logUnableToDeploySecurityInformationLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090471";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnableToUndeploySecurityInformation(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090472";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logUnableToUndeploySecurityInformationLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090472";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefAuthImplSearchFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090473";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefAuthImplSearchFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090473";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCreateTempFileFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090474";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCreateTempFileFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090474";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logPlaintextProtocolClientError(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090475";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logPlaintextProtocolClientErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090475";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logProtocolVersionError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090476";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logProtocolVersionErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090476";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHandshakeCertUntrustedError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090477";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHandshakeCertUntrustedErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090477";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHandshakeCertInvalidError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090478";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHandshakeCertInvalidErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090478";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHandshakeCertExpiredError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090479";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHandshakeCertExpiredErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090479";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAlertReceivedFromPeer(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090480";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logAlertReceivedFromPeerLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090480";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNoCertificateAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090481";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNoCertificateAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090481";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logBadCertificateAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090482";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logBadCertificateAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090482";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateRevokedAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090483";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateRevokedAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090483";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateExpiredAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090484";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateExpiredAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090484";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateUnknownAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090485";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateUnknownAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090485";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnsupportedCertificateAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090486";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logUnsupportedCertificateAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090486";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnknownCAAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090487";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logUnknownCAAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090487";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logProtocolVersionAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090488";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logProtocolVersionAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090488";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNoRenegotiationAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090489";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNoRenegotiationAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090489";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAccessDeniedAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090490";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logAccessDeniedAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090490";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInsufficientSecurityAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090491";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logInsufficientSecurityAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090491";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnexpectedMessageAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090492";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logUnexpectedMessageAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090492";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logBadRecordMacAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090493";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logBadRecordMacAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090493";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDecryptionFailedAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090494";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDecryptionFailedAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090494";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRecordOverFlowAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090495";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logRecordOverFlowAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090495";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDecompressionFailureAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090496";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDecompressionFailureAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090496";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHandshakeFailureAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090497";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHandshakeFailureAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090497";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIllegalParameterAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090498";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logIllegalParameterAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090498";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDecodeErrorAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090499";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDecodeErrorAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090499";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDecryptErrorAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090500";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDecryptErrorAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090500";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logExportRestrictionAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090501";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logExportRestrictionAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090501";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInternalErrorAlertReceivedFromPeer(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090502";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logInternalErrorAlertReceivedFromPeerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090502";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateAndPrivateKeyMismatched(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090503";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateAndPrivateKeyMismatchedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090503";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHostnameVerificationError(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090504";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHostnameVerificationErrorLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090504";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHostnameVerificationNoCertificateError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090505";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHostnameVerificationNoCertificateErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090505";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHostnameVerificationExceptionError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090506";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHostnameVerificationExceptionErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090506";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTrustValidationCertExceptionError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090507";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logTrustValidationCertExceptionErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090507";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHandshakeCertIncompleteError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090508";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHandshakeCertIncompleteErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090508";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLListenPortSameAsServerListenPort(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090509";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSSLListenPortSameAsServerListenPortLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090509";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoUsernameSpecified() {
        Object[] args = new Object[]{};
        String messageId = "090510";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoUsernameSpecifiedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090510";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logStackTrace(LoggerSpi logger, Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090511";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logStackTraceLoggable(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090511";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logAuditProviderFailedToRegisterOnMBean(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090512";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logAuditProviderFailedToRegisterOnMBeanLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090512";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDowngradingUntrustedServerIdentity(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090513";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDowngradingUntrustedServerIdentityLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090513";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainConstraints(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090514";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logCertificateChainConstraintsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090514";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainIncompleteConstraintsNotChecked(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090515";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logCertificateChainIncompleteConstraintsNotCheckedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090515";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLDAPPreviouslyInitialized(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090516";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logLDAPPreviouslyInitializedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090516";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoCircularGroupMembership(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090517";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoCircularGroupMembershipLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090517";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logBootPropertiesDecryptionFailure(LoggerSpi logger, String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090518";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logBootPropertiesDecryptionFailureLoggable(String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090518";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090519";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090519";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoAuthenticatorWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090520";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoAuthenticatorWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090520";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoRoleMapperWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090521";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoRoleMapperWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090521";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoDeployableRoleMapperWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090522";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoDeployableRoleMapperWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090522";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoDeployableRoleMapperEnabledWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090523";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoDeployableRoleMapperEnabledWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090523";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoAuthorizerWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090524";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoAuthorizerWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090524";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoDeployableAuthorizerWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090525";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoDeployableAuthorizerWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090525";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoDeployableAuthorizerEnabledWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090526";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoDeployableAuthorizerEnabledWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090526";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoCredentialMapperWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090527";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoCredentialMapperWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090527";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoDeployableCredentialMapperWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090528";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoDeployableCredentialMapperWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090528";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoDeployableCredentialMapperEnabledWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090529";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoDeployableCredentialMapperEnabledWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090529";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmMultipleIdentityAssertersForActiveTokenTypeWarning(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090530";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmMultipleIdentityAssertersForActiveTokenTypeWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090530";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoAdjudicatorWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090531";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoAdjudicatorWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090531";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmRealmAdapterNoRealmAdapterAuthorizerWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090532";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmRealmAdapterNoRealmAdapterAuthorizerWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090532";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmRealmAdapterNoDefaultAuthorizerWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090533";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmRealmAdapterNoDefaultAuthorizerWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090533";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmRealmAdapterMultipleDefaultAuthorizersWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090534";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmRealmAdapterMultipleDefaultAuthorizersWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090534";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmRealmAdapterUnsupportedAuthorizerWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090535";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmRealmAdapterUnsupportedAuthorizerWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090535";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmRealmAdapterMultipleRealmAdapterAuthorizersWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090536";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmRealmAdapterMultipleRealmAdapterAuthorizersWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090536";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmRealmAdapterMultipleRealmAdapterAuthenticatorsWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090537";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmRealmAdapterMultipleRealmAdapterAuthenticatorsWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090537";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmRealmAdapterNoRealmAdapterAuthenticatorWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090538";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmRealmAdapterNoRealmAdapterAuthenticatorWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090538";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmInvalidKeyStoreProviderWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090539";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmInvalidKeyStoreProviderWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090539";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmMultipleTrustedCAKeyStoresWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090540";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmMultipleTrustedCAKeyStoresWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090540";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmMultiplePrivateKeyStoresWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090541";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmMultiplePrivateKeyStoresWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090541";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFatClientHandshakeCertUntrustedError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090542";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logFatClientHandshakeCertUntrustedErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090542";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFatClientHandshakeCertIncompleteError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090543";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logFatClientHandshakeCertIncompleteErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090543";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoSearchFilterSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090544";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoSearchFilterSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090544";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefRoleMapImplSearchFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090545";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefRoleMapImplSearchFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090545";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logServerDemoCommandLineTrust(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090546";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logServerDemoCommandLineTrustLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090546";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainConstraintsStrictNonCriticalFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090547";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainConstraintsStrictNonCriticalFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090547";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainMissingConstraintsFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090548";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainMissingConstraintsFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090548";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainNotACaConstraintsFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090549";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainNotACaConstraintsFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090549";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainPathLenExceededConstraintsFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090550";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainPathLenExceededConstraintsFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090550";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainConstraintsConversionFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090551";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainConstraintsConversionFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090551";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCantCheckKeyMatch(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090552";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCantCheckKeyMatchLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090552";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInvalidPropertyValue(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090553";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logInvalidPropertyValueLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090553";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMustSetRealmClassName(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090554";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMustSetRealmClassNameLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090554";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultCredentialMapperGetCredentialsFailure(LoggerSpi logger, String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090555";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultCredentialMapperGetCredentialsFailureLoggable(String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090555";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultCredentialMapperDeployCredentialMappingFailure(LoggerSpi logger, String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090556";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultCredentialMapperDeployCredentialMappingFailureLoggable(String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090556";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultCredentialMapperApplicationDeletedFailure(LoggerSpi logger, String arg0, int arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, new Integer(arg1), arg2, arg3};
        String messageId = "090557";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultCredentialMapperApplicationDeletedFailureLoggable(String arg0, int arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, new Integer(arg1), arg2, arg3};
        String messageId = "090557";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultCredentialMapperApplicationDeployEndedFailure(LoggerSpi logger, String arg0, int arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, new Integer(arg1), arg2, arg3};
        String messageId = "090558";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultCredentialMapperApplicationDeployEndedFailureLoggable(String arg0, int arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, new Integer(arg1), arg2, arg3};
        String messageId = "090558";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDefaultCredentialMapperDecryptionFailure(LoggerSpi logger, String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090559";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDefaultCredentialMapperDecryptionFailureLoggable(String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090559";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotLoadClass(String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090560";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotLoadClassLoggable(String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090560";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotInstantiateClass(String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090561";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotInstantiateClassLoggable(String arg0, String arg1, String arg2, Throwable arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090561";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getClassNotAssignable(String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090562";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getClassNotAssignableLoggable(String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090562";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHostnameVerifierInitError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090563";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logHostnameVerifierInitErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090563";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHostnameVerifierInvalidError(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090564";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logHostnameVerifierInvalidErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090564";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnsupportedKeyAlgorithm(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090565";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logUnsupportedKeyAlgorithmLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090565";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainUnrecognizedExtensionFailure(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090566";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainUnrecognizedExtensionFailureLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090566";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainAlgKeyUsageFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090567";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainAlgKeyUsageFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090567";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainCheckKeyUsageFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090568";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainCheckKeyUsageFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090568";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificateChainCertSignKeyUsageFailure(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090569";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCertificateChainCertSignKeyUsageFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090569";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJACCPropButNoSecurityManager(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090570";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJACCPropButNoSecurityManagerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090570";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logJACCPolicyLoaded(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090571";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logJACCPolicyLoadedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090571";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logJACCPolicyProviderClassNotFound(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090572";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logJACCPolicyProviderClassNotFoundLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090572";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIllegalAccess(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090573";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logIllegalAccessLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090573";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInstantiationException(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090574";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logInstantiationExceptionLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090574";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNotAPolicyObject(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090575";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logNotAPolicyObjectLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090575";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logPolicyConfigurationFactoryProblem(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090576";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logPolicyConfigurationFactoryProblemLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090576";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logJACCPolicyConfigurationFactoryLoaded(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090577";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logJACCPolicyConfigurationFactoryLoadedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090577";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logPolicyContextException(LoggerSpi logger, Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090578";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logPolicyContextExceptionLoggable(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090578";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logJACCPolicyConfigurationFactoryProviderClassNotFound(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090579";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logJACCPolicyConfigurationFactoryProviderClassNotFoundLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090579";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathBuilderParametersIllegalRealm() {
        Object[] args = new Object[]{};
        String messageId = "090580";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathBuilderParametersIllegalRealmLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090580";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathBuilderParametersIllegalCertPathSelector() {
        Object[] args = new Object[]{};
        String messageId = "090581";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathBuilderParametersIllegalCertPathSelectorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090581";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathValidatorParametersIllegalRealm() {
        Object[] args = new Object[]{};
        String messageId = "090582";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathValidatorParametersIllegalRealmLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090582";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEndCertificateSelectorIllegalCertificate() {
        Object[] args = new Object[]{};
        String messageId = "090583";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEndCertificateSelectorIllegalCertificateLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090583";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIssuerDNSerialNumberSelectorIllegalIssuerDN() {
        Object[] args = new Object[]{};
        String messageId = "090584";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIssuerDNSerialNumberSelectorIllegalIssuerDNLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090584";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIssuerDNSerialNumberSelectorIllegalSerialNumber() {
        Object[] args = new Object[]{};
        String messageId = "090585";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIssuerDNSerialNumberSelectorIllegalSerialNumberLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090585";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSubjectDNSelectorIllegalSubjectDN() {
        Object[] args = new Object[]{};
        String messageId = "090586";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSubjectDNSelectorIllegalSubjectDNLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090586";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSubjectKeyIdentifierSelectorIllegalSubjectKeyIdentifier() {
        Object[] args = new Object[]{};
        String messageId = "090587";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSubjectKeyIdentifierSelectorIllegalSubjectKeyIdentifierLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090587";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLSCertPathBuilderResultIllegalCertPath() {
        Object[] args = new Object[]{};
        String messageId = "090588";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLSCertPathBuilderResultIllegalCertPathLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090588";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLSJDKCertPathBuilderIllegalCertPathParameters() {
        Object[] args = new Object[]{};
        String messageId = "090589";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLSJDKCertPathBuilderIllegalCertPathParametersLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090589";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLSJDKCertPathValidatorIllegalCertPathParameters() {
        Object[] args = new Object[]{};
        String messageId = "090590";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLSJDKCertPathValidatorIllegalCertPathParametersLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090590";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoCertPathProvidersWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090591";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoCertPathProvidersWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090591";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoCertPathBuilderWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090592";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoCertPathBuilderWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090592";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmIllegalCertPathBuilderWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090593";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmIllegalCertPathBuilderWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090593";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalCertPathBuilderParametersSpi(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090594";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalCertPathBuilderParametersSpiLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090594";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalCertPathValidatorParametersSpi(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090595";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalCertPathValidatorParametersSpiLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090595";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWebLogicCertPathProviderIllegalCertPathSelector() {
        Object[] args = new Object[]{};
        String messageId = "090596";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWebLogicCertPathProviderIllegalCertPathSelectorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090596";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateRegistryIllegalCertPathSelector() {
        Object[] args = new Object[]{};
        String messageId = "090597";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateRegistryIllegalCertPathSelectorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090597";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDomainControllerListUpdateFailed(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090598";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDomainControllerListUpdateFailedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090598";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDomainControllerListInitializationFailed(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090599";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDomainControllerListInitializationFailedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090599";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToRetrieveLocalMachineName() {
        Object[] args = new Object[]{};
        String messageId = "090600";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToRetrieveLocalMachineNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090600";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNotAbleToAccessDomainController(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090601";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logNotAbleToAccessDomainControllerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090601";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJavaNativeVersionMismatchDetected() {
        Object[] args = new Object[]{};
        String messageId = "090602";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJavaNativeVersionMismatchDetectedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090602";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPCannotCompleteChain(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090603";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPCannotCompleteChainLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090603";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPNoTrustedCA() {
        Object[] args = new Object[]{};
        String messageId = "090604";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPNoTrustedCALoggable() {
        Object[] args = new Object[]{};
        String messageId = "090604";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPCertNotCurrentlyValid(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090605";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPCertNotCurrentlyValidLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090605";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPDNMismatch(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090606";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPDNMismatchLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090606";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPEncodingError(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090607";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPEncodingErrorLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090607";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPInvalidKeyError(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090608";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPInvalidKeyErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090608";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPNoSuchAlgorithmError(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090609";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPNoSuchAlgorithmErrorLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090609";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPNoDefaultProviderError(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090610";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPNoDefaultProviderErrorLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090610";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPInvalidSignatureError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090611";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPInvalidSignatureErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090611";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPUnsupportedCriticalExtensionError(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090612";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPUnsupportedCriticalExtensionErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090612";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPBasicConstraintsViolatedError(String arg0, int arg1, int arg2) {
        Object[] args = new Object[]{arg0, new Integer(arg1), new Integer(arg2)};
        String messageId = "090613";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPBasicConstraintsViolatedErrorLoggable(String arg0, int arg1, int arg2) {
        Object[] args = new Object[]{arg0, new Integer(arg1), new Integer(arg2)};
        String messageId = "090613";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWLCPPMissingBasicConstraintsError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090614";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWLCPPMissingBasicConstraintsErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090614";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathManagerNullTrustedCAError() {
        Object[] args = new Object[]{};
        String messageId = "090615";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathManagerNullTrustedCAErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090615";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathBuilderProviderReturnedEmptyCertPathError() {
        Object[] args = new Object[]{};
        String messageId = "090616";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathBuilderProviderReturnedEmptyCertPathErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090616";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathBuilderProviderNonX509CertificateError() {
        Object[] args = new Object[]{};
        String messageId = "090617";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathBuilderProviderNonX509CertificateErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090617";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathValidatorEmptyCertPathError() {
        Object[] args = new Object[]{};
        String messageId = "090618";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathValidatorEmptyCertPathErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090618";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathValidatorNonX509CertificateError() {
        Object[] args = new Object[]{};
        String messageId = "090619";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathValidatorNonX509CertificateErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090619";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJDKCertPathBuilderNotFoundError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090620";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJDKCertPathBuilderNotFoundErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090620";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJDKCertPathValidatorNotFoundError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090621";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJDKCertPathValidatorNotFoundErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090621";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCreateProviderMBeanFailed(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090622";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCreateProviderMBeanFailedLoggable(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090622";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getGetDefaultTrustedCAsError(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090623";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getGetDefaultTrustedCAsErrorLoggable(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090623";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getX509CreateCertPathError(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090624";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getX509CreateCertPathErrorLoggable(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090624";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPolicyContextNotOpen(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090625";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPolicyContextNotOpenLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090625";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToDeletePolicyDirectory(Exception arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090626";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToDeletePolicyDirectoryLoggable(Exception arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090626";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotLinkPolicyConfigurationToSelf() {
        Object[] args = new Object[]{};
        String messageId = "090627";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotLinkPolicyConfigurationToSelfLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090627";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotHaveCircularPolicyConfigurationLinks() {
        Object[] args = new Object[]{};
        String messageId = "090628";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotHaveCircularPolicyConfigurationLinksLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090628";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getBadRoleToPrincipalMap(Exception arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090629";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getBadRoleToPrincipalMapLoggable(Exception arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090629";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToCreatePolicyWriter(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090630";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToCreatePolicyWriterLoggable(Exception arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090630";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToCreatePolicyWriterDirectory(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090631";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToCreatePolicyWriterDirectoryLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090631";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFileInTheWayOfDirectory(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090632";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFileInTheWayOfDirectoryLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090632";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotOpenPolicyFile(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090633";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotOpenPolicyFileLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090633";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotWriteToPolicyFile(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090634";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotWriteToPolicyFileLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090634";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefAuthImplNoSearchResults() {
        Object[] args = new Object[]{};
        String messageId = "090635";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefAuthImplNoSearchResultsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090635";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDefRoleMapImplNoSearchResults() {
        Object[] args = new Object[]{};
        String messageId = "090636";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDefRoleMapImplNoSearchResultsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090636";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoRoleNameSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090637";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoRoleNameSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090637";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoResourceData() {
        Object[] args = new Object[]{};
        String messageId = "090638";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoResourceDataLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090638";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoResourceType() {
        Object[] args = new Object[]{};
        String messageId = "090639";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoResourceTypeLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090639";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoResourceIdentifier() {
        Object[] args = new Object[]{};
        String messageId = "090640";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoResourceIdentifierLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090640";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoResourceKeysFound() {
        Object[] args = new Object[]{};
        String messageId = "090641";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoResourceKeysFoundLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090641";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidDataTypeForResourceKey(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090642";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidDataTypeForResourceKeyLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090642";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidResourceType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090643";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidResourceTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090643";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExpectedResourceType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090644";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExpectedResourceTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090644";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExpectedResourceKey(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090645";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExpectedResourceKeyLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090645";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownResourceKey(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090646";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownResourceKeyLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090646";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidApplicationName() {
        Object[] args = new Object[]{};
        String messageId = "090647";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidApplicationNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090647";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidComponentName() {
        Object[] args = new Object[]{};
        String messageId = "090648";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidComponentNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090648";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidApplicationSearchName() {
        Object[] args = new Object[]{};
        String messageId = "090649";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidApplicationSearchNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090649";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidComponentSearchName() {
        Object[] args = new Object[]{};
        String messageId = "090650";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidComponentSearchNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090650";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoComponentType() {
        Object[] args = new Object[]{};
        String messageId = "090651";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoComponentTypeLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090651";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidComponentType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090652";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidComponentTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090652";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEmptyArrayValueFound() {
        Object[] args = new Object[]{};
        String messageId = "090653";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEmptyArrayValueFoundLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090653";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnexpectedResourceIdData(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090654";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnexpectedResourceIdDataLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090654";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnexpectedResourceKeyArrayValue(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090655";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnexpectedResourceKeyArrayValueLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090655";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEmptyResourceKeyString(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090656";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEmptyResourceKeyStringLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090656";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEmptyResourceKeyArrayString(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090657";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEmptyResourceKeyArrayStringLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090657";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToConvertFiletoURL(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090658";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToConvertFiletoURLLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090658";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToDeleteOldPolicyFile(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090659";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToDeleteOldPolicyFileLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090659";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logHandshakeCertValidationError(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090660";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logHandshakeCertValidationErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090660";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFatClientHandshakeCertValidationError(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090661";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logFatClientHandshakeCertValidationErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090661";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDeprecatedDeployableAuthorizer(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090662";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logDeprecatedDeployableAuthorizerLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090662";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDeprecatedDeployableRoleMapper(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090663";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logDeprecatedDeployableRoleMapperLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090663";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownDeployableAuthorizer(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090664";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownDeployableAuthorizerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090664";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownDeployableRoleMapper(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090665";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownDeployableRoleMapperLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090665";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDeployHandleNotSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090666";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDeployHandleNotSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090666";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getApplicationInformationNotSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090667";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getApplicationInformationNotSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090667";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIgnoredDeployRole(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090668";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logIgnoredDeployRoleLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090668";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIgnoredDeployPolicy(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090669";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logIgnoredDeployPolicyLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090669";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToVerifyUsernameToken(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090670";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToVerifyUsernameTokenLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090670";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToGetDigest(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090671";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToGetDigestLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090671";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getTokenNotTypeUsername(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090672";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getTokenNotTypeUsernameLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090672";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDigestDataSourceNotFound(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090673";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logDigestDataSourceNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090673";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDigestDataSourceNotInitialized(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090674";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logDigestDataSourceNotInitializedLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090674";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDigestDataSourceNoConnection(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090675";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logDigestDataSourceNoConnectionLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090675";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDigestDataSourcePrepareError(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090676";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logDigestDataSourcePrepareErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090676";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDigestDataSourceCreateError(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090677";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logDigestDataSourceCreateErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090677";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDigestReplayDetectionFailed(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090678";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDigestReplayDetectionFailedLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090678";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDigestReplayAttackOccurred(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090679";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDigestReplayAttackOccurredLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090679";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToVerifyExpired(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090680";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToVerifyExpiredLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090680";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDigestAuthenticationDisabled(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090681";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDigestAuthenticationDisabledLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090681";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDeploymentValidationProblem(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090682";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDeploymentValidationProblemLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090682";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateRegistryBuildFailureUnregisteredCertificate(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090683";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateRegistryBuildFailureUnregisteredCertificateLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090683";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateRegistryBuildFailureUnregisteredSubjectDN(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090684";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateRegistryBuildFailureUnregisteredSubjectDNLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090684";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateRegistryBuildFailureUnregisteredIssuerDNAndSerialNumber(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090685";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateRegistryBuildFailureUnregisteredIssuerDNAndSerialNumberLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090685";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateRegistryBuildFailureUnregisteredSubjectKeyIdentifier(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090686";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateRegistryBuildFailureUnregisteredSubjectKeyIdentifierLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090686";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateRegistryValidateFailureUnregisteredCertificate(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090687";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateRegistryValidateFailureUnregisteredCertificateLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090687";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMaximumListersExceeded(int arg0, int arg1) {
        Object[] args = new Object[]{new Integer(arg0), new Integer(arg1)};
        String messageId = "090688";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMaximumListersExceededLoggable(int arg0, int arg1) {
        Object[] args = new Object[]{new Integer(arg0), new Integer(arg1)};
        String messageId = "090688";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEmptyOrNullCertificateAlias() {
        Object[] args = new Object[]{};
        String messageId = "090689";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEmptyOrNullCertificateAliasLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090689";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEmptyOrNullFileName() {
        Object[] args = new Object[]{};
        String messageId = "090690";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEmptyOrNullFileNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090690";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getEmptyOrNullCertificateAliasWildcard() {
        Object[] args = new Object[]{};
        String messageId = "090691";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getEmptyOrNullCertificateAliasWildcardLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090691";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getMaximumToReturnCanNotBeLessThanZero() {
        Object[] args = new Object[]{};
        String messageId = "090692";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMaximumToReturnCanNotBeLessThanZeroLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090692";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateAliasNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090693";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateAliasNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090693";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateAliasAlreadyExists(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090694";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateAliasAlreadyExistsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090694";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSubjectDNAlreadyExists(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090695";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSubjectDNAlreadyExistsLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090695";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getIssuerDNAndSerialNumberAlreadyExists(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090696";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIssuerDNAndSerialNumberAlreadyExistsLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090696";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSubjectKeyIdentifierAlreadyExists(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090697";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSubjectKeyIdentifierAlreadyExistsLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090697";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getImportErrors() {
        Object[] args = new Object[]{};
        String messageId = "090698";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getImportErrorsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090698";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExportErrors() {
        Object[] args = new Object[]{};
        String messageId = "090699";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExportErrorsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090699";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logJACCRoleMapperFactoryProviderClassNotFound(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090700";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logJACCRoleMapperFactoryProviderClassNotFoundLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090700";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRoleMapperFactoryProblem(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090701";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logRoleMapperFactoryProblemLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090701";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJACCSecurityEnabledButNoSecurityManager() {
        Object[] args = new Object[]{};
        String messageId = "090702";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJACCSecurityEnabledButNoSecurityManagerLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090702";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJACCWebLogicClassesMustMatch() {
        Object[] args = new Object[]{};
        String messageId = "090705";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJACCWebLogicClassesMustMatchLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090705";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logJACCRoleMapperFactoryLoaded(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090707";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logJACCRoleMapperFactoryLoadedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090707";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInconsistentSecurityConfiguration() {
        Object[] args = new Object[]{};
        String messageId = "090709";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInconsistentSecurityConfigurationLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090709";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToWriteFileError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090710";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToWriteFileErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090710";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToReadFileError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090711";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToReadFileErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090711";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToReadJKSKeyStoreError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090712";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToReadJKSKeyStoreErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090712";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToReadCertificateFromPEMorDERError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090713";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToReadCertificateFromPEMorDERErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090713";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLCertPathNotValidated(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090714";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logSSLCertPathNotValidatedLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090714";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailedReadingIdentityEntry(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090716";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logFailedReadingIdentityEntryLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090716";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInvalidServerSSLConfiguration(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090717";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "alert", loggable);
    }

    public static LoggableMessageSpi logInvalidServerSSLConfigurationLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090717";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInitializingUsingJavaSecurityManager(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090718";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logInitializingUsingJavaSecurityManagerLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090718";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInitializingUsingJACC(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090719";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logInitializingUsingJACCLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090719";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNodeManagerPropertiesNotFound(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090720";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logNodeManagerPropertiesNotFoundLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090720";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logNodeManagerPropertiesError(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090721";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logNodeManagerPropertiesErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090721";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoProviderChallengeContext(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090722";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoProviderChallengeContextLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090722";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullChallengeContextParam() {
        Object[] args = new Object[]{};
        String messageId = "090723";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullChallengeContextParamLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090723";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getChallengeNotCompleted() {
        Object[] args = new Object[]{};
        String messageId = "090724";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getChallengeNotCompletedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090724";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getChallengeHasCompleted() {
        Object[] args = new Object[]{};
        String messageId = "090725";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getChallengeHasCompletedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090725";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCredMapperUnexpectedException(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090726";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logCredMapperUnexpectedExceptionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090726";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailedToModifyCredential(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090727";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logFailedToModifyCredentialLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090727";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailedToReadCredential(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090728";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logFailedToReadCredentialLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090728";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailedToSearchCredentials(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090729";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logFailedToSearchCredentialsLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090729";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToVerifyCredMapperLDAPHierarchy(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090730";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToVerifyCredMapperLDAPHierarchyLoggable(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090730";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToRetrieveQuery() {
        Object[] args = new Object[]{};
        String messageId = "090731";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToRetrieveQueryLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090731";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidDataSourceName(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090732";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidDataSourceNameLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090732";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToFindDataSource(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090733";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToFindDataSourceLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090733";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSConnectionPoolNotUsable() {
        Object[] args = new Object[]{};
        String messageId = "090734";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSConnectionPoolNotUsableLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090734";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSConnectionNotUsable() {
        Object[] args = new Object[]{};
        String messageId = "090735";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSConnectionNotUsableLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090735";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSConfigurationValidationException(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090736";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSConfigurationValidationExceptionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090736";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSConfigurationValidationConnectionException() {
        Object[] args = new Object[]{};
        String messageId = "090737";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSConfigurationValidationConnectionExceptionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090737";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getHashAlgorithmNotUsable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090738";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getHashAlgorithmNotUsableLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090738";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSQLValidationFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090739";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSQLValidationFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090739";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginException(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090740";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginExceptionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090740";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginSQLException(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090741";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginSQLExceptionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090741";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginFailedToLoad() {
        Object[] args = new Object[]{};
        String messageId = "090742";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginFailedToLoadLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090742";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginLoadException(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090743";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginLoadExceptionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090743";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginLoadClassNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090744";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginLoadClassNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090744";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginLoadBadClass(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090745";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginLoadBadClassLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090745";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginLoadIllegalAccessClass(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090746";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginLoadIllegalAccessClassLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090746";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPluginInstantiateClass(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090747";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPluginInstantiateClassLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090747";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSConnectionCloseFailed() {
        Object[] args = new Object[]{};
        String messageId = "090748";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSConnectionCloseFailedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090748";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownAlgorithmForPasswordHash() {
        Object[] args = new Object[]{};
        String messageId = "090749";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownAlgorithmForPasswordHashLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090749";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownErrorConvertingPassword() {
        Object[] args = new Object[]{};
        String messageId = "090750";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownErrorConvertingPasswordLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090750";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSFailedToRetrievePreparedStatement(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090751";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSFailedToRetrievePreparedStatementLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090751";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSUnknownPasswordType() {
        Object[] args = new Object[]{};
        String messageId = "090752";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSUnknownPasswordTypeLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090752";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getHashAlgorithmNotFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090753";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getHashAlgorithmNotFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090753";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSLoginModuleNotInitialized() {
        Object[] args = new Object[]{};
        String messageId = "090754";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSLoginModuleNotInitializedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090754";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSConnectionNotAvailableFromPool() {
        Object[] args = new Object[]{};
        String messageId = "090755";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSConnectionNotAvailableFromPoolLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090755";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSUnableToQueryInformation(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090756";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSUnableToQueryInformationLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090756";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSExceptionFormattingUser() {
        Object[] args = new Object[]{};
        String messageId = "090757";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSExceptionFormattingUserLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090757";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSExceptionFormattingGroups() {
        Object[] args = new Object[]{};
        String messageId = "090758";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSExceptionFormattingGroupsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090758";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSSQLException(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090759";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSSQLExceptionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090759";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSUserNotUnique(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090760";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSUserNotUniqueLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090760";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSAuthenticationFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090761";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSAuthenticationFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090761";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSLoginModuleException() {
        Object[] args = new Object[]{};
        String messageId = "090762";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSLoginModuleExceptionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090762";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logApplicationVersioningWarning(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090763";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logApplicationVersioningWarningLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090763";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logVersionableApplicationProviderError(LoggerSpi logger, String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090764";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logVersionableApplicationProviderErrorLoggable(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090764";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAppVersionCreatePolicyError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090765";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAppVersionCreatePolicyErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090765";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAppVersionCreateRoleError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090766";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAppVersionCreateRoleErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090766";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAppVersionCreateCredMapError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090767";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAppVersionCreateCredMapErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090767";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCredMapRemovalError() {
        Object[] args = new Object[]{};
        String messageId = "090768";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCredMapRemovalErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090768";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logTokenGroupsAttributeNotAccessable(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090769";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logTokenGroupsAttributeNotAccessableLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090769";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getServletAuthenticationFilterNotImplemented(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090770";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getServletAuthenticationFilterNotImplementedLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090770";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logInsufficientActiveTypesForNegotiation(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090771";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logInsufficientActiveTypesForNegotiationLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090771";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getAppVersioningNotSupported(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090772";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAppVersioningNotSupportedLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090772";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getVersionCreateFailure(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090773";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getVersionCreateFailureLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090773";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getArgumentNotEncrypted() {
        Object[] args = new Object[]{};
        String messageId = "090774";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getArgumentNotEncryptedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090774";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnableToGenerateSignedSAMLAssertions(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090775";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "notice", loggable);
    }

    public static LoggableMessageSpi logUnableToGenerateSignedSAMLAssertionsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090775";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnableToGenerateSAMLAssertion(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090776";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logUnableToGenerateSAMLAssertionLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090776";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logUnableToGenerateSignedSAMLAssertion(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090777";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logUnableToGenerateSignedSAMLAssertionLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090777";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToSignNoPrivateKey() {
        Object[] args = new Object[]{};
        String messageId = "090778";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToSignNoPrivateKeyLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090778";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDowngradingUntrustedIdentity(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090779";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logDowngradingUntrustedIdentityLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090779";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logWebAppFilesCaseMismatch(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090780";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logWebAppFilesCaseMismatchLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090780";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnexpectedCallbackFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090781";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnexpectedCallbackFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090781";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logErrorProductionModeNoEcho(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090782";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logErrorProductionModeNoEchoLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090782";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logErrorDevModeNoEcho(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090783";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logErrorDevModeNoEchoLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090783";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logDuplicateMembershipDetected(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090784";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logDuplicateMembershipDetectedLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090784";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoIdentityOrContinuation() {
        Object[] args = new Object[]{};
        String messageId = "090785";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoIdentityOrContinuationLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090785";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnexpectedTokenFormatError() {
        Object[] args = new Object[]{};
        String messageId = "090786";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnexpectedTokenFormatErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090786";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullDataSourceName() {
        Object[] args = new Object[]{};
        String messageId = "090787";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullDataSourceNameLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090787";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToLocateDataSourceConfig(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090788";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToLocateDataSourceConfigLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090788";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSUnexpectedAuthenticationException() {
        Object[] args = new Object[]{};
        String messageId = "090789";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSUnexpectedAuthenticationExceptionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090789";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSBinaryResultTypeNotAllowed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090790";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSBinaryResultTypeNotAllowedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090790";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSNotExpectedResultType(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090791";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSNotExpectedResultTypeLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090791";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSParameterNotExpectedCharType(int arg0, String arg1) {
        Object[] args = new Object[]{new Integer(arg0), arg1};
        String messageId = "090792";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSParameterNotExpectedCharTypeLoggable(int arg0, String arg1) {
        Object[] args = new Object[]{new Integer(arg0), arg1};
        String messageId = "090792";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnableToAcceptKrbSecContext() {
        Object[] args = new Object[]{};
        String messageId = "090793";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnableToAcceptKrbSecContextLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090793";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSNoHashAlgorithmSpecified() {
        Object[] args = new Object[]{};
        String messageId = "090794";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSNoHashAlgorithmSpecifiedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090794";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSNoResultColumnFound(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090795";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSNoResultColumnFoundLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090795";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSNumberOfParametersNotCorrect(int arg0, int arg1, String arg2) {
        Object[] args = new Object[]{new Integer(arg0), new Integer(arg1), arg2};
        String messageId = "090796";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSNumberOfParametersNotCorrectLoggable(int arg0, int arg1, String arg2) {
        Object[] args = new Object[]{new Integer(arg0), new Integer(arg1), arg2};
        String messageId = "090796";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSPlaintextPasswordUsageRejected() {
        Object[] args = new Object[]{};
        String messageId = "090797";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSPlaintextPasswordUsageRejectedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090797";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getDBMSInvalidCharacterInput(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090798";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDBMSInvalidCharacterInputLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090798";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPKICredMapperInitFailed(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090799";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPKICredMapperInitFailedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090799";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getValueNotFound(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090800";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getValueNotFoundLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090800";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getValueNotFoundResource(String arg0, String arg1, boolean arg2, String arg3, String arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        String messageId = "090801";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getValueNotFoundResourceLoggable(String arg0, String arg1, boolean arg2, String arg3, String arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        String messageId = "090801";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSetKeyPairMap() {
        Object[] args = new Object[]{};
        String messageId = "090802";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSetKeyPairMapLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090802";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSetPublicCertMap() {
        Object[] args = new Object[]{};
        String messageId = "090803";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSetPublicCertMapLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090803";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRemoveCredential(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090804";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logRemoveCredentialLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090804";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailedToReadCredentialResource(LoggerSpi logger, String arg0, String arg1, boolean arg2, String arg3, String arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        String messageId = "090805";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logFailedToReadCredentialResourceLoggable(String arg0, String arg1, boolean arg2, String arg3, String arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        String messageId = "090805";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getWrongKeyStoreConfiguration(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090806";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getWrongKeyStoreConfigurationLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090806";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getKeyStoreConfigurationIncorrect(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090807";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getKeyStoreConfigurationIncorrectLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090807";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getKSAliasNotPresent(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090808";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getKSAliasNotPresentLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090808";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getKeyPairNotRetrieved(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090809";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getKeyPairNotRetrievedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090809";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getKSAliasNotCerEntry(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090810";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getKSAliasNotCerEntryLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090810";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPKICredentialNotRetrieved() {
        Object[] args = new Object[]{};
        String messageId = "090811";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPKICredentialNotRetrievedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090811";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadKeyStoreException(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090812";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logLoadKeyStoreExceptionLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090812";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoSuchResourceMapsCursorResourceID() {
        Object[] args = new Object[]{};
        String messageId = "090813";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoSuchResourceMapsCursorResourceIDLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090813";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logShutdownSecurityRealm(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090814";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logShutdownSecurityRealmLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090814";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPKIKeystorePasswordNotCorrect() {
        Object[] args = new Object[]{};
        String messageId = "090815";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPKIKeystorePasswordNotCorrectLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090815";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logErrorCreatingSecurityConfigurationRuntime(LoggerSpi logger, Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090816";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logErrorCreatingSecurityConfigurationRuntimeLoggable(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090816";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotActivateChangesNoDefaultRealmError() {
        Object[] args = new Object[]{};
        String messageId = "090817";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotActivateChangesNoDefaultRealmErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090817";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCannotActivateChangesImproperlyConfiguredDefaultRealmError() {
        Object[] args = new Object[]{};
        String messageId = "090818";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCannotActivateChangesImproperlyConfiguredDefaultRealmErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090818";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJACCPropertyNotSet(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090819";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJACCPropertyNotSetLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090819";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnexpectedNullVariable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090820";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnexpectedNullVariableLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090820";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathBuilderProviderUnorderedCertPathError(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090821";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathBuilderProviderUnorderedCertPathErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090821";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getCertPathValidatorUnorderedCertPathError(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090822";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertPathValidatorUnorderedCertPathErrorLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090822";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCouldNotRegisterWLSX509CertificateFactoryAsDefaultFactory(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090823";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "critical", loggable);
    }

    public static LoggableMessageSpi logCouldNotRegisterWLSX509CertificateFactoryAsDefaultFactoryLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090823";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCouldNotGenerateSAMLAssertion(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090824";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logCouldNotGenerateSAMLAssertionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090824";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCouldNotImportCertificateAsAliasNameExistsAsKeyEntry(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090825";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCouldNotImportCertificateAsAliasNameExistsAsKeyEntryLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090825";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCouldNotImportCertificateAsAliasNameExistsAsCertificateEntry(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090826";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logCouldNotImportCertificateAsAliasNameExistsAsCertificateEntryLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090826";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLDIFEmptyForCredentialProvider(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090827";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logLDIFEmptyForCredentialProviderLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090827";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getLDAPX509IATokenTypeCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090828";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getLDAPX509IATokenTypeCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090828";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getLDAPX509IATokenCanNotBeNull() {
        Object[] args = new Object[]{};
        String messageId = "090829";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getLDAPX509IATokenCanNotBeNullLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090829";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getLDAPX509IATokenTypeInCorrect(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090830";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getLDAPX509IATokenTypeInCorrectLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090830";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getLDAPX509UnrecognizedIACallback() {
        Object[] args = new Object[]{};
        String messageId = "090831";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getLDAPX509UnrecognizedIACallbackLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090831";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoMatchingCertificatesinDLAPDirectory() {
        Object[] args = new Object[]{};
        String messageId = "090832";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoMatchingCertificatesinDLAPDirectoryLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090832";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoCertificatesinDLAPDirectory() {
        Object[] args = new Object[]{};
        String messageId = "090833";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoCertificatesinDLAPDirectoryLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090833";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNoLDAPConnection() {
        Object[] args = new Object[]{};
        String messageId = "090834";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNoLDAPConnectionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090834";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getReqParamNotSuppliedPKIMappingManagementOps() {
        Object[] args = new Object[]{};
        String messageId = "090835";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getReqParamNotSuppliedPKIMappingManagementOpsLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090835";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logPKIProviderKeyStoreDoesntExist(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090836";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logPKIProviderKeyStoreDoesntExistLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090836";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getPKIKeystoreLocationNullOrEmpty() {
        Object[] args = new Object[]{};
        String messageId = "090837";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getPKIKeystoreLocationNullOrEmptyLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090837";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getJACCWebLogicRoleMapperFactoryNotSupplied() {
        Object[] args = new Object[]{};
        String messageId = "090838";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getJACCWebLogicRoleMapperFactoryNotSuppliedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090838";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logExceptionRegisteringSAMLService(LoggerSpi logger, String arg0, String arg1, Throwable arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090839";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logExceptionRegisteringSAMLServiceLoggable(String arg0, String arg1, Throwable arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090839";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRegisteredSAMLService(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090840";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logRegisteredSAMLServiceLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090840";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLServletThrowable(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090841";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLServletThrowableLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090841";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLAuthFilterThrowable(LoggerSpi logger, Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090842";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLAuthFilterThrowableLoggable(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090842";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderNullArg(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090843";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderNullArgLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090843";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderBadParamContext(LoggerSpi logger, String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090844";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderBadParamContextLoggable(String arg0, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        String messageId = "090844";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderMissingParamContext(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090845";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderMissingParamContextLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090845";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderBadParam(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090846";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderBadParamLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090846";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderMissingParam(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090847";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderMissingParamLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090847";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderInitException(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090848";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderInitExceptionLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090848";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderInitXMLFail(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090849";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderInitXMLFailLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090849";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderNoKeyManager(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090850";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderNoKeyManagerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090850";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderInitialized(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090851";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "info", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderInitializedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090851";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderNoTrustManager(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090852";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderNoTrustManagerLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090852";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLAssertionCacheInitFail(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090853";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLAssertionCacheInitFailLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090853";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderNoCredentials(LoggerSpi logger, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090854";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderNoCredentialsLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090854";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLAssertionStoreInitFail(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090855";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLAssertionStoreInitFailLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090855";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderBadUpdate(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090856";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderBadUpdateLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090856";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLProviderUpdateListenerFail(LoggerSpi logger, String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090857";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLProviderUpdateListenerFailLoggable(String arg0, Throwable arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090857";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLMultipleARUs(LoggerSpi logger, String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090858";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLMultipleARUsLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "090858";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoCertPathValidatorWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090859";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoCertPathValidatorWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090859";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logXACMLFunctionIdentifierNotDefined(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090860";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logXACMLFunctionIdentifierNotDefinedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090860";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logCertificatePolicyIdDoesntExistIntheList(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090861";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logCertificatePolicyIdDoesntExistIntheListLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090861";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logPolicyQualifierIdNotCPS(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090862";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logPolicyQualifierIdNotCPSLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090862";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSAMLCredentialMapperCacheException(LoggerSpi logger, Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090863";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logSAMLCredentialMapperCacheExceptionLoggable(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090863";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logFailureDOMToStringTransform(LoggerSpi logger, Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090864";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logFailureDOMToStringTransformLoggable(Throwable arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090864";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmNoMBeanDelegationWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090865";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmNoMBeanDelegationWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090865";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logIgnoredUncheckedPolicy(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090866";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logIgnoredUncheckedPolicyLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090866";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getSAMLPartySearchFilterNoResult(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090867";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getSAMLPartySearchFilterNoResultLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090867";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRealmSAMLConfigWarning(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090868";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRealmSAMLConfigWarningLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090868";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logPolicyConsumerProviderError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090869";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logPolicyConsumerProviderErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090869";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logLoadRealmFailed(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090870";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logLoadRealmFailedLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090870";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logRoleConsumerProviderError(LoggerSpi logger, String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090871";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logRoleConsumerProviderErrorLoggable(String arg0, Exception arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090871";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getServiceNotFound(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090872";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getServiceNotFoundLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090872";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNotInstanceof(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090873";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNotInstanceofLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090873";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullObjectReturned(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090874";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullObjectReturnedLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090874";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getNullParameterSupplied(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090875";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNullParameterSuppliedLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090875";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getConsumerNotConfigured(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090876";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getConsumerNotConfiguredLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090876";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getExceptionObtainingService(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090877";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getExceptionObtainingServiceLoggable(String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        String messageId = "090877";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getUnknownTokenType(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090878";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getUnknownTokenTypeLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090878";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logWarningCertificateAlreadyExists(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090879";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logWarningCertificateAlreadyExistsLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "090879";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logWarningFailedToLoadJAASConfiguration(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090880";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logWarningFailedToLoadJAASConfigurationLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090880";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static String getManagementOperationUnsupported() {
        Object[] args = new Object[]{};
        String messageId = "090881";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getManagementOperationUnsupportedLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090881";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    public static void logSSLUsingNullCipher(LoggerSpi logger) {
        Object[] args = new Object[]{};
        String messageId = "090882";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
        SecurityLogger.logMessage(logger, "warning", loggable);
    }

    public static LoggableMessageSpi logSSLUsingNullCipherLoggable() {
        Object[] args = new Object[]{};
        String messageId = "090882";
        return new LoggableMessageSpiImpl(messageId, SecurityLogger.formatMessage(SecurityLogger.getMessageBody(messageId), args));
    }

    private static class LoggableMessageSpiImpl
    implements LoggableMessageSpi {
        private String messageId = null;
        private String formattedMessageBody = null;

        LoggableMessageSpiImpl(String messageId, String formattedMessageBody) {
            this.messageId = messageId;
            this.formattedMessageBody = formattedMessageBody;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getPrefix() {
            return SecurityLogger.PROPERTIES_PREFIX;
        }

        public String getSubsystem() {
            return SecurityLogger.PROPERTIES_SUBSYSTEM;
        }

        public String getFormattedMessageBody() {
            return this.formattedMessageBody;
        }

        public String toString() {
            return SecurityLogger.PREFIX_PRE + this.messageId + SecurityLogger.PREFIX_POST + this.formattedMessageBody;
        }
    }
}

