/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationIdUtil {
    private ApplicationIdUtil() {
    }

    static String encode(String value) {
        if (value == null || value.equals("")) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(value, ",=", true);
        StringBuffer result = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.charAt(0) == ',' || token.charAt(0) == '=') {
                result.append('\\');
            }
            result.append(token);
        }
        return result.toString();
    }

    static Map<String, String> parse(String binding) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringTokenizer st = new StringTokenizer(binding, ",");
        StringBuffer component = new StringBuffer();
        boolean isAppend = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (isAppend) {
                component.append(token);
                isAppend = false;
            } else if (component.length() > 0) {
                component.replace(0, component.length() - 1, token);
            } else {
                component.append(token);
            }
            if (token.charAt(token.length() - 1) == '\\' && st.hasMoreTokens()) {
                isAppend = true;
                continue;
            }
            ApplicationIdUtil.parseNameValue(result, component.toString());
        }
        return result;
    }

    private static void parseNameValue(Map<String, String> result, String component) {
        int ei;
        int ci;
        StringBuffer value;
        StringBuffer name;
        block12: {
            int tidx;
            name = null;
            value = null;
            int idx = 0;
            while ((tidx = component.indexOf(61, idx)) > 0) {
                if (component.charAt(tidx - 1) == '\\') {
                    idx = tidx + 1;
                    continue;
                }
                name = new StringBuffer(component.substring(0, tidx));
                if (tidx + 1 < component.length()) {
                    value = new StringBuffer(component.substring(tidx + 1));
                }
                break block12;
            }
            if (tidx == 0) {
                if (component.length() > 1) {
                    value = new StringBuffer(component.substring(1));
                }
            } else {
                name = new StringBuffer(component);
            }
        }
        if (name != null) {
            ci = 0;
            while ((ci = name.indexOf("\\,", ci)) >= 0) {
                name.replace(ci, ci + 1, ",");
                ++ci;
            }
            ei = 0;
            while ((ei = name.indexOf("\\=", ei)) >= 0) {
                name.replace(ei, ei + 1, ",");
                ++ei;
            }
        }
        if (value != null) {
            ci = 0;
            while ((ci = value.indexOf("\\,", ci)) >= 0) {
                value.replace(ci, ci + 1, ",");
                ++ci;
            }
            ei = 0;
            while ((ei = value.indexOf("\\=", ei)) >= 0) {
                value.replace(ei, ei + 1, ",");
                ++ei;
            }
        }
        result.put(name != null ? name.toString() : null, value != null ? value.toString() : null);
    }
}

