/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import com.bea.common.security.store.data.ApplicationIdUtil;
import com.bea.common.security.store.data.DomainRealmScope;
import com.bea.common.security.store.data.TopId;
import com.bea.common.security.utils.Pair;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomainRealmScopeId
extends TopId {
    public static final String DOMAIN = "domain";
    public static final String REALM = "realm";
    private String domainName;
    private String realmName;

    public DomainRealmScopeId() {
    }

    public DomainRealmScopeId(String domainName, String realmName) {
        this.domainName = domainName;
        this.realmName = realmName;
    }

    public DomainRealmScopeId(String binding) {
        super(binding);
        Map<String, String> p = ApplicationIdUtil.parse(binding);
        this.domainName = p.get(DOMAIN);
        this.realmName = p.get(REALM);
    }

    public DomainRealmScopeId(DomainRealmScope obj) {
        super(obj);
        this.domainName = obj.getDomainName();
        this.realmName = obj.getRealmName();
    }

    @Override
    protected Pair<String, Map<String, Object>> prepareQuery() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("domainName", this.domainName);
        params.put("realmName", this.realmName);
        return new Pair((Object)"this.domainName == domainName && this.realmName == realmName", params);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DomainRealmScopeId)) {
            return false;
        }
        DomainRealmScopeId o = (DomainRealmScopeId)other;
        return this.domainName == o.domainName || this.domainName != null && this.domainName.equals(o.domainName) && this.realmName == o.realmName || this.realmName != null && this.realmName.equals(o.realmName);
    }

    @Override
    public int hashCode() {
        return (this.domainName != null ? this.domainName.hashCode() : 0) ^ (this.realmName != null ? this.realmName.hashCode() : 0);
    }

    @Override
    public String toString() {
        return new StringBuffer().append("realm=").append(ApplicationIdUtil.encode(this.realmName)).append(',').append(DOMAIN).append('=').append(ApplicationIdUtil.encode(this.domainName)).toString();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

