/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import com.bea.common.security.store.data.ApplicationIdUtil;
import com.bea.common.security.store.data.PKIResourceMap;
import com.bea.common.security.store.data.PKITypeScopeId;
import com.bea.common.security.utils.Pair;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIResourceMapId
extends PKITypeScopeId {
    public static final String CN = "cn";
    public String cn;

    public PKIResourceMapId() {
    }

    public PKIResourceMapId(String binding) {
        super(binding);
        Map<String, String> p = ApplicationIdUtil.parse(binding);
        this.cn = p.get(CN);
    }

    public PKIResourceMapId(String domainName, String realmName, String typeName, String cn) {
        super(domainName, realmName, typeName);
        this.cn = cn;
    }

    public PKIResourceMapId(PKIResourceMap obj) {
        super(obj);
        this.cn = obj.getCn();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("cn=").append(ApplicationIdUtil.encode(this.cn)).append(',').append(super.toString()).toString();
    }

    @Override
    protected Pair<String, Map<String, Object>> prepareQuery() {
        Pair<String, Map<String, Object>> p = super.prepareQuery();
        Map params = (Map)p.getRight();
        params.put(CN, this.cn);
        StringBuffer filter = new StringBuffer();
        filter.append((String)p.getLeft());
        filter.append(" && this.cn == cn");
        return new Pair((Object)filter.toString(), (Object)params);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof PKIResourceMapId)) {
            return false;
        }
        PKIResourceMapId o = (PKIResourceMapId)other;
        return this.cn == o.cn || this.cn != null && this.cn.equals(o.cn);
    }

    @Override
    public int hashCode() {
        return (this.cn != null ? this.cn.hashCode() : 0) ^ super.hashCode();
    }

    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }
}

