/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import com.bea.common.security.store.data.ApplicationIdUtil;
import com.bea.common.security.store.data.DomainRealmScopeId;
import com.bea.common.security.store.data.RegistryScope;
import com.bea.common.security.utils.Pair;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistryScopeId
extends DomainRealmScopeId {
    public static final String REGISTRYNAME = "registryName";
    private String registryName;

    public RegistryScopeId() {
    }

    public RegistryScopeId(String domainName, String realmName, String registryName) {
        super(domainName, realmName);
        this.registryName = registryName;
    }

    public RegistryScopeId(String binding) {
        super(binding);
        Map<String, String> p = ApplicationIdUtil.parse(binding);
        this.registryName = p.get(REGISTRYNAME);
    }

    public RegistryScopeId(RegistryScope obj) {
        super(obj);
        this.registryName = obj.getRegistryName();
    }

    @Override
    protected Pair<String, Map<String, Object>> prepareQuery() {
        Pair<String, Map<String, Object>> p = super.prepareQuery();
        Map params = (Map)p.getRight();
        params.put(REGISTRYNAME, this.registryName);
        StringBuffer filter = new StringBuffer();
        filter.append((String)p.getLeft());
        filter.append(" && this.registryName == registryName");
        return new Pair((Object)filter.toString(), (Object)params);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof RegistryScopeId)) {
            return false;
        }
        RegistryScopeId o = (RegistryScopeId)other;
        return this.registryName == o.registryName || this.registryName != null && this.registryName.equals(o.registryName);
    }

    @Override
    public int hashCode() {
        return (this.registryName != null ? this.registryName.hashCode() : 0) ^ super.hashCode();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("registryName=").append(ApplicationIdUtil.encode(this.registryName)).append(',').append(super.toString()).toString();
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }
}

