/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import com.bea.common.security.store.data.ApplicationIdUtil;
import com.bea.common.security.store.data.XACMLEntry;
import com.bea.common.security.store.data.XACMLTypeScopeId;
import com.bea.common.security.utils.Pair;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XACMLEntryId
extends XACMLTypeScopeId {
    public static final String CN = "cn";
    public static final String XACMLVERSION = "xacmlVersion";
    private String cn;
    private String xacmlVersion;

    public XACMLEntryId() {
    }

    public XACMLEntryId(String domainName, String realmName, String typeName, String cn, String xacmlVersion) {
        super(domainName, realmName, typeName);
        this.cn = cn;
        this.xacmlVersion = xacmlVersion;
    }

    public XACMLEntryId(String binding) {
        super(binding);
        Map<String, String> p = ApplicationIdUtil.parse(binding);
        this.cn = p.get(CN);
        this.xacmlVersion = p.get(XACMLVERSION);
    }

    public XACMLEntryId(XACMLEntry obj) {
        super(obj);
        this.cn = obj.getCn();
        this.xacmlVersion = obj.getXacmlVersion();
    }

    @Override
    protected Pair<String, Map<String, Object>> prepareQuery() {
        Pair<String, Map<String, Object>> p = super.prepareQuery();
        Map params = (Map)p.getRight();
        params.put(CN, this.cn);
        params.put(XACMLVERSION, this.xacmlVersion);
        StringBuffer filter = new StringBuffer();
        filter.append((String)p.getLeft());
        filter.append(" && this.cn == cn && this.xacmlVersion == xacmlVersion");
        return new Pair((Object)filter.toString(), (Object)params);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof XACMLEntryId)) {
            return false;
        }
        XACMLEntryId o = (XACMLEntryId)other;
        return this.cn == o.cn || this.cn != null && this.cn.equals(o.cn) && this.xacmlVersion == o.xacmlVersion || this.xacmlVersion != null && this.xacmlVersion.equals(o.xacmlVersion);
    }

    @Override
    public int hashCode() {
        return (this.cn != null ? this.cn.hashCode() : 0) ^ (this.xacmlVersion != null ? this.xacmlVersion.hashCode() : 0) ^ super.hashCode();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("cn=").append(ApplicationIdUtil.encode(this.cn)).append(',').append(XACMLVERSION).append('=').append(ApplicationIdUtil.encode(this.xacmlVersion)).append(',').append(super.toString()).toString();
    }

    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getXacmlVersion() {
        return this.xacmlVersion;
    }

    public void setXacmlVersion(String xacmlVersion) {
        this.xacmlVersion = xacmlVersion;
    }
}

