/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Bag<E extends AttributeValue>
implements Collection<E> {
    private int hash = 0;
    private URI dataType;
    private Type type;

    protected Bag() {
    }

    public Bag(URI dataType) {
        this.dataType = dataType;
    }

    public Bag(Type type) {
        this.type = type;
    }

    public URI getDataType() throws URISyntaxException {
        if (this.dataType == null) {
            this.dataType = this.type.getDataType();
        }
        return this.dataType;
    }

    public Type getType() throws URISyntaxException {
        if (this.type == null) {
            this.type = Type.findType(this.getDataType().toString());
        }
        return this.type;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.internalHashCode();
        }
        return this.hash;
    }

    public boolean isBag() {
        return true;
    }

    @Override
    public abstract boolean equals(Object var1);

    public abstract int internalHashCode();

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        switch (this.size()) {
            case 0: {
                return "<empty>";
            }
            case 1: {
                return ((AttributeValue)this.iterator().next()).toString();
            }
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            s.append(it.next());
            if (!it.hasNext()) continue;
            s.append(',');
        }
        s.append(']');
        return s.toString();
    }
}

