/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BooleanAttribute
extends AttributeValue<BooleanAttribute> {
    public static final BooleanAttribute TRUE = new BooleanAttribute(true);
    public static final BooleanAttribute FALSE = new BooleanAttribute(false);
    private boolean value;

    public BooleanAttribute(boolean value) {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.BOOLEAN;
    }

    public BooleanAttribute(Boolean value) {
        this((boolean)value);
    }

    public BooleanAttribute(String value) throws InvalidAttributeException {
        if ("true".equals(value) || "1".equals(value)) {
            this.value = true;
        } else if ("false".equals(value) || "0".equals(value)) {
            this.value = false;
        } else {
            throw new InvalidAttributeException("Illegal literal value for boolean data-type");
        }
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public Boolean getValue() {
        return this.value ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.getBooleanValue() ? "true" : "false");
    }

    @Override
    public String toString() {
        return this.getBooleanValue() ? "true" : "false";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanAttribute)) {
            return false;
        }
        BooleanAttribute other = (BooleanAttribute)o;
        return this.value == other.value;
    }

    @Override
    public int internalHashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public int compareTo(BooleanAttribute other) {
        if (this.value == other.value) {
            return 0;
        }
        return this.value ? 1 : -1;
    }

    @Override
    public boolean add(BooleanAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends BooleanAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<BooleanAttribute> iterator() {
        return new Iterator<BooleanAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public BooleanAttribute next() {
                this.nextNotCalled = false;
                return BooleanAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((BooleanAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((BooleanAttribute)x0);
    }
}

