/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimeZone;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DateTimeAttribute
extends AttributeValue<DateTimeAttribute> {
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long NANOS_PER_MILLI = 1000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private Calendar value;
    private boolean isTimeZoneExplicit;
    private boolean isHour24;
    private long nanoseconds;

    public DateTimeAttribute(Calendar value) {
        this(value, 0L);
    }

    public DateTimeAttribute(Calendar value, long nanoseconds) {
        this(value, nanoseconds, true);
    }

    public DateTimeAttribute(Calendar value, long nanoseconds, boolean isTimeZoneExplicit) {
        this.value = (Calendar)value.clone();
        this.nanoseconds = this.combineNanoseconds(this.value, nanoseconds);
        this.isTimeZoneExplicit = isTimeZoneExplicit;
        this.isHour24 = false;
    }

    public DateTimeAttribute(String value) throws InvalidAttributeException {
        this(value, false);
    }

    public DateTimeAttribute(String value, boolean lenient) throws InvalidAttributeException {
        char next;
        int second;
        char digit;
        int i;
        int nextDash;
        boolean yearNegative;
        int idx = 0;
        this.checkLength(idx, 1, value);
        if (value.charAt(idx) == '+' && lenient) {
            ++idx;
        }
        boolean bl = yearNegative = value.charAt(idx) == '-';
        if (yearNegative) {
            ++idx;
        }
        if ((nextDash = value.indexOf(45, idx)) < idx + 4) {
            this.throwInvalidAttributeException();
        }
        if (nextDash > idx + 4 && value.charAt(idx) == '0') {
            this.throwInvalidAttributeException();
        }
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        int year = Integer.parseInt(value.substring(idx, nextDash));
        if (yearNegative) {
            year = -1 * year;
        }
        this.checkLength(nextDash, 1, value);
        idx = nextDash + 1;
        nextDash = value.indexOf(45, idx);
        if (!lenient && nextDash != idx + 2) {
            this.throwInvalidAttributeException();
        }
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        int month = Integer.parseInt(value.substring(idx, nextDash));
        if (month < 1 || month > 12) {
            this.throwInvalidAttributeException();
        }
        this.checkLength(nextDash, 1, value);
        idx = nextDash + 1;
        nextDash = value.indexOf(84, idx);
        if (!lenient && nextDash != idx + 2) {
            this.throwInvalidAttributeException();
        }
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        int day = Integer.parseInt(value.substring(idx, nextDash));
        this.checkLength(nextDash, 1, value);
        idx = nextDash + 1;
        nextDash = value.indexOf(58, idx);
        if (!lenient && nextDash != idx + 2) {
            this.throwInvalidAttributeException();
        }
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        int hour = Integer.parseInt(value.substring(idx, nextDash));
        boolean bl2 = this.isHour24 = hour == 24;
        if (hour < 0 || hour > 24) {
            this.throwInvalidAttributeException();
        }
        this.checkLength(nextDash, 1, value);
        idx = nextDash + 1;
        nextDash = value.indexOf(58, idx);
        if (!lenient && nextDash != idx + 2) {
            this.throwInvalidAttributeException();
        }
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        int minute = Integer.parseInt(value.substring(idx, nextDash));
        if (minute < 0 || minute > 59) {
            this.throwInvalidAttributeException();
        }
        if (this.isHour24 && minute != 0) {
            this.throwInvalidAttributeException();
        }
        this.checkLength(nextDash, lenient ? 2 : 3, value);
        idx = nextDash + 1;
        nextDash = idx + 2;
        for (i = idx; i < nextDash; ++i) {
            if (lenient && i >= value.length()) {
                --nextDash;
                continue;
            }
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            if (lenient && i + 1 == nextDash) {
                --nextDash;
                continue;
            }
            this.throwInvalidAttributeException();
        }
        if (nextDash < value.length() && Character.isDigit(value.charAt(nextDash))) {
            this.throwInvalidAttributeException();
        }
        if ((second = Integer.parseInt(value.substring(idx, nextDash))) < 0 || second > 59) {
            this.throwInvalidAttributeException();
        }
        if (this.isHour24 && second != 0) {
            this.throwInvalidAttributeException();
        }
        this.nanoseconds = 0L;
        if (nextDash < value.length() && (next = value.charAt(nextDash)) == '.') {
            this.checkLength(nextDash, 1, value);
            idx = nextDash + 1;
            while (idx < value.length() && Character.isDigit(value.charAt(idx++))) {
            }
            String nanoString = value.substring(nextDash + 1, idx - 1);
            while (nanoString.length() < 9) {
                nanoString = new StringBuffer().append(nanoString).append("0").toString();
            }
            if (nanoString.length() > 9) {
                nanoString = nanoString.substring(0, 9);
            }
            this.nanoseconds = Long.parseLong(nanoString);
            if (this.isHour24 && this.nanoseconds != 0L) {
                this.throwInvalidAttributeException();
            }
            nextDash = idx - 1;
        }
        this.isTimeZoneExplicit = false;
        TimeZone tz = null;
        if (nextDash < value.length()) {
            char next2 = value.charAt(nextDash);
            switch (next2) {
                case 'Z': {
                    tz = TimeZone.getTimeZone("GMT");
                    ++nextDash;
                    break;
                }
                case '+': 
                case '-': {
                    int tzMinute;
                    int tzHour;
                    this.checkLength(nextDash, 6, value);
                    if (!(Character.isDigit(value.charAt(nextDash + 1)) && Character.isDigit(value.charAt(nextDash + 2)) && value.charAt(nextDash + 3) == ':' && Character.isDigit(value.charAt(nextDash + 4)) && Character.isDigit(value.charAt(nextDash + 5)))) {
                        this.throwInvalidAttributeException();
                    }
                    if ((tzHour = Integer.parseInt(value.substring(nextDash + 1, nextDash + 3))) <= 0 || tzHour > 14) {
                        this.throwInvalidAttributeException();
                    }
                    if ((tzMinute = Integer.parseInt(value.substring(nextDash + 4, nextDash + 6))) < 0 || tzMinute > 59 || tzHour == 14 && tzMinute != 0) {
                        this.throwInvalidAttributeException();
                    }
                    tz = TimeZone.getTimeZone(new StringBuffer().append("GMT").append(value.substring(nextDash, nextDash + 6)).toString());
                    nextDash += 6;
                    break;
                }
                default: {
                    this.throwInvalidAttributeException();
                }
            }
            this.isTimeZoneExplicit = true;
            if (nextDash < value.length()) {
                this.throwInvalidAttributeException();
            }
        }
        Calendar cal = tz != null ? Calendar.getInstance(tz) : Calendar.getInstance();
        cal.set(1, year);
        if (cal.getActualMinimum(2) > --month || cal.getActualMaximum(2) < month) {
            this.throwInvalidAttributeException();
        }
        cal.set(2, month);
        if (cal.getActualMinimum(5) > day || cal.getActualMaximum(5) < day) {
            this.throwInvalidAttributeException();
        }
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        this.value = cal;
    }

    private void checkLength(int idx, int length, String value) throws InvalidAttributeException {
        if (idx + (length - 1) >= value.length()) {
            this.throwInvalidAttributeException();
        }
    }

    private void throwInvalidAttributeException() throws InvalidAttributeException {
        throw new InvalidAttributeException("dateTime value does not conform to: '-'? yyyy '-' mm '-' dd 'T' hh ':' mm ':' ss ('.' s+)? (zzzzzz)?");
    }

    private long combineNanoseconds(Calendar value, long nanoseconds) {
        int millis = value.get(14);
        if (millis == 0) {
            return this.canonicalizeNanoseconds(value, nanoseconds);
        }
        value.set(14, 0);
        return this.canonicalizeNanoseconds(value, nanoseconds += (long)millis * 1000000L);
    }

    private long canonicalizeNanoseconds(Calendar value, long nanoseconds) {
        if (nanoseconds >= 1000000000L) {
            int secs = (int)(nanoseconds % 1000000000L);
            value.add(13, secs);
            nanoseconds /= 1000000000L;
        } else if (nanoseconds < 0L) {
            int secs = (int)(nanoseconds / 1000000000L - 1L);
            value.add(13, secs);
            nanoseconds = nanoseconds * -1L / 1000000000L;
        }
        return nanoseconds;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.DATE_TIME;
    }

    @Override
    public Calendar getValue() {
        return this.value;
    }

    public long getNanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public int compareTo(DateTimeAttribute other) {
        int res;
        long ot;
        long t = this.value.getTimeInMillis();
        int n = t == (ot = other.value.getTimeInMillis()) ? 0 : (res = t < ot ? -1 : 1);
        if (res == 0) {
            if (this.nanoseconds == other.nanoseconds) {
                return 0;
            }
            return this.nanoseconds < other.nanoseconds ? -1 : 1;
        }
        return res;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Calendar c = (Calendar)this.value.clone();
        if (this.isHour24) {
            c.roll(5, false);
        }
        String yearString = String.valueOf(c.get(1));
        int ysLength = yearString.length();
        while (ysLength++ < 4) {
            sb.append('0');
        }
        sb.append(yearString);
        sb.append('-');
        String monthString = String.valueOf(c.get(2) + 1);
        if (monthString.length() < 2) {
            sb.append('0');
        }
        sb.append(monthString);
        sb.append('-');
        String dayString = String.valueOf(c.get(5));
        if (dayString.length() < 2) {
            sb.append('0');
        }
        sb.append(dayString);
        sb.append('T');
        if (this.isHour24) {
            sb.append("24:00:00");
        } else {
            String hourString = String.valueOf(c.get(11));
            if (hourString.length() < 2) {
                sb.append('0');
            }
            sb.append(hourString);
            sb.append(':');
            String minuteString = String.valueOf(c.get(12));
            if (minuteString.length() < 2) {
                sb.append('0');
            }
            sb.append(minuteString);
            sb.append(':');
            String secondString = String.valueOf(c.get(13));
            if (secondString.length() < 2) {
                sb.append('0');
            }
            sb.append(secondString);
            if (this.nanoseconds != 0L) {
                int lastIndex;
                String nanoString = String.valueOf(this.nanoseconds);
                for (lastIndex = nanoString.length() - 1; lastIndex >= 0 && nanoString.charAt(lastIndex) == '0'; --lastIndex) {
                }
                sb.append('.');
                sb.append(nanoString.subSequence(0, lastIndex + 1).toString());
            }
        }
        if (this.isTimeZoneExplicit) {
            int offset = c.get(15);
            if (offset == 0) {
                sb.append('Z');
            } else {
                if (offset < 0) {
                    sb.append('-');
                    offset = Math.abs(offset);
                } else {
                    sb.append('+');
                }
                int zoneHours = offset / 3600000;
                String zoneHoursStr = String.valueOf(zoneHours);
                if (zoneHoursStr.length() < 2) {
                    sb.append('0');
                }
                sb.append(zoneHoursStr);
                sb.append(':');
                offset = Math.abs(offset);
                offset = (int)((long)offset - (long)zoneHours * 3600000L);
                String zoneMinutesStr = String.valueOf(offset / 60000);
                if (zoneMinutesStr.length() < 2) {
                    sb.append('0');
                }
                sb.append(zoneMinutesStr);
            }
        }
        return sb.toString();
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.toString());
    }

    @Override
    public boolean equals(Object o) {
        long ot;
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateTimeAttribute)) {
            return false;
        }
        DateTimeAttribute other = (DateTimeAttribute)o;
        long t = this.value.getTimeInMillis();
        return t == (ot = other.value.getTimeInMillis()) && this.nanoseconds == other.nanoseconds;
    }

    @Override
    public int internalHashCode() {
        return this.value.getTime().hashCode();
    }

    @Override
    public boolean add(DateTimeAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends DateTimeAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DateTimeAttribute> iterator() {
        return new Iterator<DateTimeAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public DateTimeAttribute next() {
                this.nextNotCalled = false;
                return DateTimeAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((DateTimeAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((DateTimeAttribute)x0);
    }
}

