/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.ApiLogger;
import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DecimalAttribute
extends AttributeValue<DecimalAttribute> {
    private Double value;

    public DecimalAttribute(Double value) {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.DECIMAL;
    }

    public DecimalAttribute(String value) throws InvalidAttributeException {
        boolean isNegative;
        if (value.length() <= 0) {
            throw new InvalidAttributeException(ApiLogger.getDecimalIsTooShort());
        }
        int idx = 0;
        boolean bl = isNegative = value.charAt(idx) == '-';
        if (isNegative || value.charAt(idx) == '+') {
            ++idx;
        }
        while (idx < value.length() && Character.isDigit(value.charAt(idx))) {
            ++idx;
        }
        int decimalIdx = idx++;
        while (idx < value.length() && Character.isDigit(value.charAt(idx))) {
            ++idx;
        }
        if (idx < value.length()) {
            throw new InvalidAttributeException(ApiLogger.getDecimalIncorrectCharacters());
        }
        this.value = new Double(value);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public int compareTo(DecimalAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecimalAttribute)) {
            return false;
        }
        DecimalAttribute other = (DecimalAttribute)o;
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    @Override
    public int internalHashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean add(DecimalAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends DecimalAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DecimalAttribute> iterator() {
        return new Iterator<DecimalAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public DecimalAttribute next() {
                this.nextNotCalled = false;
                return DecimalAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((DecimalAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((DecimalAttribute)x0);
    }
}

