/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IPAddressAttribute
extends AttributeValue<IPAddressAttribute> {
    private String value;

    public IPAddressAttribute(String value) throws InvalidAttributeException {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.IP_ADDRESS;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.getValue());
    }

    @Override
    public int compareTo(IPAddressAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPAddressAttribute)) {
            return false;
        }
        IPAddressAttribute other = (IPAddressAttribute)o;
        return this.value.equals(other.value);
    }

    @Override
    public int internalHashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean add(IPAddressAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends IPAddressAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IPAddressAttribute> iterator() {
        return new Iterator<IPAddressAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public IPAddressAttribute next() {
                this.nextNotCalled = false;
                return IPAddressAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((IPAddressAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((IPAddressAttribute)x0);
    }
}

