/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LongAttribute
extends AttributeValue<LongAttribute> {
    private long value;

    public LongAttribute(long value) {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.LONG;
    }

    public LongAttribute(Long value) {
        this((long)value);
    }

    public LongAttribute(String value) throws InvalidAttributeException {
        try {
            this.value = Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidAttributeException(nfe);
        }
    }

    public long getLongValue() {
        return this.value;
    }

    @Override
    public Long getValue() {
        return new Long(this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.getLongValue());
    }

    @Override
    public int compareTo(LongAttribute other) {
        if (this.value == other.value) {
            return 0;
        }
        return this.value < other.value ? -1 : 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongAttribute)) {
            return false;
        }
        LongAttribute other = (LongAttribute)o;
        return this.value == other.value;
    }

    @Override
    public int internalHashCode() {
        return (int)this.value;
    }

    @Override
    public boolean add(LongAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends LongAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<LongAttribute> iterator() {
        return new Iterator<LongAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public LongAttribute next() {
                this.nextNotCalled = false;
                return LongAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((LongAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((LongAttribute)x0);
    }
}

