/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class StringAttribute
extends AttributeValue<StringAttribute> {
    private String value;

    public StringAttribute(String value) {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.STRING;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void encodeValue(PrintStream ps) {
        String s = this.getValue();
        if (s.startsWith("<![CDATA[") && s.endsWith("]]>")) {
            ps.print(s);
        } else {
            block7: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '<': {
                        ps.print("&lt;");
                        continue block7;
                    }
                    case '>': {
                        ps.print("&gt;");
                        continue block7;
                    }
                    case '&': {
                        ps.print("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        ps.print("&apos;");
                        continue block7;
                    }
                    case '\"': {
                        ps.print("&quot;");
                        continue block7;
                    }
                    default: {
                        ps.print(c);
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(StringAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringAttribute)) {
            return false;
        }
        StringAttribute other = (StringAttribute)o;
        return this.value.equals(other.value);
    }

    @Override
    public int internalHashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean add(StringAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends StringAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<StringAttribute> iterator() {
        return new Iterator<StringAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public StringAttribute next() {
                this.nextNotCalled = false;
                return StringAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((StringAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((StringAttribute)x0);
    }
}

