/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.ApiLogger;
import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class YearMonthDurationAttribute
extends AttributeValue<YearMonthDurationAttribute> {
    private static final int MONTHS_PER_YEAR = 12;
    private boolean isDurationNegative;
    private int year;
    private int month;
    private Integer value;

    public YearMonthDurationAttribute(int year, int month) throws InvalidAttributeException {
        this.isDurationNegative = year < 0;
        this.year = Math.abs(year);
        if (month < 0) {
            this.isDurationNegative = true;
            if (year != 0) {
                throw new InvalidAttributeException(ApiLogger.getNegativeMonthNonZeroYear());
            }
        }
        this.month = Math.abs(month);
        if (year == 0 && month == 0) {
            throw new InvalidAttributeException(ApiLogger.getMonthOrYearBothZero());
        }
        this.value = new Integer(year * 12 + month);
        this.value = new Integer(this.isDurationNegative ? -1 * this.value : this.value);
    }

    public YearMonthDurationAttribute(String value) throws InvalidAttributeException {
        int endOfNumber;
        this.year = 0;
        this.month = 0;
        int idx = 0;
        this.checkLength(idx, 1, value);
        boolean bl = this.isDurationNegative = value.charAt(idx) == '-';
        if (this.isDurationNegative) {
            ++idx;
        }
        this.checkLength(idx, 1, value);
        if (value.charAt(idx++) != 'P') {
            this.throwInvalidAttributeException();
        }
        for (endOfNumber = idx; endOfNumber < value.length() && Character.isDigit(value.charAt(endOfNumber)); ++endOfNumber) {
        }
        if (endOfNumber == idx || endOfNumber == value.length()) {
            this.throwInvalidAttributeException();
        }
        int number = Integer.parseInt(value.substring(idx, endOfNumber));
        idx = endOfNumber;
        this.checkLength(idx, 1, value);
        char token = value.charAt(idx);
        switch (token) {
            case 'Y': {
                this.year = number;
                if (++idx >= value.length()) break;
                for (endOfNumber = idx; endOfNumber < value.length() && Character.isDigit(value.charAt(endOfNumber)); ++endOfNumber) {
                }
                if (endOfNumber == idx || endOfNumber == value.length()) {
                    this.throwInvalidAttributeException();
                }
                number = Integer.parseInt(value.substring(idx, endOfNumber));
                idx = endOfNumber;
                this.checkLength(idx, 1, value);
                if (value.charAt(idx) != 'M') {
                    this.throwInvalidAttributeException();
                }
            }
            case 'M': {
                this.month = number;
                if (++idx == value.length()) break;
                this.throwInvalidAttributeException();
                break;
            }
            default: {
                this.throwInvalidAttributeException();
            }
        }
        if (this.year == 0 && this.month == 0) {
            throw new InvalidAttributeException(ApiLogger.getMonthOrYearBothZero());
        }
        if (this.month >= 12) {
            this.year += this.month / 12;
            this.month %= 12;
        }
        this.value = new Integer(this.year * 12 + this.month);
        this.value = new Integer(this.isDurationNegative ? -1 * this.value : this.value);
    }

    private void checkLength(int idx, int length, String value) throws InvalidAttributeException {
        if (idx + (length - 1) >= value.length()) {
            this.throwInvalidAttributeException();
        }
    }

    private void throwInvalidAttributeException() throws InvalidAttributeException {
        throw new InvalidAttributeException("yearMonthDuration value does not conform to: [-]?P\\p{Nd}+(Y(\\p{Nd}+M)?|M)");
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.YEAR_MONTH_DURATION;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public Integer getDuration() {
        return this.value;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isDurationNegative) {
            sb.append('-');
        }
        sb.append('P');
        if (this.year != 0) {
            sb.append(String.valueOf(this.year));
            sb.append('Y');
        }
        if (this.month != 0) {
            sb.append(String.valueOf(this.month));
            sb.append('M');
        }
        return sb.toString();
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.toString());
    }

    @Override
    public int compareTo(YearMonthDurationAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof YearMonthDurationAttribute)) {
            return false;
        }
        YearMonthDurationAttribute other = (YearMonthDurationAttribute)o;
        return this.value.equals(other.value);
    }

    @Override
    public int internalHashCode() {
        return this.value;
    }

    @Override
    public boolean add(YearMonthDurationAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends YearMonthDurationAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<YearMonthDurationAttribute> iterator() {
        return new Iterator<YearMonthDurationAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public YearMonthDurationAttribute next() {
                this.nextNotCalled = false;
                return YearMonthDurationAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((YearMonthDurationAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((YearMonthDurationAttribute)x0);
    }
}

