/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import com.bea.common.security.xacml.context.Result;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response
extends ContextSchemaObject {
    private static final long serialVersionUID = 7313125996953919175L;
    private List<Result> results;

    public Response(List<Result> results) {
        this.results = results != null ? Collections.unmodifiableList(results) : null;
    }

    public Response(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        this.results = new ArrayList<Result>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("Result")) continue;
            this.results.add(new Result(registry, node));
        }
        this.results = this.results.isEmpty() ? null : Collections.unmodifiableList(this.results);
    }

    @Override
    public String getElementName() {
        return "Response";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.results != null) {
            for (Result r : this.results) {
                r.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Response)) {
            return false;
        }
        Response o = (Response)other;
        return CollectionUtil.equals(this.results, o.results);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.results);
        return result;
    }

    public List<Result> getResults() {
        return this.results;
    }
}

