/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import java.io.PrintStream;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCode
extends ContextSchemaObject {
    private static final long serialVersionUID = 4530626546880091118L;
    private static final String OK_CODE = "urn:oasis:names:tc:xacml:1.0:status:ok";
    private StatusCode code;
    private URI value;

    public StatusCode(URI value) {
        this(value, null);
    }

    public StatusCode(URI value, StatusCode code) {
        this.value = value;
        this.code = code;
    }

    public StatusCode(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.value = new URI(attrs.getNamedItem("Value").getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = this.getLocalName(child);
            if (!cname.equals("StatusCode")) continue;
            this.code = new StatusCode(registry, child);
        }
    }

    @Override
    public String getElementName() {
        return "StatusCode";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        ps.print(" Value=\"");
        ps.print(this.value);
        ps.print("\"");
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.code != null) {
            this.code.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null && (this.value == null || OK_CODE.equals(this.value.toString()))) {
            return true;
        }
        if (!(other instanceof StatusCode)) {
            return false;
        }
        StatusCode o = (StatusCode)other;
        return (this.value == o.value || this.value != null && this.value.equals(o.value)) && (this.code == o.code || this.code != null && this.code.equals(o.code));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.value);
        result = HashCodeUtil.hash((int)result, (Object)this.code);
        return result;
    }

    public URI getValue() {
        return this.value;
    }

    public StatusCode getStatusCode() {
        return this.code;
    }
}

