/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.CombinerParameters;
import com.bea.common.security.xacml.policy.IdReference;
import com.bea.common.security.xacml.policy.Obligations;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import com.bea.common.security.xacml.policy.PolicySetMember;
import com.bea.common.security.xacml.policy.Target;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolicy
extends PolicySchemaObject
implements PolicySetMember {
    public static final String VERSION_DEFAULT = "1.0";
    private String description;
    private Target target;
    private List<CombinerParameters> combinerParameters;
    private URI id;
    private String version;
    private URI combiningAlgId;
    private Obligations obligations;

    public AbstractPolicy(URI id, Target target, URI combiningAlgId) {
        this(id, target, combiningAlgId, null);
    }

    public AbstractPolicy(URI id, Target target, URI combiningAlgId, String description) {
        this(id, target, combiningAlgId, description, VERSION_DEFAULT);
    }

    public AbstractPolicy(URI id, Target target, URI combiningAlgId, String description, String version) {
        this(id, target, combiningAlgId, description, version, null, null);
    }

    public AbstractPolicy(URI id, Target target, URI combiningAlgId, String description, String version, List<CombinerParameters> combinerParameters, Obligations obligations) {
        this.description = description;
        this.target = target;
        this.combinerParameters = combinerParameters != null ? Collections.unmodifiableList(combinerParameters) : null;
        this.id = id;
        this.version = version;
        this.combiningAlgId = combiningAlgId;
        this.obligations = obligations;
    }

    protected AbstractPolicy(AttributeRegistry registry, Node root, String policyPrefix, String combiningName) throws DocumentParseException, URISyntaxException {
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.id = new URI(attrs.getNamedItem(new StringBuffer().append(policyPrefix).append("Id").toString()).getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        Node versionNode = attrs.getNamedItem("Version");
        this.version = versionNode != null ? versionNode.getNodeValue() : VERSION_DEFAULT;
        try {
            this.combiningAlgId = new URI(attrs.getNamedItem(combiningName).getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        this.combinerParameters = new ArrayList<CombinerParameters>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = this.getLocalName(child);
            if (cname.equals("Description")) {
                Node dchild = child.getFirstChild();
                if (dchild == null) continue;
                this.description = dchild.getNodeValue();
                continue;
            }
            if (cname.equals("Target")) {
                this.target = new Target(registry, child);
                continue;
            }
            if (cname.equals("Obligations")) {
                this.obligations = new Obligations(registry, child);
                continue;
            }
            if (!cname.equals("CombinerParameters")) continue;
            this.combinerParameters.add(new CombinerParameters(registry, child));
        }
        this.combinerParameters = this.combinerParameters.isEmpty() ? null : Collections.unmodifiableList(this.combinerParameters);
    }

    protected abstract String getPolicyPrefix();

    protected abstract String getCombiningName();

    public abstract IdReference getReference();

    @Override
    public void encodeAttributes(PrintStream ps) {
        ps.print(' ');
        ps.print(this.getPolicyPrefix());
        ps.print("Id=\"");
        ps.print(this.id);
        ps.print("\"");
        if (this.version != null && !VERSION_DEFAULT.equals(this.version)) {
            ps.print(" Version=\"");
            ps.print(this.version);
            ps.print("\"");
        }
        ps.print(" ");
        ps.print(this.getCombiningName());
        ps.print("=\"");
        ps.print(this.combiningAlgId);
        ps.print("\"");
    }

    protected void encodeDescription(PrintStream ps) {
        if (this.description != null) {
            ps.print("<Description>");
            if (this.description.startsWith("<![CDATA[") && this.description.endsWith("]]>")) {
                ps.print(this.description);
            } else {
                block7: for (int i = 0; i < this.description.length(); ++i) {
                    char c = this.description.charAt(i);
                    switch (c) {
                        case '<': {
                            ps.print("&lt;");
                            continue block7;
                        }
                        case '>': {
                            ps.print("&gt;");
                            continue block7;
                        }
                        case '&': {
                            ps.print("&amp;");
                            continue block7;
                        }
                        case '\'': {
                            ps.print("&apos;");
                            continue block7;
                        }
                        case '\"': {
                            ps.print("&quot;");
                            continue block7;
                        }
                        default: {
                            ps.print(c);
                        }
                    }
                }
            }
            ps.print("</Description>");
        }
    }

    protected void encodeTarget(Map<String, String> nsMap, PrintStream ps) {
        if (this.target != null) {
            this.target.encode(nsMap, ps);
        }
    }

    protected void encodeCombinerParameters(Map<String, String> nsMap, PrintStream ps) {
        if (this.combinerParameters != null) {
            for (CombinerParameters cp : this.combinerParameters) {
                cp.encode(nsMap, ps);
            }
        }
    }

    protected void encodeObligations(Map<String, String> nsMap, PrintStream ps) {
        if (this.obligations != null) {
            this.obligations.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractPolicy)) {
            return false;
        }
        AbstractPolicy o = (AbstractPolicy)other;
        return (this.target == o.target || this.target != null && this.target.equals(o.target)) && (this.id == o.id || this.id != null && this.id.equals(o.id)) && CollectionUtil.equals(this.combinerParameters, o.combinerParameters) && (this.version == o.version || this.version != null && this.version.equals(o.version) || this.version == null && VERSION_DEFAULT.equals(o.version) || o.version == null && VERSION_DEFAULT.equals(this.version)) && (this.combiningAlgId == o.combiningAlgId || this.combiningAlgId != null && this.combiningAlgId.equals(o.combiningAlgId)) && (this.obligations == o.obligations || this.obligations != null && this.obligations.equals(o.obligations));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.target);
        result = HashCodeUtil.hash((int)result, (Object)this.id);
        result = HashCodeUtil.hash((int)result, this.combinerParameters);
        result = HashCodeUtil.hash((int)result, (Object)(this.version != null ? this.version : VERSION_DEFAULT));
        result = HashCodeUtil.hash((int)result, (Object)this.combiningAlgId);
        result = HashCodeUtil.hash((int)result, (Object)this.obligations);
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public Target getTarget() {
        return this.target;
    }

    public List<CombinerParameters> getCombinerParameters() {
        return this.combinerParameters;
    }

    public URI getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version == null ? VERSION_DEFAULT : this.version;
    }

    public URI getCombiningAlgId() {
        return this.combiningAlgId;
    }

    public Obligations getObligations() {
        return this.obligations;
    }
}

