/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.CombinerParameter;
import com.bea.common.security.xacml.policy.CombinerParameters;
import java.net.URI;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolicyCombinerParameters
extends CombinerParameters {
    private URI idRef;

    public AbstractPolicyCombinerParameters(List<CombinerParameter> combinerParameters, URI idRef) {
        super(combinerParameters);
        this.idRef = idRef;
    }

    protected AbstractPolicyCombinerParameters(AttributeRegistry registry, Node root, String policyPrefix) throws URISyntaxException, DocumentParseException {
        super(registry, root);
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.idRef = new URI(attrs.getNamedItem(new StringBuffer().append(policyPrefix).append("IdRef").toString()).getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AbstractPolicyCombinerParameters)) {
            return false;
        }
        AbstractPolicyCombinerParameters o = (AbstractPolicyCombinerParameters)other;
        return this.idRef == o.idRef || this.idRef != null && this.idRef.equals(o.idRef);
    }

    @Override
    public int internalHashCode() {
        int result = super.internalHashCode();
        result = HashCodeUtil.hash((int)result, (Object)this.idRef);
        return result;
    }

    public URI getIdRef() {
        return this.idRef;
    }
}

