/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.ActionAttributeDesignator;
import com.bea.common.security.xacml.policy.AttributeSelector;
import com.bea.common.security.xacml.policy.AttributeValue;
import com.bea.common.security.xacml.policy.Match;
import java.io.PrintStream;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMatch
extends Match {
    private static final long serialVersionUID = 2825824823451900639L;
    private ActionAttributeDesignator designator;

    public ActionMatch(URI matchId, AttributeValue attributeValue, AttributeSelector selector) {
        super(matchId, attributeValue, selector);
    }

    public ActionMatch(URI matchId, com.bea.common.security.xacml.attr.AttributeValue attributeValue, AttributeSelector selector) {
        super(matchId, attributeValue, selector);
    }

    public ActionMatch(URI matchId, AttributeValue attributeValue, ActionAttributeDesignator designator) {
        super(matchId, attributeValue);
        this.designator = designator;
    }

    public ActionMatch(URI matchId, com.bea.common.security.xacml.attr.AttributeValue attributeValue, ActionAttributeDesignator designator) {
        super(matchId, attributeValue);
        this.designator = designator;
    }

    public ActionMatch(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        super(registry, root);
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("ActionAttributeDesignator")) continue;
            this.designator = new ActionAttributeDesignator(node);
        }
    }

    @Override
    public String getElementName() {
        return "ActionMatch";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        this.encodeLeadElements(nsMap, ps);
        if (this.designator != null) {
            this.designator.encode(nsMap, ps);
        }
        this.encodeTrailingElements(nsMap, ps);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof ActionMatch)) {
            return false;
        }
        ActionMatch o = (ActionMatch)other;
        return this.designator == o.designator || this.designator != null && this.designator.equals(o.designator);
    }

    @Override
    public int internalHashCode() {
        int result = super.internalHashCode();
        result = HashCodeUtil.hash((int)result, (Object)this.designator);
        return result;
    }

    public ActionAttributeDesignator getDesignator() {
        return this.designator;
    }
}

