/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.CombinerParameter;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinerParameters
extends PolicySchemaObject {
    private static final long serialVersionUID = 1911437923550411399L;
    private List<CombinerParameter> combinerParameters;

    public CombinerParameters(List<CombinerParameter> combinerParameters) {
        this.combinerParameters = combinerParameters != null ? Collections.unmodifiableList(combinerParameters) : null;
    }

    public CombinerParameters(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<CombinerParameter> combinerParameters = new ArrayList<CombinerParameter>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("CombinerParameter")) continue;
            combinerParameters.add(new CombinerParameter(registry, node));
        }
        this.combinerParameters = Collections.unmodifiableList(combinerParameters);
    }

    @Override
    public String getElementName() {
        return "CombinerParameters";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.combinerParameters != null) {
            Iterator<CombinerParameter> it = this.combinerParameters.iterator();
            while (it.hasNext()) {
                it.next().encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CombinerParameters)) {
            return false;
        }
        CombinerParameters o = (CombinerParameters)other;
        return CollectionUtil.equals(this.combinerParameters, o.combinerParameters);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.combinerParameters);
        return result;
    }

    private List<CombinerParameter> getCombinerParameters() {
        return this.combinerParameters;
    }
}

