/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.SchemaObject;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.Expression;
import com.bea.common.security.xacml.policy.ExpressionHandler;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Condition
extends PolicySchemaObject
implements Expression {
    private static final long serialVersionUID = -7226434320286848507L;
    private Expression expression;

    public Condition(Expression expression) {
        this.expression = expression;
    }

    public Condition(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            this.expression = ExpressionHandler.parseExpression(registry, node);
            if (this.expression != null) break;
        }
    }

    @Override
    public String getElementName() {
        return "Condition";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        ((SchemaObject)((Object)this.expression)).encode(nsMap, ps);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Condition)) {
            return false;
        }
        Condition o = (Condition)other;
        return this.expression == o.expression || this.expression != null && this.expression.equals(o.expression);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.expression);
        return result;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

