/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.ApiLogger;
import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Defaults
extends PolicySchemaObject {
    public static final String XPATH_1_0_VERSION = "http://www.w3.org/TR/1999/Rec-xpath-19991116";
    private String xPathVersion;

    public Defaults(String xPathVersion) {
        this.xPathVersion = xPathVersion;
    }

    public Defaults(Node root) throws DocumentParseException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("XPathVersion")) continue;
            this.xPathVersion = node.getFirstChild().getNodeValue();
            if (this.xPathVersion.equals(XPATH_1_0_VERSION)) continue;
            throw new DocumentParseException(ApiLogger.getIncorrectXPathVersion());
        }
    }

    protected abstract String getPolicyPrefix();

    @Override
    public String getElementName() {
        return new StringBuffer().append(this.getPolicyPrefix()).append("Defaults").toString();
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.xPathVersion != null) {
            ps.print("<XPathVersion>");
            ps.print(this.xPathVersion);
            ps.print("</XPathVersion>");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Defaults)) {
            return false;
        }
        Defaults o = (Defaults)other;
        return this.xPathVersion == o.xPathVersion || this.xPathVersion != null && this.xPathVersion.equals(o.xPathVersion);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.xPathVersion);
        return result;
    }

    public String getXPathVersion() {
        return this.xPathVersion;
    }
}

