/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.Environment;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environments
extends PolicySchemaObject {
    private static final long serialVersionUID = 6364232423064766589L;
    private List<Environment> contents;

    public Environments(List<Environment> actions) {
        this.contents = actions != null ? Collections.unmodifiableList(actions) : null;
    }

    public Environments(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<Environment> contents = new ArrayList<Environment>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("Environment")) continue;
            contents.add(new Environment(registry, node));
        }
        this.contents = Collections.unmodifiableList(contents);
    }

    @Override
    public String getElementName() {
        return "Environments";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.contents != null) {
            for (Environment m : this.contents) {
                m.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Environments)) {
            return false;
        }
        Environments o = (Environments)other;
        return CollectionUtil.equals(this.contents, o.contents);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.contents);
        return result;
    }

    public List<Environment> getEnvironments() {
        return this.contents;
    }
}

