/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.AttributeSelector;
import com.bea.common.security.xacml.policy.AttributeValue;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Match
extends PolicySchemaObject {
    private AttributeValue attributeValue;
    private URI matchId;
    private AttributeSelector selector;

    protected Match(URI matchId, AttributeValue attributeValue) {
        this(matchId, attributeValue, null);
    }

    protected Match(URI matchId, com.bea.common.security.xacml.attr.AttributeValue attributeValue) {
        this(matchId, attributeValue, null);
    }

    public Match(URI matchId, com.bea.common.security.xacml.attr.AttributeValue attributeValue, AttributeSelector selector) {
        this(matchId, attributeValue != null ? new AttributeValue(attributeValue) : null, selector);
    }

    public Match(URI matchId, AttributeValue attributeValue, AttributeSelector selector) {
        this.matchId = matchId;
        this.attributeValue = attributeValue;
        this.selector = selector;
    }

    protected Match(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        try {
            this.matchId = new URI(root.getAttributes().getNamedItem("MatchId").getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String cname = this.getLocalName(node);
            if (cname.equals("AttributeValue")) {
                com.bea.common.security.xacml.attr.AttributeValue av = registry.getAttribute(node);
                if (av == null) continue;
                this.attributeValue = new AttributeValue(av);
                continue;
            }
            if (!cname.equals("AttributeSelector")) continue;
            this.selector = new AttributeSelector(node);
        }
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        ps.print(" MatchId=\"");
        ps.print(this.matchId);
        ps.print("\"");
    }

    protected void encodeLeadElements(Map<String, String> nsMap, PrintStream ps) {
        this.attributeValue.encode(nsMap, ps);
    }

    protected void encodeTrailingElements(Map<String, String> nsMap, PrintStream ps) {
        if (this.selector != null) {
            this.selector.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Match)) {
            return false;
        }
        Match o = (Match)other;
        return (this.attributeValue == o.attributeValue || this.attributeValue != null && this.attributeValue.equals(o.attributeValue)) && (this.matchId == o.matchId || this.matchId != null && this.matchId.equals(o.matchId)) && (this.selector == o.selector || this.selector != null && this.selector.equals(o.selector));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.attributeValue);
        result = HashCodeUtil.hash((int)result, (Object)this.matchId);
        result = HashCodeUtil.hash((int)result, (Object)this.selector);
        return result;
    }

    public AttributeValue getAttributeValue() {
        return this.attributeValue;
    }

    public URI getMatchId() {
        return this.matchId;
    }

    public AttributeSelector getAttributeSelector() {
        return this.selector;
    }
}

